 /*
 * EnterpriseGroupDepartmentMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

 import br.com.petrobras.security.model.EnterpriseGroup;
 import br.com.petrobras.security.model.EnterpriseGroupDepartment;
 import br.com.petrobras.security.server.service.soap.EnterpriseGroupDTO;
 import br.com.petrobras.security.server.service.soap.EnterpriseGroupDepartmentDTO;

 import javax.xml.datatype.DatatypeConfigurationException;

/**
 * Montador da associao de lotao de empregado com grupo corporativo.
 * 
 * @author Eraldo Neto - HMGL
 * @since 3.0
 * @version 1.0
 * 
 */
public class EnterpriseGroupDepartmentMounter {

    /**
     * Monta uma associao de lotao e grupo corporativo do modelo a partir de
     * uma associao de lotao e grupo corporativo de transferncia.
     * 
     * @param enterpriseGroupDepartmentDTO
     *            Associao de lotao e grupo corporativo de transferncia.
     * 
     * @param enterpriseGroup
     *            Grupo corporativo
     * 
     * @return Associao de lotao e grupo corporativo do modelo.
     */
    public static EnterpriseGroupDepartment mountLocalObject(
            EnterpriseGroupDepartmentDTO enterpriseGroupDepartmentDTO,
            EnterpriseGroup enterpriseGroup) {
        if (enterpriseGroupDepartmentDTO == null) {
            return null;
        }

        EnterpriseGroupDepartment enterpriseGroupDepartment = new EnterpriseGroupDepartment();
        enterpriseGroupDepartment.setUid(enterpriseGroupDepartment.getUid());
        enterpriseGroupDepartment.setHierarchy(enterpriseGroupDepartmentDTO.isHierarchy());
        enterpriseGroupDepartment.setCreationDate(DateMounter.mountLocalObject(enterpriseGroupDepartmentDTO.getCreationDate()));
        enterpriseGroupDepartment.setDepartment(DepartmentMounter.mountLocalObject(enterpriseGroupDepartmentDTO.getDepartment()));
        enterpriseGroupDepartment.setEnterpriseGroup(enterpriseGroup);


        return enterpriseGroupDepartment;
    }

    /**
     * Monta uma associao de lotao e grupo corporativo de transferncia a
     * partir de uma associao de lotao e grupo corporativo do modelo.
     * 
     * @param enterpriseGroupDepartment
     *            Associao entre lotao e grupo corporativo.
     * 
     * @param enterpriseGroup
     *            Grupo corporativo de transferncia.
     * 
     * @return Associao de lotao e grupo corporativo de transferncia.
     */
    public static EnterpriseGroupDepartmentDTO mountTransferObject(
            EnterpriseGroupDepartment enterpriseGroupDepartment,
            EnterpriseGroupDTO enterpriseGroup) {
        if (enterpriseGroupDepartment == null) {
            return null;
        }

        EnterpriseGroupDepartmentDTO enterpriseGroupDepartmentDTO = new EnterpriseGroupDepartmentDTO();
        enterpriseGroupDepartmentDTO.setUid(enterpriseGroupDepartment.getUid());
        enterpriseGroupDepartmentDTO.setHierarchy(enterpriseGroupDepartment.getHierarchy());

        try {
            enterpriseGroupDepartmentDTO.setCreationDate(DateMounter
                    .mountTransferObject(enterpriseGroupDepartment
                            .getCreationDate()));
        } catch (DatatypeConfigurationException dce) {
            enterpriseGroupDepartmentDTO.setCreationDate(null);
        }

        enterpriseGroupDepartmentDTO
                .setDepartment(DepartmentMounter
                        .mountTransferObject(enterpriseGroupDepartment
                                .getDepartment()));
        enterpriseGroupDepartmentDTO.setEnterpriseGroupId(enterpriseGroup.getId());

        return enterpriseGroupDepartmentDTO;
    }
}
