/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.client.RespControlVector;
import com.novell.ldap.rfc2251.RfcControl;
import com.novell.ldap.rfc2251.RfcLDAPOID;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPControl
implements Cloneable,
Externalizable {
    private static RespControlVector registeredControls = new RespControlVector(5, 5);
    private RfcControl control;

    public LDAPControl() {
    }

    public LDAPControl(String string, boolean bl, byte[] byArray) {
        if (string == null) {
            throw new IllegalArgumentException("An OID must be specified");
        }
        this.control = byArray == null ? new RfcControl(new RfcLDAPOID(string), new ASN1Boolean(bl)) : new RfcControl(new RfcLDAPOID(string), new ASN1Boolean(bl), new ASN1OctetString(byArray));
    }

    protected LDAPControl(RfcControl rfcControl) {
        this.control = rfcControl;
    }

    public Object clone() {
        LDAPControl lDAPControl;
        try {
            lDAPControl = (LDAPControl)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
        byte[] byArray = this.getValue();
        byte[] byArray2 = null;
        if (byArray != null) {
            byArray2 = new byte[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray2[i] = byArray[i];
            }
            lDAPControl.control = new RfcControl(new RfcLDAPOID(this.getID()), new ASN1Boolean(this.isCritical()), new ASN1OctetString(byArray2));
        }
        return lDAPControl;
    }

    public String getID() {
        return new String(this.control.getControlType().stringValue());
    }

    public byte[] getValue() {
        byte[] byArray = null;
        ASN1OctetString aSN1OctetString = this.control.getControlValue();
        if (aSN1OctetString != null) {
            byArray = aSN1OctetString.byteValue();
        }
        return byArray;
    }

    protected void setValue(byte[] byArray) {
        this.control.setControlValue(new ASN1OctetString(byArray));
    }

    public boolean isCritical() {
        return this.control.getCriticality().booleanValue();
    }

    public static void register(String string, Class clazz) {
        registeredControls.registerResponseControl(string, clazz);
    }

    static RespControlVector getRegisteredControls() {
        return registeredControls;
    }

    final RfcControl getASN1Object() {
        return this.control;
    }

    void newLine(int n, Writer writer) throws IOException {
        String string = "    ";
        writer.write("\n");
        for (int i = 0; i < n; ++i) {
            writer.write(string);
        }
    }

    public void writeDSML(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        int n = 0;
        outputStreamWriter.write("<control type=\"");
        outputStreamWriter.write(this.getID());
        outputStreamWriter.write("\" criticality=\"" + this.isCritical() + "\"");
        byte[] byArray = this.getValue();
        if (byArray == null) {
            outputStreamWriter.write("/>");
        } else {
            outputStreamWriter.write(">");
            this.newLine(n + 1, outputStreamWriter);
            outputStreamWriter.write("<controlValue xsi:type=\"xsd:base64Binary\">");
            outputStreamWriter.write(Base64.encode(byArray));
            outputStreamWriter.write("</controlValue>");
            this.newLine(n, outputStreamWriter);
            outputStreamWriter.write("</control>");
        }
        ((Writer)outputStreamWriter).close();
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPControl.getXMLHandler("control", null));
        return (LDAPControl)sAXEventMultiplexer.parseXML(inputStream);
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String oid;
            boolean critical;
            byte[] controlvalue;

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler("controlValue", this));
            }

            protected void endElement() {
                LDAPControl lDAPControl = new LDAPControl(this.oid, this.critical, this.controlvalue);
                this.setObject(lDAPControl);
            }

            protected void addValue(String string, Object object) {
                if (string.equals("controlValue")) {
                    this.controlvalue = (byte[])object;
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.oid = attributes.getValue("type");
                if (this.oid == null) {
                    throw new SAXException("type is mandatory for a Control");
                }
                this.critical = "true".equalsIgnoreCase(attributes.getValue("criticality"));
            }
        };
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LDAPControl: ");
        stringBuffer.append("((oid=" + this.getID() + "");
        stringBuffer.append(",critical=" + this.isCritical() + ")");
        stringBuffer.append("(value=" + this.getValue() + "))");
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append(ValueXMLhandler.newLine(0));
        String string = "";
        string = string + "*************************************************************************\n";
        string = string + "** The encrypted data above and below is the Class definition and  ******\n";
        string = string + "** other data specific to Java Serialization Protocol. The data  ********\n";
        string = string + "** which is of most application specific interest is as follows... ******\n";
        string = string + "*************************************************************************\n";
        string = string + "****************** Start of application data ****************************\n";
        string = string + "*************************************************************************\n";
        stringBuffer.append(string);
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append("<control type=\"");
        stringBuffer.append(this.getID());
        stringBuffer.append("\" criticality=\"" + this.isCritical() + "\"");
        byte[] byArray = this.getValue();
        if (byArray == null) {
            stringBuffer.append("/>");
        } else {
            stringBuffer.append(">");
            stringBuffer.append(ValueXMLhandler.newLine(1));
            stringBuffer.append("<controlValue xsi:type=\"xsd:base64Binary\">");
            stringBuffer.append(Base64.encode(byArray));
            stringBuffer.append("</controlValue>");
            stringBuffer.append(ValueXMLhandler.newLine(0));
            stringBuffer.append("</control>");
        }
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append(ValueXMLhandler.newLine(0));
        String string2 = "";
        string2 = string2 + "*************************************************************************\n";
        string2 = string2 + "****************** End of application data ******************************\n";
        string2 = string2 + "*************************************************************************\n";
        stringBuffer.append(string2);
        stringBuffer.append(ValueXMLhandler.newLine(0));
        objectOutput.writeUTF(stringBuffer.toString());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = objectInput.readUTF();
        String string2 = string.substring(string.indexOf(60), string.lastIndexOf(62) + 1);
        StringBuffer stringBuffer = new StringBuffer();
        ValueXMLhandler.parseInput(string2, stringBuffer);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(stringBuffer.toString().getBytes()));
        LDAPControl lDAPControl = (LDAPControl)LDAPControl.readDSML(bufferedInputStream);
        byte[] byArray = lDAPControl.getValue();
        this.control = byArray == null ? new RfcControl(new RfcLDAPOID(lDAPControl.getID()), new ASN1Boolean(lDAPControl.isCritical())) : new RfcControl(new RfcLDAPOID(lDAPControl.getID()), new ASN1Boolean(lDAPControl.isCritical()), new ASN1OctetString(byArray));
        lDAPControl = null;
    }
}

