/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ChangeAddressEventData
implements EventResponseData {
    private final int flags;
    private final int proto;
    private final int addrFamily;
    private final String address;
    private final String pstkName;
    private final String source;

    public ChangeAddressEventData(ASN1Object aSN1Object) throws IOException {
        byte[] byArray = ((ASN1OctetString)aSN1Object).byteValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LBERDecoder lBERDecoder = new LBERDecoder();
        int[] nArray = new int[1];
        this.flags = ((ASN1Integer)lBERDecoder.decode(byteArrayInputStream, nArray)).intValue();
        this.proto = ((ASN1Integer)lBERDecoder.decode(byteArrayInputStream, nArray)).intValue();
        this.addrFamily = ((ASN1Integer)lBERDecoder.decode(byteArrayInputStream, nArray)).intValue();
        this.address = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.pstkName = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.source = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
    }

    public String getAddress() {
        return this.address;
    }

    public int getAddrFamily() {
        return this.addrFamily;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getProto() {
        return this.proto;
    }

    public String getPstkName() {
        return this.pstkName;
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ChangeAddresssEvent[flags=" + this.getFlags() + "]");
        stringBuffer.append("[proto=" + this.getProto() + "]");
        stringBuffer.append("[addrFamily=" + this.getAddrFamily() + "]");
        stringBuffer.append("[address=" + this.getAddress() + "]");
        stringBuffer.append("[pstkName=" + this.getPstkName() + "]");
        stringBuffer.append("[source=" + this.getSource() + "]]");
        return stringBuffer.toString();
    }
}

