package csbase.rest.adapter.algorithm.v1;

import csbase.logic.algorithms.parameters.triggers.*;
import ibase.rest.model.algorithm.v1.Action;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by mjulia on 27/03/2017.
 */
public class ActionMapper {

    private Map<Class<? extends Trigger>, Action.NameEnum> map;

    public ActionMapper() {
        load();
    }

    private  void load() {
        this.map = new HashMap<>();
        map.put(ShowGroupTrigger.class, Action.NameEnum.SHOWGROUP);
        map.put(ShowParameterTrigger.class, Action.NameEnum.SHOWPARAMETER);
        map.put(EnableParameterTrigger.class, Action.NameEnum.ENABLEPARAMETER);
        map.put(HideGroupTrigger.class, Action.NameEnum.HIDEGROUP);
        map.put(HideParameterTrigger.class, Action.NameEnum.HIDEPARAMETER);
        map.put(DisableParameterTrigger.class, Action.NameEnum.DISABLEPARAMETER);
    }
    public Action.NameEnum getActionFor (Class<? extends Trigger> triggerClass) {
        Action.NameEnum action = map.get(triggerClass);
        if (action==null) {
            return Action.NameEnum.UNKNOWN;
        }
        return action;
    }
}
