package csbase.rest.adapter.algorithm.v1;

import csbase.logic.algorithms.parameters.SimpleParameter;
import ibase.rest.model.algorithm.v1.Parameter;

/**
 * Created by mjulia on 12/06/16.
 */
public class BooleanParameterFactory  implements  ParameterFactory {

    public ibase.rest.model.algorithm.v1.Parameter buildParameter(SimpleParameter p) {
        csbase.logic.algorithms.parameters.BooleanParameter csbaseParam =
                csbase.logic.algorithms.parameters.BooleanParameter.class.cast(p);
        ibase.rest.model.algorithm.v1.BooleanParameter parameter =
                new ibase.rest.model.algorithm.v1.BooleanParameter();
        setCommonAttributes(parameter, csbaseParam);
        parameter.setType(Parameter.TypeEnum.BOOLEAN);
        parameter.setTrueValue(csbaseParam.getTrueCommand());
        parameter.setFalseValue(csbaseParam.getFalseCommand());
        return parameter;
    }
    public Parameter.TypeEnum getType() {
        return Parameter.TypeEnum.BOOLEAN;
    }
}
