package csbase.rest.adapter.algorithm.v1;

import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.SimpleParameter;
import ibase.rest.model.algorithm.v1.OutputFileParameter;
import ibase.rest.model.algorithm.v1.Parameter;

/**
 * Created by mjulia on 13/06/16.
 */
public class OutputFileParameterFactory  implements  ParameterFactory  {

    public ibase.rest.model.algorithm.v1.Parameter buildParameter(SimpleParameter p) {
        ibase.rest.model.algorithm.v1.OutputFileParameter parameter =
                new ibase.rest.model.algorithm.v1.OutputFileParameter();
        setCommonAttributes(parameter, p);
        parameter.setType(Parameter.TypeEnum.OUTPUT_FILE);
        if (csbase.logic.algorithms.parameters.OutputFileListParameter.class.isInstance(p)) {
            csbase.logic.algorithms.parameters.OutputFileListParameter csbaseParam =
                    csbase.logic.algorithms.parameters.OutputFileListParameter.class.cast(p);
            parameter.setMultipleSelection(true);
            parameter.setSort(csbaseParam.mustSort());
            parameter.setUseFilter(csbaseParam.usesFilter());
            parameter.setForceExtension(csbaseParam.mustForceExtension());
            setMode(csbaseParam.getMode(), parameter);
        }
        else if (csbase.logic.algorithms.parameters.OutputFileParameter.class.isInstance(p)) {
            csbase.logic.algorithms.parameters.OutputFileParameter csbaseParam =
                    csbase.logic.algorithms.parameters.OutputFileParameter.class.cast(p);
            parameter.setMultipleSelection(false);
            parameter.setSort(false);
            parameter.setUseFilter(csbaseParam.usesFilter());
            parameter.setAllowsPipe(csbaseParam.usesPipe().equals(FileParameterPipeAcceptance.TRUE));
            parameter.setForceExtension(csbaseParam.mustForceExtension());
            setMode(csbaseParam.getMode(), parameter);
        }
        return parameter;
    }
    private void setMode (FileParameterMode mode, ibase.rest.model.algorithm.v1.OutputFileParameter parameter ) {
        switch (mode) {
            case REGULAR_FILE:
                parameter.setCategory(OutputFileParameter.CategoryEnum.REGULAR);
                break;
            case DIRECTORY:
                parameter.setCategory(OutputFileParameter.CategoryEnum.FOLDER);
                break;
        }
    }
    public Parameter.TypeEnum getType() {
        return Parameter.TypeEnum.OUTPUT_FILE;
    }
}
