package csbase.rest.adapter.algorithm.v1;

import csbase.logic.algorithms.parameters.SimpleParameter;
import ibase.rest.model.algorithm.v1.Parameter;

/**
 * Created by mjulia on 10/06/16.
 */
public interface ParameterFactory {

    ibase.rest.model.algorithm.v1.Parameter buildParameter(SimpleParameter p);

    Parameter.TypeEnum getType();

    default void setCommonAttributes(ibase.rest.model.algorithm.v1.Parameter p1, SimpleParameter p2) {
        p1.setId(p2.getName());
        p1.setDefaultValue(p2.getDefaultValue());
        p1.setDescription(p2.getDescription());
        p1.setLabel(p2.getLabel());
        p1.setHidden(!p2.isVisible());
        p1.setOptional(p2.isOptional());
        p1.setDefaultValue(p2.getDefaultValue());
        p1.setIgnoreIfDisabled(p2.ignoreIfDisabled());
        p1.setIgnoreIfHidden(p2.ignoreIfInvisible());
        p1.setType(getType());
    }

}
