package csbase.rest.adapter.algorithm.v1;

import csbase.logic.algorithms.parameters.SimpleParameter;
import ibase.rest.model.algorithm.v1.Parameter;

/**
 * Created by mjulia on 13/06/16.
 */
public class StringParameterFactory implements ParameterFactory{
    @Override
    public Parameter buildParameter(SimpleParameter p) {
        ibase.rest.model.algorithm.v1.StringParameter parameter =
                new ibase.rest.model.algorithm.v1.StringParameter();
        setCommonAttributes(parameter, p);
        parameter.setType(Parameter.TypeEnum.STRING);

        if (csbase.logic.algorithms.parameters.TextParameter.class.isInstance(p)) {
            csbase.logic.algorithms.parameters.TextParameter csbaseParam =
                    csbase.logic.algorithms.parameters.TextParameter.class.cast(p);
            parameter.setMultipleSelection(false);
            parameter.setMaximumOfChars(csbaseParam.getMaxCharacters());
        } else if (csbase.logic.algorithms.parameters.TextListParameter.class.isInstance(p)) {
            parameter.setMultipleSelection(true);
            csbase.logic.algorithms.parameters.TextListParameter csbaseParam =
                    csbase.logic.algorithms.parameters.TextListParameter.class.cast(p);
            parameter.setMaximumOfChars(csbaseParam.getMaxCharacters());
        }
        return parameter;
    }

    public Parameter.TypeEnum getType() {
        return Parameter.TypeEnum.STRING;
    }
}
