/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.algorithm.v1;

import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.OutputURLListParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.rest.adapter.algorithm.v1.ParameterFactory;
import ibase.rest.model.algorithm.v2.OutputURLParameter;
import ibase.rest.model.algorithm.v2.Parameter;
import ibase.rest.model.algorithm.v2.ParameterType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;

public class OutputURLParameterFactory
implements ParameterFactory {
    @Override
    public Parameter buildParameter(SimpleParameter<?> p) {
        OutputURLParameter parameter = new OutputURLParameter();
        this.setCommonAttributes((Parameter)parameter, p);
        parameter.setType(this.getType());
        if (p instanceof OutputURLListParameter) {
            OutputURLListParameter csbaseParam = (OutputURLListParameter)p;
            parameter.setMultipleSelection(Boolean.valueOf(true));
            parameter.setSort(Boolean.valueOf(csbaseParam.mustSort()));
            this.setMode(csbaseParam.getMode(), parameter);
            this.setProtocol(csbaseParam.getAllowedProtocols(), parameter);
            parameter.setAllowsPipe(OutputURLParameter.AllowsPipeEnum.FALSE);
        } else if (p instanceof csbase.logic.algorithms.parameters.OutputURLParameter) {
            csbase.logic.algorithms.parameters.OutputURLParameter csbaseParam = (csbase.logic.algorithms.parameters.OutputURLParameter)p;
            parameter.setMultipleSelection(Boolean.valueOf(false));
            parameter.setSort(Boolean.valueOf(false));
            this.setAllowsPipe(csbaseParam.usesPipe(), parameter);
            if (csbaseParam.usesPipe().equals((Object)FileParameterPipeAcceptance.ALWAYS)) {
                parameter.setHidden(Boolean.valueOf(true));
            }
            this.setMode(csbaseParam.getMode(), parameter);
            this.setProtocol(csbaseParam.getAllowedProtocols(), parameter);
        }
        return parameter;
    }

    private void setAllowsPipe(FileParameterPipeAcceptance allowsPipe, OutputURLParameter parameter) {
        switch (allowsPipe) {
            case TRUE: {
                parameter.setAllowsPipe(OutputURLParameter.AllowsPipeEnum.TRUE);
                break;
            }
            case FALSE: {
                parameter.setAllowsPipe(OutputURLParameter.AllowsPipeEnum.FALSE);
                break;
            }
            case ALWAYS: {
                parameter.setAllowsPipe(OutputURLParameter.AllowsPipeEnum.ALWAYS);
            }
        }
    }

    private void setMode(FileParameterMode mode, OutputURLParameter parameter) {
        switch (mode) {
            case REGULAR_FILE: {
                parameter.setCategory(OutputURLParameter.CategoryEnum.REGULAR);
                break;
            }
            case DIRECTORY: {
                parameter.setCategory(OutputURLParameter.CategoryEnum.FOLDER);
            }
        }
    }

    private void setProtocol(EnumSet<URLProtocol> allowedProtocols, OutputURLParameter parameter) {
        HashSet<OutputURLParameter.ProtocolEnum> protocols = new HashSet<OutputURLParameter.ProtocolEnum>();
        for (URLProtocol protocol : allowedProtocols) {
            switch (protocol) {
                case PROJECT: {
                    protocols.add(OutputURLParameter.ProtocolEnum.PROJECT);
                    break;
                }
                case SGA: 
                case LOCAL: {
                    protocols.add(OutputURLParameter.ProtocolEnum.LOCAL);
                }
            }
        }
        parameter.setProtocol(new ArrayList(protocols));
    }

    @Override
    public String getType() {
        return ParameterType.OUTPUT_URL.toString();
    }
}

