/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.application.v1;

import csbase.logic.RemoteFileInputStream;
import csbase.logic.applicationservice.ApplicationRegistry;
import csbase.remote.ApplicationServiceInterface;
import csbase.remote.ClientRemoteLocator;
import ibase.rest.api.application.v2.adapter.ApplicationServiceAdapter;
import ibase.rest.model.application.v2.Application;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;

public class CSBaseApplicationServiceAdapter
implements ApplicationServiceAdapter {
    private static final String CURRENT_SYSTEM_ID = ".";
    private static final Logger logger = Logger.getLogger(CSBaseApplicationServiceAdapter.class.getName());

    public void setLocale(Locale locale) {
        ClientRemoteLocator.administrationService.setLocale(locale);
    }

    public Optional<Application> getApplication(String appId) {
        ApplicationServiceInterface service = ClientRemoteLocator.applicationService;
        try {
            ApplicationRegistry appReg = service.getApplicationRegistry(appId);
            Optional<Application> application = Optional.empty();
            application = Optional.of(CSBaseApplicationServiceAdapter.buildApplication(appReg));
            return application;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Erro no metodo getApplication", e);
            return null;
        }
    }

    public List<Application> getApplications(Predicate<Application> predicate) {
        ApplicationServiceInterface service = ClientRemoteLocator.applicationService;
        try {
            Hashtable appRegistries = service.getApplicationRegistries();
            Collection appRegValues = appRegistries.values();
            ArrayList<Application> applications = new ArrayList<Application>();
            for (ApplicationRegistry next : appRegValues) {
                Application a = CSBaseApplicationServiceAdapter.buildApplication(next);
                if (predicate == null) {
                    applications.add(a);
                    continue;
                }
                if (!predicate.test(a)) continue;
                applications.add(a);
            }
            applications.sort(new Comparator<Application>(){

                @Override
                public int compare(Application o1, Application o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            return applications;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Erro no metodo getApplications", e);
            return null;
        }
    }

    public InputStream getApplicationDocFileStream(String appId, String fileName) {
        try {
            ApplicationServiceInterface service = ClientRemoteLocator.applicationService;
            String[] resourcePath = new String[]{"html", fileName};
            RemoteFileChannelInfo appResource = service.getApplicationResource(appId, resourcePath);
            if (appResource == null) {
                return null;
            }
            return new RemoteFileInputStream(appResource);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Erro no metodo getApplicationDocFileStream", e);
            return null;
        }
    }

    public String getApplicationLatestVersion(List<String> versionIds) {
        if (versionIds == null || versionIds != null && versionIds.size() == 0) {
            return null;
        }
        if (versionIds.size() == 1) {
            return versionIds.get(0);
        }
        Collections.sort(versionIds, Collections.reverseOrder());
        return versionIds.get(0);
    }

    private static Application buildApplication(ApplicationRegistry appReg) {
        Application application = new Application();
        application.setName(appReg.getClassName());
        application.setId(appReg.getId());
        application.setAuthor(appReg.getAuthorName());
        application.setVersion(appReg.getVersion());
        return application;
    }
}

