package Requests.Authentication;

import javax.ws.rs.client.*;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class Authentication {

	public static Token authenticate(String host, String username, String password)
			throws LoginOrPasswordNotProvidedException, InvalidLoginOrPasswordException {
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target(host).path("authentication");

		Form form = new Form();
		form.param("login", username);
		form.param("password", password);

		Invocation.Builder invocationBuilder = webTarget.request("application/json;charset=UTF-8");
		Response response = invocationBuilder.post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE),
				Response.class);

		if (response.getStatus() == Response.Status.OK.getStatusCode()) {
			return response.readEntity(Token.class);
		} else if (response.getStatus() == Response.Status.BAD_REQUEST.getStatusCode())
			throw new LoginOrPasswordNotProvidedException();
		else if (response.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode())
			throw new InvalidLoginOrPasswordException();
		return null;
	}
}
