package Requests.Jobs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JobPullInfo    {
	private Long date = null;

	private List<JobInfo> jobs = new ArrayList<JobInfo>();

	public JobPullInfo date(Long date) {
		this.date = date;
		return this;
	}

	public Long getDate() {
		return date;
	}

	public void setDate(Long date) {
		this.date = date;
	}

	public JobPullInfo jobs(List<JobInfo> jobs) {
		this.jobs = jobs;
		return this;
	}

	public JobPullInfo addJobsItem(JobInfo jobsItem) {
		this.jobs.add(jobsItem);
		return this;
	}

	public List<JobInfo> getJobs() {
		return jobs;
	}

	public void setJobs(List<JobInfo> jobs) {
		this.jobs = jobs;
	}


	@Override
	public boolean equals(java.lang.Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		JobPullInfo pullInfo = (JobPullInfo) o;
		return Objects.equals(this.date, pullInfo.date) &&
				Objects.equals(this.jobs, pullInfo.jobs);
	}

	@Override
	public int hashCode() {
		return Objects.hash(date, jobs);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("class JobPullInfo {\n");
		sb.append("    date: ").append(toIndentedString(date)).append("\n");
		sb.append("    jobs: ").append(toIndentedString(jobs)).append("\n");
		sb.append("}");
		return sb.toString();
	}

	private String toIndentedString(java.lang.Object o) {
		if (o == null) {
			return "null";
		}
		return o.toString().replace("\n", "\n    ");
	}

	public JobInfo getJob(String jobId) {
		for (JobInfo job : jobs) {
			if (job.getJobId().equals(jobId)) {
				return job;
			}
		}
		return null;
	}
}

