package Requests.Projects;

import Requests.User.User;

import javax.ws.rs.Produces;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Produces("application/json")
@XmlRootElement
public class Project {
	private String id = null;
	private String name = null;
	private String description = null;
	private User owner = null;
	private Boolean editable = null;
	private Boolean isOwner = null;
	private Long modified = null;
	private Long created = null;
	private String type = null;

	public enum VisibilityEnum {
		PRIVATE("private"),
		PUBLIC_RO("public_ro"),
		PUBLIC_RW("public_rw"),
		SELECTIVE("selective");
		private String value;
		VisibilityEnum(String value) {
			this.value = value;
		}
		@Override
		public String toString() {
			return String.valueOf(value);
		}
	}

	private VisibilityEnum visibility = null;

	private List<TeamMember> members = new ArrayList<TeamMember>();

	public Project id(String id) {
		this.id = id;
		return this;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public Project name(String name) {
		this.name = name;
		return this;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Project description(String description) {
		this.description = description;
		return this;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Project owner(User owner) {
		this.owner = owner;
		return this;
	}

	public User getOwner() {
		return owner;
	}

	public void setOwner(User owner) {
		this.owner = owner;
	}

	public Project editable(Boolean editable) {
		this.editable = editable;
		return this;
	}

	public Boolean getEditable() {
		return editable;
	}

	public void setEditable(Boolean editable) {
		this.editable = editable;
	}

	public Project isOwner(Boolean isOwner) {
		this.isOwner = isOwner;
		return this;
	}

	public Boolean getIsOwner() {
		return isOwner;
	}

	public void setIsOwner(Boolean isOwner) {
		this.isOwner = isOwner;
	}

	public Project modified(Long modified) {
		this.modified = modified;
		return this;
	}

	public Long getModified() {
		return modified;
	}

	public void setModified(Long modified) {
		this.modified = modified;
	}

	public Project created(Long created) {
		this.created = created;
		return this;
	}

	public Long getCreated() {
		return created;
	}

	public void setCreated(Long created) {
		this.created = created;
	}

	public Project type(String type) {
		this.type = type;
		return this;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Project visibility(VisibilityEnum visibility) {
		this.visibility = visibility;
		return this;
	}

	public VisibilityEnum getVisibility() {
		return visibility;
	}

	public void setVisibility(VisibilityEnum visibility) {
		this.visibility = visibility;
	}

	public Project members(List<TeamMember> members) {
		this.members = members;
		return this;
	}

	public Project addMembersItem(TeamMember membersItem) {
		this.members.add(membersItem);
		return this;
	}

	public List<TeamMember> getMembers() {
		return members;
	}

	public void setMembers(List<TeamMember> members) {
		this.members = members;
	}


	@Override
	public boolean equals(java.lang.Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		Project project = (Project) o;
		return Objects.equals(this.id, project.id) &&
				Objects.equals(this.name, project.name) &&
				Objects.equals(this.description, project.description) &&
				Objects.equals(this.owner, project.owner) &&
				Objects.equals(this.editable, project.editable) &&
				Objects.equals(this.isOwner, project.isOwner) &&
				Objects.equals(this.modified, project.modified) &&
				Objects.equals(this.created, project.created) &&
				Objects.equals(this.type, project.type) &&
				Objects.equals(this.visibility, project.visibility) &&
				Objects.equals(this.members, project.members);
	}

	@Override
	public int hashCode() {
		return Objects.hash(id, name, description, owner, editable, isOwner, modified, created, type, visibility, members);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("class Project {\n");

		sb.append("    id: ").append(toIndentedString(id)).append("\n");
		sb.append("    name: ").append(toIndentedString(name)).append("\n");
		sb.append("    description: ").append(toIndentedString(description)).append("\n");
		sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
		sb.append("    editable: ").append(toIndentedString(editable)).append("\n");
		sb.append("    isOwner: ").append(toIndentedString(isOwner)).append("\n");
		sb.append("    modified: ").append(toIndentedString(modified)).append("\n");
		sb.append("    created: ").append(toIndentedString(created)).append("\n");
		sb.append("    type: ").append(toIndentedString(type)).append("\n");
		sb.append("    visibility: ").append(toIndentedString(visibility)).append("\n");
		sb.append("    members: ").append(toIndentedString(members)).append("\n");
		sb.append("}");
		return sb.toString();
	}

	private String toIndentedString(java.lang.Object o) {
		if (o == null) {
			return "null";
		}
		return o.toString().replace("\n", "\n    ");
	}
}
