package Requests.Projects;

import Requests.Authentication.Token;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import java.util.Base64;

public class ProjectExplorer {

	public static Project findProjectByName(String host, Token token, String projectName) {

		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target(host);

		String projectId = Base64.getEncoder().encodeToString(projectName.getBytes());
		Response response = webTarget.path("projects").path(projectId)
				.request("application/json;charset=UTF-8")
				.header(HttpHeaders.AUTHORIZATION, token.getTokenType() + token.getAccessToken()).get();

		if (response.getStatus() == Response.Status.OK.getStatusCode()) {
			Project project = response.readEntity(Project.class);
			return project;
		}
		return null;
	}

}
