package csbase.rest.adapter.drmaa2.v1.DAO;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by Tecgraf/PUC-Rio on 27/07/16.
 */
public class PersistentMap<K, V> extends PersistentObject<ConcurrentHashMap<K, V>> implements Map<K, V>, Serializable {

    /**
     * @param path
     */
    @SuppressWarnings("unchecked")
    public PersistentMap(String path) {
        super(path, (Class<ConcurrentHashMap<K, V>>) (Class<?>) ConcurrentHashMap.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int size() {
        return get().size();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isEmpty() {
        return get().isEmpty();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean containsKey(Object key) {
        return get().containsKey(key);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean containsValue(Object value) {
        return get().containsValue(value);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public V get(Object key) {
        return get().get(key);
    }

    /**
     * This method triggers the {@link PersistentObject #save()} method.
     * <p>
     * {@inheritDoc}
     */
    @Override
    public V put(K key, V value) {
        V newValue = get().put(key, value);
        this.save();
        return newValue;
    }

    /**
     * This method triggers the {@link PersistentObject #save()} method.
     * <p>
     * {@inheritDoc}
     */
    @Override
    public V remove(Object key) {
        V oldValue = get().remove(key);
        this.save();
        return oldValue;
    }

    /**
     * This method triggers the {@link PersistentObject #save()} method.
     * <p>
     * {@inheritDoc}
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        get().putAll(m);
        this.save();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void clear() {
        get().clear();

    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Set<K> keySet() {
        return get().keySet();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Collection<V> values() {
        return get().values();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Set<Entry<K, V>> entrySet() {
        return get().entrySet();
    }
}
