package csbase.rest.adapter.job.v1.DAO;

import java.io.*;

/**
 * Created by Tecgraf PUC-Rio on 27/07/16.
 */
public class PersistentObject<T> implements Serializable {

    /**
     * Persisted object class.
     */
    private Class<T> clazz;
    /**
     * Persisted object.
     */
    private T object;
    /**
     * Path of the file where the object is persisted
     */
    private String path;

    /**
     * @param path
     * @param clazz
     */
    public PersistentObject(String path, Class<T> clazz) {
        this.clazz = clazz;
        this.path = path;
        load();
    }

    /**
     * @param clazz
     */
    private void instantiateT(Class<T> clazz) {
        try {
            this.object = clazz.newInstance();
        } catch (InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    /**
     * @return the object beign persisted
     */
    public T get() {
        return object;
    }

    /**
     * @param object
     */
    public void set(T object) {
        this.object = object;
    }

    /**
     * @return the path of the file used to persist the given object
     */
    public String getPath() {
        return path;
    }

    /**
     * @return the class of the object beign persisted
     */
    public Class<T> getClazz() {
        return clazz;
    }

    /**
     * @return true if the file was saved successfully
     */
    public boolean save() {
        try {
            final File file = new File(path);
            final FileOutputStream fStream = new FileOutputStream(file);
            serialize(new BufferedOutputStream(fStream), object);
            return true;
        } catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /**
     * Serialize the content of an object into a ObjectOutput
     *
     * @param out
     *            ObjectOutput to save object into
     * @param value
     *            Object to serialize
     * @throws IOException
     */
    private void serialize(OutputStream out, T value) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(value);
        oos.flush();
    }

    /**
     *
     * @return true if the object was loaded from the specified path, otherwise
     *         false.
     */
    public synchronized boolean load() {
        final File file = new File(path);
        if (!file.exists()) {
            instantiateT(clazz);
            return false;
        }
        try {
            object = deserialize(new BufferedInputStream(new FileInputStream(file)));
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            instantiateT(clazz);
            return false;
        }
    }

    /**
     * Deserialize the content of an object from a DataInput.
     *
     * @param in
     *            to read serialized data from
     * @return deserialized object
     * @throws IOException
     */
    @SuppressWarnings("unchecked")
    private T deserialize(InputStream in) throws IOException {
        try {
            ObjectInputStream in2 = new ObjectInputStream(in);
            return (T) in2.readObject();
        } catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

}
