/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.job.v1;

import csbase.exception.PermissionException;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.CommandSubmission;
import csbase.logic.FailureFinalizationType;
import csbase.logic.Priority;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.FlowNode;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.serializer.FlowAlgorithmConfigurationSerializer;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerException;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.CommandPersistenceServiceInterface;
import csbase.remote.ProjectServiceInterface;
import csbase.remote.SchedulerServiceInterface;
import csbase.rest.adapter.job.v1.JobInfoMonitor;
import csbase.rest.adapter.job.v1.JobRSQLVisitor;
import csbase.rest.adapter.job.v1.JobTemplateValidator;
import csbase.rest.adapter.job.v1.parameters.JobParameter;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import csbase.server.services.commandpersistenceservice.CommandStatusListener;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.schedulerservice.SchedulerService;
import csbase.server.services.sgaservice.SGAService;
import cz.jirutka.rsql.parser.RSQLParser;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import ibase.common.v2.ServiceAdapter;
import ibase.common.v2.ServiceUtil;
import ibase.exception.v2.InternalServiceException;
import ibase.rest.api.job.v2.adapter.JobDAO;
import ibase.rest.api.job.v2.adapter.JobMonitorListener;
import ibase.rest.api.job.v2.adapter.JobsServiceAdapter;
import ibase.rest.api.job.v2.factories.JobsDAOFactory;
import ibase.rest.model.job.v2.Job;
import ibase.rest.model.job.v2.JobSession;
import ibase.rest.model.job.v2.JobTemplate;
import ibase.rest.model.job.v2.StatusType;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import tecgraf.javautils.core.timestamp.TStamp32;

public class CSBaseJobsServiceAdapter
implements JobsServiceAdapter {
    public static final String RESOURCE_BUNDLE = "CSBaseJobsServiceAdapter";
    private final JobInfoMonitor jobInfoMonitor;

    private JobDAO getJobDAO() {
        JobsDAOFactory factory = (JobsDAOFactory)ServiceAdapter.getDAOFactory(JobsDAOFactory.class);
        if (factory == null) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(ClientRemoteLocator.administrationService.getCurrentLocale())).message("job.dao.not.found", new String[0]);
            throw new InternalServiceException(message);
        }
        return factory.getJobDAO();
    }

    private boolean isUnique(String sessionName) {
        return !this.getJobDAO().containsJobSession(sessionName);
    }

    private String generateUniqueSessionName(String userId) {
        return String.format("%s@%s", userId, new TStamp32().toString());
    }

    private ResourceBundle getBundle(Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, this.getClass().getClassLoader());
        return bundle;
    }

    private Job.ExitStatusEnum getExitStatus(CommandFinalizationType type, FailureFinalizationType cause) {
        switch (type) {
            case END: 
            case NO_EXIT_CODE: {
                return Job.ExitStatusEnum.UNKNOWN;
            }
            case SUCCESS: {
                return Job.ExitStatusEnum.SUCCESS;
            }
            case EXECUTION_ERROR: {
                return Job.ExitStatusEnum.EXECUTION_ERROR;
            }
            case FAILED: {
                switch (cause) {
                    case UNKNOWN: {
                        return Job.ExitStatusEnum.UNKNOWN;
                    }
                    case COMMAND_IDENTIFIER_NOT_FOUND: {
                        return Job.ExitStatusEnum.JOB_IDENTIFIER_NOT_FOUND;
                    }
                    case SGA_EXECUTION_ERROR: {
                        return Job.ExitStatusEnum.UNEXPECTED_MACHINE_ERROR;
                    }
                    case FAILED_SETUP_EXECUTION_ENVIRONMENT: {
                        return Job.ExitStatusEnum.FAILED_SETUP_EXECUTION_ENVIRONMENT;
                    }
                    case NO_SGA_AVAILABLE_TO_ROOT_COMMAND: 
                    case SGA_IS_NOT_AVAILABLE: {
                        return Job.ExitStatusEnum.NO_MACHINE_AVAILABLE;
                    }
                    case PROJECT_NOT_FOUND: {
                        return Job.ExitStatusEnum.PROJECT_NOT_FOUND;
                    }
                    case USER_WITHOUT_PERMISSION_FOR_EXECUTION: {
                        return Job.ExitStatusEnum.NO_PERMISSION;
                    }
                }
            }
            case KILLED: {
                return Job.ExitStatusEnum.KILLED;
            }
            case LOST: {
                return Job.ExitStatusEnum.LOST;
            }
        }
        return Job.ExitStatusEnum.UNDEFINED;
    }

    private StatusType getJobState(CommandInfo cmdInfo) {
        CommandStatus cmdStatus = cmdInfo.getStatus();
        if (cmdInfo.isQueued()) {
            return StatusType.QUEUED;
        }
        switch (cmdStatus) {
            case INIT: 
            case SCHEDULED: {
                return StatusType.SCHEDULED;
            }
            case UPLOADING: {
                return StatusType.UPLOADING;
            }
            case EXECUTING: {
                return StatusType.EXECUTING;
            }
            case DOWNLOADING: {
                return StatusType.DOWNLOADING;
            }
            case FINISHED: {
                return StatusType.FINISHED;
            }
        }
        return StatusType.UNKNOWN;
    }

    CSBaseJobsServiceAdapter() {
        CommandPersistenceService persistenceService = CommandPersistenceService.getInstance();
        this.jobInfoMonitor = new JobInfoMonitor(this.getJobDAO());
        persistenceService.addCommandStatusListener((CommandStatusListener)this.jobInfoMonitor);
    }

    public void setLocale(Locale locale) {
        ClientRemoteLocator.administrationService.setLocale(locale);
    }

    public JobSession createJobSession(String sessionName) {
        if (!this.isUnique(sessionName)) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(ClientRemoteLocator.administrationService.getCurrentLocale())).message("createJobSession.name.exists.error", new String[]{sessionName});
            throw new InternalServiceException(message);
        }
        String currentUser = ServiceAdapter.getCurrentUser();
        sessionName = sessionName == null ? this.generateUniqueSessionName(currentUser) : sessionName;
        JobSession jobSession = new JobSession();
        jobSession.setSessionName(sessionName);
        this.getJobDAO().insertJobSession(jobSession);
        return jobSession;
    }

    public JobSession getJobSession(String name) {
        return this.getJobDAO().findJobSessionById(name);
    }

    public List<JobSession> getAllJobSessions() {
        return this.getJobDAO().findAllJobSessions();
    }

    public String runJob(String jobSessionId, JobTemplate jobTemplate) {
        return this.runJob(jobTemplate);
    }

    private String runJob(JobTemplate jobTemplate) {
        String platform;
        Boolean emailOnTerminated;
        if (jobTemplate == null) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(ClientRemoteLocator.administrationService.getCurrentLocale())).message("runJob.jobtemplate.missing.error", new String[0]);
            throw new InternalServiceException(message);
        }
        JobTemplateValidator validator = new JobTemplateValidator(ServiceAdapter.getCurrentUser(), jobTemplate, ClientRemoteLocator.administrationService.getCurrentLocale());
        AlgorithmConfigurator configurator = validator.getAlgorithmConfigurator();
        CommandSubmission submission = new CommandSubmission(configurator, validator.getProjectId());
        submission.setDescription(jobTemplate.getDescription());
        submission.setPriority(Priority.values()[jobTemplate.getPriority()]);
        List emails = jobTemplate.getEmail();
        if (emails != null) {
            submission.setEmailList(emails.toArray(new String[0]));
        }
        if ((emailOnTerminated = jobTemplate.getEmailOnTerminated()) != null) {
            submission.setMailAtEnd(emailOnTerminated.booleanValue());
        }
        if ((platform = jobTemplate.getPlatform()) != null) {
            submission.setPlatform(platform);
        }
        List candidateMachines = jobTemplate.getCandidateMachines();
        Integer executionCount = jobTemplate.getNumberOfJobs();
        if (candidateMachines != null && candidateMachines.size() > 0) {
            if (executionCount == null || executionCount == 1) {
                submission.configureSimpleExecution((String)candidateMachines.get(0));
            } else {
                submission.configureMultipleExecution(candidateMachines, executionCount.intValue());
            }
        } else if (executionCount == null || executionCount == 1) {
            submission.configureSimpleExecution();
        } else {
            submission.configureMultipleExecution(executionCount.intValue());
        }
        Object extraProperties = jobTemplate.getExtraProperties();
        if (extraProperties != null) {
            LinkedHashMap extraPropertiesMap = (LinkedHashMap)LinkedHashMap.class.cast(extraProperties);
            extraPropertiesMap.forEach((k, v) -> submission.addExtraInfo(k, (String)v));
        }
        Set commandInfos = null;
        SchedulerServiceInterface schedulerService = ClientRemoteLocator.schedulerService;
        try {
            commandInfos = schedulerService.submitCommand(submission);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
        CommandInfo cmdInfo = commandInfos.toArray(new CommandInfo[0])[0];
        return cmdInfo.getId();
    }

    public Job getJob(String jobId) {
        Job job = this.getJobDAO().findJobById(jobId);
        return job;
    }

    public List<Job> getJobs(String queryString) {
        if (queryString == null) {
            return this.getJobDAO().findAllJobs();
        }
        Node rootNode = new RSQLParser().parse(queryString);
        Map values = (Map)rootNode.accept((RSQLVisitor)new JobRSQLVisitor());
        String projectId = (String)values.get("projectId");
        Long modifiedAfter = values.get("modifiedAfter") == null ? null : Long.valueOf(Long.parseLong((String)values.get("modifiedAfter")));
        List allJobs = this.getJobDAO().findJobs(projectId, modifiedAfter);
        return allJobs;
    }

    public Collection<Job> getLastJobs(Long modifiedAfter, String projectId, String jobId) {
        if (jobId != null) {
            LocalDateTime after = LocalDateTime.ofInstant(Instant.ofEpochMilli(modifiedAfter), ZoneId.systemDefault());
            Job job = this.getJobDAO().findJobById(jobId);
            if (job != null && LocalDateTime.parse(job.getLastModifiedTime()).isAfter(after)) {
                return Collections.singletonList(job);
            }
            return new ArrayList<Job>();
        }
        return this.getJobDAO().findJobs(projectId, modifiedAfter);
    }

    public String getLogDir(String jobId) throws IOException {
        ProjectService projectService = ProjectService.getInstance();
        CommandPersistenceService commandService = CommandPersistenceService.getInstance();
        Job job = this.getJobDAO().findJobById(jobId);
        if (job == null) {
            return null;
        }
        String projectId = ServiceUtil.decodeFromBase64((String)job.getProjectId());
        String path = ProjectService.getInstance().getProjectRepositoryPath();
        path = path + File.separator + String.join((CharSequence)File.separator, projectService.getProjectPath((Object)projectId));
        path = path + File.separator + String.join((CharSequence)File.separator, commandService.getLogDirectory(jobId));
        return path;
    }

    public void cancelJobs(List<String> jobIds) {
        CommandPersistenceService commandPersistenceService = CommandPersistenceService.getInstance();
        SchedulerService schedulerService = SchedulerService.getInstance();
        SGAService sgaService = SGAService.getInstance();
        boolean success = true;
        String currentUser = ServiceAdapter.getCurrentUser();
        for (String jobId : jobIds) {
            String message;
            Service.setUserId((Object)currentUser);
            User user = Service.getUser();
            Job job = this.getJobDAO().findJobById(jobId);
            if (job == null) continue;
            String projectId = ServiceUtil.decodeFromBase64((String)job.getProjectId());
            CommandInfo commandInfo = commandPersistenceService.getCommandInfo((Object)projectId, job.getJobId());
            Service.setUserId((Object)currentUser);
            if (commandInfo.getStatus().equals((Object)CommandStatus.SYSTEM_FAILURE)) {
                message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(ClientRemoteLocator.administrationService.getCurrentLocale())).message("cancelJobs.job.not.found", new String[]{jobId});
                Server.logSevereMessage((String)message);
            }
            if (commandInfo.getStatus().equals((Object)CommandStatus.FINISHED)) {
                message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(ClientRemoteLocator.administrationService.getCurrentLocale())).message("cancelJobs.job.already.finished", new String[]{jobId});
                Server.logSevereMessage((String)message);
            }
            try {
                if (commandInfo.getStatus().equals((Object)CommandStatus.SCHEDULED)) {
                    schedulerService.removeCommand((Object)jobId);
                    continue;
                }
                sgaService.killCommand(jobId);
            }
            catch (PermissionException e) {
                throw new ibase.exception.v2.PermissionException(e.getMessage());
            }
            catch (Throwable e) {
                String message2 = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(ClientRemoteLocator.administrationService.getCurrentLocale())).message("cancelJobs.internal.error", new String[]{jobId});
                Server.logSevereMessage((String)message2);
                success &= false;
            }
        }
        if (!success) {
            throw new InternalServiceException("cancelJobs.error");
        }
    }

    public Map<String, Object> getJobParameters(String jobId, boolean jsonFormat, boolean valuesOnly) {
        CommandPersistenceServiceInterface commandService = ClientRemoteLocator.commandPersistenceService;
        Job job = this.getJobDAO().findJobById(jobId);
        String projectId = ServiceUtil.decodeFromBase64((String)job.getProjectId());
        CommandInfo cmdInfo = null;
        AlgorithmConfigurator configurator = null;
        try {
            cmdInfo = commandService.getCommandInfo((Object)projectId, job.getJobId());
            if (cmdInfo == null) {
                throw new InternalServiceException("getJobParameters.job.not.found");
            }
            configurator = cmdInfo.getConfigurator();
            if (configurator == null) {
                throw new InternalServiceException("getJobParameters.config.error");
            }
        }
        catch (RemoteException e) {
            throw new InternalServiceException("getJobParameters.config.error");
        }
        BiFunction<SimpleAlgorithmConfigurator, Boolean, Map> parameterFn = (simpleParameter, justValues) -> simpleParameter.getSimpleParameters().stream().map(o -> new JobParameter((SimpleParameter)o, jsonFormat)).filter(p -> p.getValue() != null).collect(Collectors.toMap(JobParameter::getName, p -> {
            if (justValues.booleanValue()) {
                return p.getValue();
            }
            HashMap<String, Object> toReturn = new HashMap<String, Object>();
            toReturn.put("values", p.getValue());
            toReturn.put("type", p.getParameterType());
            return toReturn;
        }));
        if (configurator.getConfiguratorType() == AlgorithmConfigurator.ConfiguratorType.FLOW) {
            FlowAlgorithmConfigurator flowConfig = (FlowAlgorithmConfigurator)FlowAlgorithmConfigurator.class.cast(configurator);
            Flow flow = flowConfig.getFlow();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            for (FlowNode node : flow.getNodes()) {
                HashMap<String, Object> nodeParameter = new HashMap<String, Object>();
                SimpleAlgorithmConfigurator algorithmConfigurator = (SimpleAlgorithmConfigurator)node.getAlgorithmConfigurator();
                nodeParameter.put("flowNodeId", node.getId());
                nodeParameter.put("version", node.getAlgorithmVersionId().toString());
                nodeParameter.put("id", algorithmConfigurator.getAlgorithmId());
                nodeParameter.put("name", node.getAlgorithmName());
                nodeParameter.put("parameters", parameterFn.apply(algorithmConfigurator, false));
                parameters.put(algorithmConfigurator.getAlgorithmId() + "_" + node.getAlgorithmVersionId() + "_" + node.getId(), nodeParameter);
            }
            return parameters;
        }
        SimpleAlgorithmConfigurator simpleConfig = (SimpleAlgorithmConfigurator)SimpleAlgorithmConfigurator.class.cast(configurator);
        return parameterFn.apply(simpleConfig, valuesOnly);
    }

    public StringBuffer getLogFile(String jobId, String fileName) {
        CommandPersistenceServiceInterface commandService = ClientRemoteLocator.commandPersistenceService;
        Job job = this.getJobDAO().findJobById(jobId);
        String projectId = ServiceUtil.decodeFromBase64((String)job.getProjectId());
        try {
            if (fileName != null) {
                String logFilePath = this.getLogDir(jobId) + File.separator + fileName;
                return this.readFile(logFilePath);
            }
            CommandInfo cmdInfo = commandService.getCommandInfo((Object)projectId, job.getJobId());
            Set files = cmdInfo.getConfigurator().getStandardOutputFiles();
            return this.logOutputFile(files, projectId);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private StringBuffer readFile(String filePath) {
        StringWriter sw = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(sw);){
            Path logFilePath = Paths.get(filePath, new String[0]);
            if (Files.exists(logFilePath, new LinkOption[0])) {
                BufferedReader bufferedReader = Files.newBufferedReader(logFilePath);
                String line = bufferedReader.readLine();
                while (line != null) {
                    printWriter.println(line);
                    line = bufferedReader.readLine();
                }
                printWriter.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sw.getBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer logOutputFile(Set<FileURLValue> stdOutputFiles, Object projectId) {
        ProjectServiceInterface projectService = ClientRemoteLocator.projectService;
        StringWriter sw = new StringWriter();
        PrintWriter printWriter = new PrintWriter(sw);
        for (FileURLValue stdOutputFile : stdOutputFiles) {
            String[] stdOutputFilePath = stdOutputFile.getPathAsArray();
            InputStream inputStream = null;
            try {
                if (stdOutputFiles.size() > 1) {
                    printWriter.printf("\n---- %s ----\n", stdOutputFilePath[stdOutputFilePath.length - 1]);
                }
                if (!projectService.existsFile(projectId, stdOutputFilePath)) continue;
                ClientProjectFile file = projectService.getChild(projectId, stdOutputFilePath);
                inputStream = file.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String line = bufferedReader.readLine();
                while (line != null) {
                    printWriter.println(line);
                    line = bufferedReader.readLine();
                }
                printWriter.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        printWriter.close();
        return sw.getBuffer();
    }

    public void addJobMonitorListener(JobMonitorListener listener) {
        this.jobInfoMonitor.addJobMonitorListener(listener);
    }

    public void removeJobMonitorListener(JobMonitorListener listener) {
        this.jobInfoMonitor.removeJobMonitorListener(listener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer getFlowRaw(String jobId) {
        CommandPersistenceServiceInterface commandService = ClientRemoteLocator.commandPersistenceService;
        Job job = this.getJobDAO().findJobById(jobId);
        String projectId = ServiceUtil.decodeFromBase64((String)job.getProjectId());
        CommandInfo cmdInfo = null;
        AlgorithmConfigurator configurator = null;
        try {
            cmdInfo = commandService.getCommandInfo((Object)projectId, job.getJobId());
            if (cmdInfo == null) {
                throw new InternalServiceException("getJobParameters.job.not.found");
            }
            configurator = cmdInfo.getConfigurator();
            if (configurator == null) {
                throw new InternalServiceException("getJobParameters.config.error");
            }
        }
        catch (RemoteException e) {
            throw new InternalServiceException("getJobParameters.config.error");
        }
        if (configurator.getConfiguratorType() != AlgorithmConfigurator.ConfiguratorType.FLOW) throw new IllegalArgumentException("getFlowRaw.flow.error");
        FlowAlgorithmConfigurator flowConf = (FlowAlgorithmConfigurator)FlowAlgorithmConfigurator.class.cast(configurator);
        FlowAlgorithmConfigurationSerializer serializer = new FlowAlgorithmConfigurationSerializer();
        try (ByteArrayOutputStream serializerOutput = new ByteArrayOutputStream();){
            serializer.write((AlgorithmConfigurator)flowConf, (OutputStream)serializerOutput);
            byte[] configuratorData = serializerOutput.toByteArray();
            ByteBuffer byteBuffer = ByteBuffer.wrap(configuratorData);
            return byteBuffer;
        }
        catch (AlgorithmConfigurationSerializerException | IOException e) {
            throw new InternalServiceException("getFlowRaw.read.raw.error");
        }
    }
}

