/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.job.v1.DAO;

import csbase.logic.CommandInfo;
import csbase.rest.adapter.job.v1.DAO.DefaultJobDAO;
import csbase.rest.adapter.job.v1.JobUtils;
import csbase.server.Server;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import ibase.common.v2.ServiceUtil;
import ibase.rest.model.job.v2.Job;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CommandPersistJobDAO
extends DefaultJobDAO {
    private final ConcurrentHashMap<String, Boolean> projectLoadedToCache = new ConcurrentHashMap();

    private boolean cacheIfAbsent(Job job) {
        if (job != null && !this.jobs.containsKey(job.getJobId())) {
            return super.insertJob(job);
        }
        return false;
    }

    @Override
    public List<Job> findJobs(String projectId, Long modifiedAfter) {
        this.loadCommandInfos(projectId);
        return super.findJobs(projectId, modifiedAfter);
    }

    @Override
    public List<Job> findJobsBySession(String jobSessionId) {
        List<Job> jobs = super.findJobsBySession(jobSessionId);
        jobs.forEach(job -> this.loadCommandInfos(job.getProjectId()));
        return jobs;
    }

    @Override
    public boolean insertJob(Job job) {
        try {
            if (this.cacheIfAbsent(job)) {
                this.loadCommandInfos(job.getProjectId());
                return true;
            }
        }
        catch (Exception e) {
            Server.logSevereMessage((String)"Erro ao inserir um Job", (Throwable)e);
            return false;
        }
        return false;
    }

    @Override
    public boolean updateJob(Job job) {
        if (job == null) {
            return false;
        }
        try {
            this.loadCommandInfos(job.getProjectId());
            super.updateJob(job);
        }
        catch (Exception e) {
            Server.logSevereMessage((String)"Erro ao atualizar um Job", (Throwable)e);
            return false;
        }
        return true;
    }

    private void loadCommandInfos(String base64ProjectId) {
        if (base64ProjectId == null) {
            return;
        }
        String projectId = ServiceUtil.decodeFromBase64((String)base64ProjectId);
        try {
            if (this.projectLoadedToCache.containsKey(base64ProjectId)) {
                return;
            }
            Set commandInfos = CommandPersistenceService.getInstance().getCommandInfos((Object)projectId);
            Server.logFineMessage((String)MessageFormat.format("Obtidos {0} jobs para o projeto {1}", commandInfos.size(), projectId));
            for (CommandInfo commandInfo : commandInfos) {
                Job job = JobUtils.createJob(commandInfo, commandInfo.getStatus());
                if (job == null) continue;
                this.cacheIfAbsent(job);
            }
            this.projectLoadedToCache.put(base64ProjectId, true);
            Server.logFineMessage((String)MessageFormat.format("Atualmente existem {0} jobs carregados", this.jobs.size()));
        }
        catch (Exception e) {
            Server.logSevereMessage((String)"Erro ao ler os comandos de um Job", (Throwable)e);
        }
    }
}

