/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.job.v1.DAO;

import csbase.server.Server;
import ibase.rest.api.job.v2.adapter.JobDAO;
import ibase.rest.model.job.v2.Job;
import ibase.rest.model.job.v2.JobSession;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class DefaultJobDAO
implements JobDAO {
    private final Map<String, JobSession> jobSessions = new ConcurrentHashMap<String, JobSession>();
    protected final Map<String, Job> jobs = new ConcurrentHashMap<String, Job>();
    private final Map<String, Set<Job>> jobsBySession = new ConcurrentHashMap<String, Set<Job>>();

    public boolean containsJob(String jobId) {
        return this.jobs.containsKey(jobId);
    }

    public List<Job> findAllJobs() {
        return this.jobs.values().stream().collect(Collectors.toList());
    }

    public Job findJobById(String jobId) {
        return this.jobs.get(jobId);
    }

    public List<Job> findJobs(String base64ProjectId, Long modifiedAfter) {
        ArrayList<Job> filteredJobs = new ArrayList<Job>();
        try {
            for (Job job : this.jobs.values()) {
                if (base64ProjectId != null && !job.getProjectId().equals(base64ProjectId) || job.getLastModifiedTime() == null || modifiedAfter != null && LocalDateTime.parse(job.getLastModifiedTime()).isBefore(LocalDateTime.ofInstant(Instant.ofEpochMilli(modifiedAfter), ZoneId.systemDefault()))) continue;
                filteredJobs.add(job);
            }
            Server.logFineMessage((String)MessageFormat.format("Filtrados {0} jobs para o projeto {1}", filteredJobs.size(), base64ProjectId));
        }
        catch (Exception e) {
            Server.logSevereMessage((String)"Erro ao obter os Jobs", (Throwable)e);
        }
        return filteredJobs;
    }

    public List<Job> findJobsBySession(String jobSessionId) {
        return new ArrayList<Job>((Collection)this.jobsBySession.get(jobSessionId));
    }

    public boolean insertJob(Job job) {
        if (job == null) {
            return false;
        }
        this.jobs.put(job.getJobId(), job);
        Set sessionsJobs = this.jobsBySession.computeIfAbsent(job.getSessionId(), k -> new HashSet());
        sessionsJobs.add(job);
        return true;
    }

    public boolean updateJob(Job job) {
        if (job == null) {
            return false;
        }
        if (!this.jobs.containsKey(job.getJobId())) {
            return this.insertJob(job);
        }
        return this.updateJobSession(job);
    }

    private boolean updateJobSession(Job job) {
        if (job == null) {
            return false;
        }
        Set sessionsJobs = this.jobsBySession.computeIfAbsent(job.getSessionId(), k -> new HashSet());
        sessionsJobs.add(job);
        return true;
    }

    public boolean containsJobSession(String sessionId) {
        return this.jobSessions.containsKey(sessionId);
    }

    public List<JobSession> findAllJobSessions() {
        return this.jobSessions.values().stream().collect(Collectors.toList());
    }

    public JobSession findJobSessionById(String sessionId) {
        return this.jobSessions.get(sessionId);
    }

    public void insertJobSession(JobSession jobSession) {
        this.jobSessions.put(jobSession.getSessionName(), jobSession);
    }
}

