package Requests.Algorithms;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AlgorithmVersion   {
	private String id = null;

	private String description = null;

	private List<Requirement> requirements = new ArrayList<Requirement>();

	public AlgorithmVersion id(String id) {
		this.id = id;
		return this;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public AlgorithmVersion description(String description) {
		this.description = description;
		return this;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public AlgorithmVersion requirements(List<Requirement> requirements) {
		this.requirements = requirements;
		return this;
	}

	public AlgorithmVersion addRequirementsItem(Requirement requirementsItem) {
		this.requirements.add(requirementsItem);
		return this;
	}

	public List<Requirement> getRequirements() {
		return requirements;
	}

	public void setRequirements(List<Requirement> requirements) {
		this.requirements = requirements;
	}


	@Override
	public boolean equals(java.lang.Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		AlgorithmVersion algorithmVersion = (AlgorithmVersion) o;
		return Objects.equals(this.id, algorithmVersion.id) &&
				Objects.equals(this.description, algorithmVersion.description) &&
				Objects.equals(this.requirements, algorithmVersion.requirements);
	}

	@Override
	public int hashCode() {
		return Objects.hash(id, description, requirements);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("class AlgorithmVersion {\n");

		sb.append("    id: ").append(toIndentedString(id)).append("\n");
		sb.append("    description: ").append(toIndentedString(description)).append("\n");
		sb.append("    requirements: ").append(toIndentedString(requirements)).append("\n");
		sb.append("}");
		return sb.toString();
	}

	/**
	 * Convert the given object to string with each line indented by 4 spaces
	 * (except the first line).
	 */
	private String toIndentedString(java.lang.Object o) {
		if (o == null) {
			return "null";
		}
		return o.toString().replace("\n", "\n    ");
	}
}