package Requests.Jobs;

import Requests.Algorithms.Algorithm;
import Requests.Algorithms.AlgorithmVersion;
import Requests.Authentication.Token;
import Requests.Projects.Project;

import javax.ws.rs.client.*;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class JobServices {

	public static String submitJob(String host, Token token, Project project, Algorithm algorithm,
			AlgorithmVersion version, String description, int priority, boolean emailOnTerminated,
    String[] candidateMachines, Map<String, Object> args) {

		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target(host).path("jobs");

        Map<String,Object> postBody = new HashMap<>();
        postBody.put("description", description);
        postBody.put("remoteCommand", buildRemoteCommand(project, algorithm, version));
        postBody.put("args", args);
        postBody.put("priority", Integer.toString(priority));
        postBody.put("emailOnTerminated", Boolean.toString(emailOnTerminated));
        postBody.put("numberOfJobs", new Integer(1));

		Invocation.Builder invocationBuilder = webTarget.request("application/json;charset=UTF-8");
		Response response = invocationBuilder
				.header(HttpHeaders.AUTHORIZATION, token.getTokenType() + token.getAccessToken())
				.header(HttpHeaders.CONTENT_TYPE, "application/json").header(HttpHeaders.CACHE_CONTROL, "no-cache")
				.post(Entity.entity(postBody, MediaType.APPLICATION_JSON_TYPE), Response.class);
		if (response.getStatus() == Response.Status.OK.getStatusCode())
			return response.readEntity(String.class);
		return null;
	}

    private static Map<String,String> buildRemoteCommand(Project project, Algorithm algorithm,
                                         AlgorithmVersion version) {
        Map<String,String> remoteCommand = new HashMap<>();
        remoteCommand.put("algorithmId", algorithm.getId());
        remoteCommand.put("versionId", version.getId());
        remoteCommand.put("projectId", project.getId());
        return remoteCommand;
    }
	
	public static JobInfo getJobInfo(String host, Token token, String jobId) {
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target(host).path("jobs").path(jobId);
		
		Invocation.Builder invocationBuilder = webTarget.request("application/json;charset=UTF-8");
		Response response = invocationBuilder
				.header(HttpHeaders.AUTHORIZATION, token.getTokenType() + token.getAccessToken())
				.header(HttpHeaders.CONTENT_TYPE, "application/json").header(HttpHeaders.CACHE_CONTROL, "no-cache")
				.get(Response.class);
		if (response.getStatus() == Response.Status.OK.getStatusCode())
			return response.readEntity(JobInfo.class);
		return null;
		
	}
	
	public static void awaitJobEnd(String host, Token token, JobInfo jinfo) {
        String jobId = jinfo.getJobId();
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
		Date date;
		try {
			date = format.parse(jinfo.getLastModifiedTime());
		} catch (ParseException e) {
			e.printStackTrace();
			return;
		}
		long currDate = date.getTime();
		while (true)
		{
			JobPullInfo info = getJobPullInfo(host, token, jobId, currDate);
			if (info!=null && info.getJob(jobId)!=null)
			{
        JobInfo.StatusType state = info.getJob(jobId).getState();
        Logger.getGlobal().fine("Job state (" + currDate + "): " + state);
		    if (state.equals(JobInfo.StatusType.FINISHED)) {
		        Logger.getGlobal().fine("Job " + jobId + " terminou");
            break;
        } else {
			  currDate = info.getDate();
        }
			}
		}
	}
	
	private static JobPullInfo getJobPullInfo(String host, Token token, String jobId, long date) {
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target(host)
				.path("jobs")
				.path("pull")
				.queryParam("jobId", jobId)
				.queryParam("date", date);
		
		Invocation.Builder invocationBuilder = webTarget.request("application/json;charset=UTF-8");
		Response response = invocationBuilder
				.header(HttpHeaders.AUTHORIZATION, token.getTokenType() + token.getAccessToken())
				.header(HttpHeaders.CONTENT_TYPE, "application/json").header(HttpHeaders.CACHE_CONTROL, "no-cache")
				.get(Response.class);
		if (response.getStatus() == Response.Status.OK.getStatusCode())
		{
			return response.readEntity(JobPullInfo.class);
		}
		return null;
	}


}
