/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.project.v1;

import csbase.exception.PermissionException;
import csbase.logic.CommonClientProject;
import csbase.logic.CommonProjectInfo;
import csbase.logic.ProjectPermissions;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import ibase.exception.InternalServiceException;
import ibase.rest.api.project.v1.adapter.AccessType;
import ibase.rest.api.project.v1.adapter.Project;
import ibase.rest.api.project.v1.adapter.SharingType;
import java.util.HashSet;
import java.util.Set;

public class CSBaseProject
implements Project {
    public static final String PROJECT_TYPE = "ibase_project_type";
    private final CommonClientProject project;

    CSBaseProject(CommonClientProject project) {
        this.project = project;
    }

    public String getId() {
        return (String)this.project.getId();
    }

    public String getName() {
        return this.project.getName();
    }

    public String getOwnerId() {
        return (String)this.project.getUserId();
    }

    public String getDescription() {
        return this.project.getDescription();
    }

    public String getType() {
        return (String)this.project.getAttribute(PROJECT_TYPE);
    }

    public long getLastModificationDate() {
        return this.project.getLastModificationDate();
    }

    public SharingType getSharingType() {
        ProjectPermissions.SharingType sharingType = this.project.getSharingType();
        switch (sharingType) {
            case ALL_RO: {
                return SharingType.PUBLIC_RO;
            }
            case ALL_RW: {
                return SharingType.PUBLIC_RW;
            }
            case PARTIAL: {
                return SharingType.SELECTIVE;
            }
            case PRIVATE: {
                return SharingType.PRIVATE;
            }
        }
        return null;
    }

    public Set<String> getTeamMembers(AccessType accessType) {
        Set users;
        switch (accessType) {
            case READ_ONLY: {
                users = this.project.getUsersRO();
                break;
            }
            case READ_WRITE: {
                users = this.project.getUsersRW();
                break;
            }
            default: {
                return new HashSet<String>();
            }
        }
        HashSet<String> userIds = new HashSet<String>(users.size());
        users.forEach(i -> userIds.add(i.toString()));
        return userIds;
    }

    public void addTeamMember(AccessType accessType, String userId) {
        Set membersRO = this.project.getUsersRO();
        Set membersRW = this.project.getUsersRW();
        HashSet<String> updatedMembersRO = new HashSet<String>();
        HashSet<String> updatedMembersRW = new HashSet<String>();
        updatedMembersRO.addAll(membersRO);
        updatedMembersRW.addAll(membersRW);
        if (!membersRO.contains(userId) && !membersRW.contains(userId)) {
            switch (accessType) {
                case READ_ONLY: {
                    updatedMembersRO.add(userId);
                    break;
                }
                case READ_WRITE: {
                    updatedMembersRW.add(userId);
                }
            }
        } else {
            switch (accessType) {
                case READ_ONLY: {
                    if (!membersRW.contains(userId)) break;
                    updatedMembersRW.remove(userId);
                    updatedMembersRO.add(userId);
                    break;
                }
                case READ_WRITE: {
                    if (!membersRO.contains(userId)) break;
                    updatedMembersRO.remove(userId);
                    updatedMembersRW.add(userId);
                }
            }
        }
        try {
            ProjectServiceInterface service = ClientRemoteLocator.projectService;
            service.updateUsers(this.project.getId(), ProjectPermissions.getSharingType((CommonProjectInfo)this.project.getInfo()), updatedMembersRO, updatedMembersRW);
        }
        catch (PermissionException e) {
            throw new ibase.exception.PermissionException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public AccessType getUserAccessType(String userId) {
        Set membersRO = this.project.getUsersRO();
        Set membersRW = this.project.getUsersRW();
        if (membersRW.contains(userId)) {
            return AccessType.READ_WRITE;
        }
        if (membersRO.contains(userId)) {
            return AccessType.READ_ONLY;
        }
        return null;
    }

    public long getCreationDate() {
        return this.project.getCreationDate();
    }

    public Boolean isWritableByUser(String userId) {
        ProjectServiceInterface service = ClientRemoteLocator.projectService;
        try {
            return service.userCanWrite(this.project.getId(), (Object)userId);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public boolean removeTeamMember(String userId) {
        try {
            return this.project.removeUser((Object)userId);
        }
        catch (PermissionException e) {
            throw new ibase.exception.PermissionException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }
}

