/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.project.v1;

import csbase.exception.InfoException;
import csbase.exception.PermissionException;
import csbase.exception.project.FileLockedException;
import csbase.logic.ClientProjectFile;
import csbase.logic.NoHiddenFileFilter;
import csbase.logic.ProjectFileType;
import csbase.logic.ProjectFileTypeInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import ibase.common.NotFoundException;
import ibase.exception.InternalServiceException;
import ibase.exception.InvalidParameterException;
import ibase.rest.api.project.v1.adapter.ProjectFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Stream;
import tecgraf.javautils.core.io.FileUtils;

public class CSBaseProjectFile
implements ProjectFile {
    private ClientProjectFile file;

    CSBaseProjectFile(ClientProjectFile file) {
        this.file = file;
    }

    public String getId() {
        try {
            return FileUtils.joinPath((String)"/", (String[])this.file.getPath());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public String getParentId() {
        try {
            String[] path = this.file.getPath();
            if (path.length == 0) {
                return null;
            }
            String[] parentPath = Arrays.copyOf(path, path.length - 1);
            return FileUtils.joinPath((String)"/", (String[])parentPath);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public String whoCreated() {
        try {
            return (String)this.file.whoCreated();
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public Long getCreationDate() {
        try {
            return this.file.getCreationDate();
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public String getDescription() {
        try {
            return this.file.getDescription();
        }
        catch (InfoException e) {
            throw new NotFoundException((Throwable)e);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public Boolean isDirectory() {
        try {
            return this.file.isDirectory();
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public String getName() {
        try {
            return this.file.getName();
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public Boolean isUnderConstruction() {
        try {
            return this.file.isUnderConstruction();
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public Boolean isLocked() {
        try {
            return this.file.isLocked();
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public Long getModificationDate() {
        try {
            return this.file.getModificationDate();
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public int getNumberOfChildren(boolean showHiddenFiles) {
        try {
            return this.getChildren(showHiddenFiles).length;
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public String getMimeType() {
        ProjectServiceInterface projectService = ClientRemoteLocator.projectService;
        try {
            ProjectFileTypeInfo fileTypeInfo = projectService.getFileType(this.file.getType());
            return fileTypeInfo.getMimeType();
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public ProjectFile[] getChildren(boolean showHiddenFiles) {
        try {
            NoHiddenFileFilter noDotFileFilter = NoHiddenFileFilter.getInstance();
            ArrayList children = new ArrayList();
            Stream.of(this.file.getChildren()).filter(c -> noDotFileFilter.accept(c) || showHiddenFiles).forEach(c -> children.add(new CSBaseProjectFile((ClientProjectFile)c)));
            return children.toArray(new ProjectFile[0]);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.file.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.file.getOutputStream();
    }

    public ProjectFile getChild(String fileName) {
        try {
            ClientProjectFile child = this.file.getChild(fileName);
            if (child == null) {
                throw new InternalServiceException("The file " + fileName + " was not found in path " + this.file.getStringPath());
            }
            return new CSBaseProjectFile(child);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public boolean containsChild(String fileName) {
        try {
            return this.file.getChild(fileName) != null;
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public ProjectFile createFile(String fileName, Locale locale) {
        try {
            ProjectFileType.loadFileTypes((Locale)locale);
            ProjectFileType fileType = ProjectFileType.getProjectFileTypeFromExtension((String)FileUtils.getFileExtension((String)fileName), (boolean)false);
            String fileTypeExtension = fileType != null ? fileType.getCode() : "UNKNOWN";
            this.file.createFile(fileName, fileTypeExtension);
            ClientProjectFile newFile = this.file.getChild(fileName);
            if (newFile == null) {
                throw new InternalServiceException("The file " + fileName + " was not successfully created in path " + this.file.getStringPath());
            }
            return new CSBaseProjectFile(newFile);
        }
        catch (PermissionException e) {
            throw new ibase.exception.PermissionException(e.getMessage());
        }
        catch (InfoException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public void open(boolean readOnly) {
        try {
            this.file.open(readOnly);
        }
        catch (PermissionException e) {
            throw new ibase.exception.PermissionException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public void write(byte[] array, int i, int chunck_size, Long rangeStart) throws IOException {
        try {
            this.file.write(array, i, chunck_size, rangeStart.longValue());
        }
        catch (PermissionException e) {
            throw new ibase.exception.PermissionException(e.getMessage());
        }
        catch (FileLockedException e) {
            throw new InternalServiceException((Throwable)e);
        }
    }

    public void rename(String fileName) {
        try {
            ProjectFileType.loadFileTypes((Locale)Locale.getDefault());
            ProjectFileType fileType = ProjectFileType.getProjectFileTypeFromExtension((String)FileUtils.getFileExtension((String)fileName), (boolean)false);
            String fileTypeExtension = fileType != null ? fileType.getCode() : "UNKNOWN";
            this.file.rename(fileName);
            this.file.setName(fileName);
            this.file.changeType(fileTypeExtension);
        }
        catch (PermissionException e) {
            throw new ibase.exception.PermissionException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public void remove() {
        try {
            this.file.remove();
        }
        catch (PermissionException e) {
            throw new ibase.exception.PermissionException(e.getMessage());
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public long size() {
        try {
            if (this.file.isDirectory()) {
                return 0L;
            }
            return this.file.size();
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public void close(boolean force) throws IOException {
        try {
            this.file.close(force);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }
}

