/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.project.v1;

import csbase.rest.adapter.project.v1.CSBaseProjectFile;
import java.io.BufferedInputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class CharsetDetector {
    public static Charset detectCharset(CSBaseProjectFile f) {
        String[] charsetNames = new String[]{"UTF-8", "ISO-8859-1", "US-ASCII", "windows-1252", "MacRoman", "IBM500"};
        return CharsetDetector.detectCharset(f, charsetNames);
    }

    public static Charset detectCharset(CSBaseProjectFile f, String[] charsets) {
        String charsetName;
        Charset charset = null;
        String[] stringArray = charsets;
        int n = stringArray.length;
        for (int i = 0; i < n && (charset = CharsetDetector.detectCharset(f, Charset.forName(charsetName = stringArray[i]))) == null; ++i) {
        }
        return charset;
    }

    private static Charset detectCharset(CSBaseProjectFile f, Charset charset) {
        try {
            BufferedInputStream input = new BufferedInputStream(f.getInputStream());
            CharsetDecoder decoder = charset.newDecoder();
            decoder.reset();
            byte[] buffer = new byte[512];
            boolean identified = false;
            while (input.read(buffer) != -1 && !identified) {
                identified = CharsetDetector.identify(buffer, decoder);
            }
            input.close();
            if (identified) {
                return charset;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean identify(byte[] bytes, CharsetDecoder decoder) {
        try {
            decoder.decode(ByteBuffer.wrap(bytes));
        }
        catch (CharacterCodingException e) {
            return false;
        }
        return true;
    }
}

