package csbase.rest.adapter.user.v1;

import csbase.logic.Role;
import csbase.remote.AdministrationServiceInterface;
import csbase.remote.ClientRemoteLocator;
import ibase.rest.api.user.v1.adapter.User;

import java.rmi.RemoteException;

import static ibase.rest.api.authentication.v1.adapter.AuthenticationService.GUEST_ROLE_ID;

/**
 * Gateway para um usurio no CSBase.
 *
 * @author Tecgraf/PUC-Rio
 */
public class CSBaseUser implements User {

  /**
   * Usurio no CSBase.
   */
  private csbase.logic.User user;

  /**
   * @param user
   */
  public CSBaseUser(csbase.logic.User user) {
    this.user = user;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getId() {
    return user.getId().toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return user.getName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getLogin() {
    return user.getLogin();
  }

  @Override
  public String getEmail() {
    String[] emails = user.getEmails();
    return (emails!=null && emails.length>0) ? emails[0] : null;
  }

  /**
   * Obtm o link da foto
   */
  @Override
  public String getPhotoLink() {
    return (String)user.getAttribute(csbase.logic.User.PHOTO_LINK);
  }

  /**
   * Verifica se o usurio  administrador.
   */
  @Override
  public boolean isAdmin() {
    return user.isAdmin();
  }

  /**
   * Verifica se o usurio  visitante.
   */
  @Override
  public boolean isGuest() {
    AdministrationServiceInterface administrationService = ClientRemoteLocator.administrationService;
    try {
      Object[] roleIds = user.getRoleIds();
      for (Object id : roleIds) {
        Role role = administrationService.getRole(id);
        if (role.getName().equals(GUEST_ROLE_ID)) {
          return true;
        }
      }
    } catch (RemoteException e) {
    }
    return false;
  }

}
