/*
 * $Id$
 */
package csbase.server.services.algorithmservice;

import tecgraf.javautils.core.timestamp.TStamp64;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmsPack;

/**
 * Representa as informaes referentes ao dado (Pacote de Algoritmos)
 * necessrias para importao e consulta dos algoritmos contidos nele.
 * 
 */
public class ImportAlgorithmsPackDataInfo {
  /** Usurio que solicitou a importao do arquivo do Pacote de Algoritmos */
  private User user;

  /**
   * Token (timestamp) que identifica unicamente o arquivo do Pacote de
   * Algoritmos
   */
  private TStamp64 timestamp;

  /**
   * Estrutura do PA que corresponde  leitura do arquivo de metadados do pacote
   * de algoritmos
   */
  private AlgorithmsPack algoPackage;

  /**
   * Indica se esse dado j foi totalmente descomprimido no diretrio temporrio
   * identificado pelo token
   */
  private boolean isDescompressed;

  /**
   * @param user
   * @param timestamp
   */
  public ImportAlgorithmsPackDataInfo(User user, TStamp64 timestamp) {
    super();
    setUser(user);
    setTimestamp(timestamp);
    setAlgoPackage(null);
    setDescompressed(false);
  }

  /**
   * Construtor padro.
   */
  public ImportAlgorithmsPackDataInfo() {
  }

  /**
   * Retorna
   * 
   * @return user
   */
  public User getUser() {
    return user;
  }

  /**
   * Retorna
   * 
   * @return timestamp
   */
  public TStamp64 getToken() {
    return timestamp;
  }

  /**
   * Retorna
   * 
   * @return algoPackage
   */
  public AlgorithmsPack getAlgoPackage() {
    return algoPackage;
  }

  /**
   * @param algoPackage
   */
  public void setAlgoPackage(AlgorithmsPack algoPackage) {
    this.algoPackage = algoPackage;
  }

  /**
   * @param user
   */
  protected void setUser(User user) {
    this.user = user;
  }

  /**
   * @param timestamp
   */
  protected void setTimestamp(TStamp64 timestamp) {
    this.timestamp = timestamp;
  }

  /**
   * @param wasDescompressed
   */
  public void setDescompressed(boolean wasDescompressed) {
    this.isDescompressed = wasDescompressed;
  }

  /**
   * Retorna
   * 
   * @return wasDescompressed
   */
  public boolean isDescompressed() {
    return isDescompressed;
  }

}
