/*
 * $Id:$
 */

package csbase.server.services.filetransferservice.sftp;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.UserInfo;

import csbase.exception.ServiceFailureException;
import csbase.logic.ProjectFileType;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferRequest;
import csbase.logic.filetransferservice.FileTransferRequestStatus;
import csbase.server.Server;
import csbase.server.services.filetransferservice.FileTransferJob;
import csbase.server.services.filetransferservice.FileTransferService;
import csbase.server.services.projectservice.ProjectService;

/**
 * Job de download no protocolo FTP.
 * 
 * @author Tecgraf/PUC-Rio
 */
class SFTPDownloadJob extends FileTransferJob {

  /**
   * {@inheritDoc}
   */
  @Override
  protected void transfer() throws Exception {
    ProjectService projectService = ProjectService.getInstance();
    FileTransferRequest request = getRequest();
    FileTransferConnection connection = request.getConnection();
    Object projectId = connection.getProjectId();
    String[] localPath = request.getLocalFilePath();
    String remoteFilePath = request.getRemoteFilePath();
    String serverName = connection.getServerName();
    String userName = connection.getUserName();
    String password = connection.getPassword();
    JSch jsch = new JSch();
    int port = 22;
    Session session;
    try {
      session = jsch.getSession(userName, serverName, port);
    }
    catch (JSchException e) {
      throw new ServiceFailureException(e.getMessage(), e);
    }
    UserInfo ui = new StubUserInfo(password);
    session.setUserInfo(ui);
    if (projectService.existsFile(projectId, localPath)) {
      String fileType = ProjectFileType.UNKNOWN;
      String fileName = localPath[localPath.length - 1];
      String[] path = Arrays.copyOf(localPath, localPath.length - 1);
      projectService.createFile(projectId, path, fileName, fileType);
    }
    projectService.setUnderConstruction(projectId, localPath, true);
    InputStream inputStream = null;
    OutputStream outputStream = null;
    try {
      session.connect();
      Channel c = session.openChannel("sftp");
      c.connect();
      ChannelSftp channel = (ChannelSftp) c;
      String[] splittedPath = remoteFilePath.split(File.separator);
      String file = splittedPath[splittedPath.length - 1];
      String dir =
        remoteFilePath.substring(0, remoteFilePath.lastIndexOf(File.separator));
      channel.cd(dir);
      inputStream = channel.get(file, (SftpProgressMonitor) null);
      outputStream = projectService.getOutputStream(projectId, localPath);
      int chunkSize = FileTransferService.CHUNK_SIZE;
      byte[] b = new byte[chunkSize];
      int bytesRead = 0;
      while ((bytesRead = inputStream.read(b)) != -1) {
        outputStream.write(b, 0, bytesRead);
        request.addTransferredSize(bytesRead);
        if (request.getStatus() == FileTransferRequestStatus.INTERRUPTED) {
          return;
        }
      }
      outputStream.flush();
    }
    finally {
      if (outputStream != null) {
        try {
          outputStream.close();
        }
        catch (Exception e) {
          Server.logSevereMessage(e.getMessage(), e);
        }
      }
      if (inputStream != null) {
        try {
          inputStream.close();
        }
        catch (Exception e) {
          Server.logSevereMessage(e.getMessage(), e);
        }
      }
      try {
        projectService.setUnderConstruction(projectId, localPath, false);
      }
      catch (Exception e) {
        Server.logSevereMessage(e.getMessage(), e);
      }
    }
  }

  /**
   * Construtor
   * 
   * @param request requisio.
   */
  public SFTPDownloadJob(FileTransferRequest request) {
    super(request);
  }

}
