/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.filetransferservice;

import csbase.exception.ServiceFailureException;
import csbase.logic.User;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferElement;
import csbase.logic.filetransferservice.FileTransferPredefinedConnection;
import csbase.logic.filetransferservice.FileTransferProtocol;
import csbase.logic.filetransferservice.FileTransferRequest;
import csbase.logic.filetransferservice.FileTransferRequestStatus;
import csbase.logic.filetransferservice.FileTransferRequestType;
import csbase.remote.FileTransferServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.filetransferservice.FileTransferJob;
import csbase.server.services.filetransferservice.FileTransferProtocolStub;
import csbase.server.services.filetransferservice.FileTransferRequestQueue;
import csbase.server.services.filetransferservice.FileTransferServiceMonitorThread;
import csbase.server.services.filetransferservice.ftp.FTPStub;
import csbase.server.services.filetransferservice.sftp.SFTPStub;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public final class FileTransferService
extends Service
implements FileTransferServiceInterface {
    public static final int CHUNK_SIZE = 65536;
    private final FileTransferRequestQueue requestQueue = new FileTransferRequestQueue();
    private final FileTransferServiceMonitorThread monitorThread;
    private final HashMap<FileTransferProtocol, FileTransferProtocolStub> protocolHash = new HashMap();
    private final List<FileTransferPredefinedConnection> predefinedConnections = new ArrayList<FileTransferPredefinedConnection>();

    public boolean checkConnection(FileTransferConnection connection) {
        FileTransferProtocol protocol = connection.getProtocol();
        FileTransferProtocolStub stub = this.protocolHash.get(protocol);
        try {
            return stub.checkConnection(connection);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            throw new ServiceFailureException(e.getMessage());
        }
    }

    public void download(FileTransferConnection connection, String remoteFilePath, String[] localFilePath, long size) throws ServiceFailureException {
        FileTransferRequest request = new FileTransferRequest(FileTransferRequestType.DOWNLOAD, connection, remoteFilePath, localFilePath, size);
        try {
            this.queueRequest(request);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (request.getStatus() != FileTransferRequestStatus.ERROR) {
                request.markError(msg);
            }
            throw new ServiceFailureException(msg);
        }
    }

    public List<FileTransferRequest> getAllRequests(User user) throws ServiceFailureException {
        List<FileTransferRequest> list = this.requestQueue.getAllRequests(user);
        return list;
    }

    final FileTransferRequestQueue getRequestQueue() {
        return this.requestQueue;
    }

    protected boolean has2Update(Object arg, Object event) {
        return true;
    }

    @Override
    public void initService() throws ServerException {
        this.loadPredefinedConnections();
    }

    private void loadPredefinedConnections() {
        String prefix = "predefined.connections.";
        List<String> labels = this.getStringListProperty("predefined.connections.label");
        int i = 1;
        for (String label : labels) {
            Server.logInfoMessage("Conex\u00e3o predefinida encontrada: " + label);
            String serverName = this.getStringProperty("predefined.connections.server." + i);
            String userName = this.getStringProperty("predefined.connections.user." + i);
            String protName = this.getStringProperty("predefined.connections.protocol." + i);
            String homeString = this.getStringProperty("predefined.connections.home." + i);
            FileTransferProtocol protocol = FileTransferProtocol.valueOf((String)protName);
            FileTransferPredefinedConnection preCon = new FileTransferPredefinedConnection(label, protocol, serverName, userName, homeString);
            this.predefinedConnections.add(preCon);
            ++i;
        }
    }

    public void interruptRequest(List<String> idList) throws ServiceFailureException {
        for (String id : idList) {
            FileTransferRequest req = this.requestQueue.getRequestFromId(id);
            if (req != null) {
                req.markCancelled();
            }
            this.requestQueue.moveToEndedList(id);
        }
    }

    void moveToEndedList(String requestId) {
        this.requestQueue.moveToEndedList(requestId);
    }

    public List<FileTransferElement> listContent(FileTransferConnection connection, String remoteDirPath) throws ServiceFailureException {
        FileTransferProtocol protocol = connection.getProtocol();
        FileTransferProtocolStub stub = this.protocolHash.get(protocol);
        try {
            return stub.listContent(connection, remoteDirPath);
        }
        catch (Exception e) {
            String conn = connection.toString();
            String msg = "Falha de listagem de conte\u00fado em " + conn + "::" + remoteDirPath + "!";
            Server.logSevereMessage(msg, e);
            throw new ServiceFailureException(e.getMessage());
        }
    }

    private final void queueRequest(FileTransferRequest request) {
        request.markQueued();
        this.requestQueue.putToWaitList(request);
    }

    public void removeRequest(List<String> idList) throws RemoteException {
        for (String id : idList) {
            FileTransferRequest req = this.requestQueue.getRequestFromId(id);
            if (req == null) continue;
            this.unqueueRequest(req);
        }
    }

    @Override
    public void shutdownService() throws ServerException {
        List<FileTransferRequest> allRequests = this.getAllRequests(null);
        for (FileTransferRequest req : allRequests) {
            req.markCancelled();
            req.markDeleted();
        }
        this.monitorThread.interrupt();
    }

    final synchronized void startRequest(FileTransferRequest request) throws Exception {
        FileTransferJob job;
        String id = request.getId();
        FileTransferConnection connection = request.getConnection();
        FileTransferProtocol protocol = connection.getProtocol();
        FileTransferProtocolStub stub = this.protocolHash.get(protocol);
        FileTransferRequestType type = request.getType();
        switch (type) {
            case DOWNLOAD: {
                job = stub.createDownloadJob(request);
                break;
            }
            case UPLOAD: {
                job = stub.createUploadJob(request);
                break;
            }
            default: {
                throw new Exception("Unsupported request type detected");
            }
        }
        this.requestQueue.moveFromWaitToRunList(id);
        Thread thread = new Thread(job);
        thread.setName(id);
        thread.start();
    }

    private final void unqueueRequest(FileTransferRequest request) {
        FileTransferRequestStatus status = request.getStatus();
        if (status == FileTransferRequestStatus.QUEUED) {
            return;
        }
        if (status == FileTransferRequestStatus.RUNNING) {
            return;
        }
        request.markDeleted();
        this.requestQueue.removeFromAllLists(request);
    }

    public void upload(FileTransferConnection connection, String remoteFilePath, String[] localFilePath, long size) throws RemoteException {
        FileTransferRequest request = new FileTransferRequest(FileTransferRequestType.UPLOAD, connection, remoteFilePath, localFilePath, size);
        try {
            this.queueRequest(request);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (request.getStatus() != FileTransferRequestStatus.ERROR) {
                request.markError(msg);
            }
            throw new ServiceFailureException(msg);
        }
    }

    public static void createService() throws ServerException {
        new FileTransferService();
    }

    public static FileTransferService getInstance() {
        return (FileTransferService)FileTransferService.getInstance("FileTransferService");
    }

    protected FileTransferService() throws ServerException {
        super("FileTransferService");
        this.protocolHash.put(FileTransferProtocol.FTP, new FTPStub());
        this.protocolHash.put(FileTransferProtocol.SFTP, new SFTPStub());
        Collections.unmodifiableMap(this.protocolHash);
        this.monitorThread = new FileTransferServiceMonitorThread(this);
        this.monitorThread.start();
    }

    public List<FileTransferPredefinedConnection> getPredefinedConnections() throws RemoteException {
        User user = FileTransferService.getUser();
        String login = user.getLogin();
        ArrayList<FileTransferPredefinedConnection> list = new ArrayList<FileTransferPredefinedConnection>();
        for (FileTransferPredefinedConnection conn : this.predefinedConnections) {
            FileTransferPredefinedConnection connection = this.buildPredefinedConnectionForUser(login, conn);
            list.add(connection);
        }
        return list;
    }

    private FileTransferPredefinedConnection buildPredefinedConnectionForUser(String login, FileTransferPredefinedConnection connection) {
        String label = connection.getLabel();
        FileTransferProtocol protocol = connection.getProtocol();
        String serverName = connection.getServerName();
        String uName = connection.getUserName();
        String userName = uName.replaceAll("\\$LOGIN", login);
        String hString = connection.getHomePath();
        String homeString = hString.replaceAll("\\$LOGIN", login);
        FileTransferPredefinedConnection conn = new FileTransferPredefinedConnection(label, protocol, serverName, userName, homeString);
        return conn;
    }
}

