/*
 * $Id$
 */

package csbase.server.services.filetransferservice;

import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferRequest;
import csbase.server.Server;
import csbase.server.Service;

/**
 * Thread de transferncia
 * 
 * @author Tecgraf/PUC-Rio
 */
public abstract class FileTransferJob implements Runnable {

  /**
   * Requisio
   */
  final private FileTransferRequest request;

  /**
   * Consulta o valor de request
   * 
   * @return o valor
   */
  public FileTransferRequest getRequest() {
    return request;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void run() {
    request.markRunning();
    FileTransferService service = FileTransferService.getInstance();
    String requestId = request.getId();
    FileTransferConnection connection = request.getConnection();
    Object userId = connection.getUserId();
    Service.setUserId(userId);
    try {
      transfer();
    }
    catch (Exception e) {
      request.markError(e.getMessage());
      Server.logSevereMessage("Falha em: "+requestId, e);
    }
    finally {
      Service.setUserId(null);
    }
    request.markEnd();
    service.moveToEndedList(requestId);
  }

  /**
   * Mtodo que efetivamente faz a transferncia do dado.
   * 
   * @throws Exception em caso de falha na transferncia.
   */
  abstract protected void transfer() throws Exception;

  /**
   * Construtor
   * 
   * @param request requisio.
   */
  public FileTransferJob(FileTransferRequest request) {
    this.request = request;
  }
}
