/*
 * $Id$
 */
package csbase.server.services.projectservice.v1_01;

import java.io.Serializable;

import org.omg.CORBA.UserException;

import tecgraf.openbus.data_service.core.v1_01.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_01.DataNotFound;
import csbase.exception.OperationFailureException;
import csbase.logic.FileUpdateNotification.Result;
import csbase.server.Server;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.projectservice.ProjectFileUpdater;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.projectservice.UpdatableFileLocation;

/**
 * Representa um atualizador de arquivo de projeto obtidos atravs do OpenBus.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class OpenBusProjectFileUpdater implements ProjectFileUpdater {
  /**
   * {@inheritDoc}
   */
  @Override
  public Result update(UpdatableFileLocation fileLocation,
    Serializable userData, Serializable extraUserData) {
    if (!OpenBusService.getInstance().isEnabled()) {
      return Result.DISABLED;
    }

    try {
      OpenBusService.getInstance().joinChain((byte[]) extraUserData);

      byte[] fSourceDataKey = (byte[]) userData;
      ProjectDataService projectDataService = ProjectDataService.getInstance();
      try {
        projectDataService.updateDataFrom(fileLocation.getProjectId(),
          fileLocation.getPath(), fSourceDataKey);
      }
      catch (DataNotFound e) {
        String absoluteSourcePath =
          ProjectService.getInstance().getAbsolutePath(
            fileLocation.getProjectId(), fileLocation.getPath());
        Server.logSevereMessage(String.format(
          "O dado de origem do arquivo %s no foi encontrado.",
          absoluteSourcePath), e);
        return Result.SOURCE_NOT_FOUND;
      }
      catch (DataAccessDenied e) {
        String absoluteSourcePath =
          ProjectService.getInstance().getAbsolutePath(
            fileLocation.getProjectId(), fileLocation.getPath());
        Server.logSevereMessage(String.format(
          "Sem permisso para acessar o dado do arquivo %s.",
          absoluteSourcePath), e);
        return Result.NO_PERMISSION;
      }
      catch (UserException e) {
        String absoluteSourcePath =
          ProjectService.getInstance().getAbsolutePath(
            fileLocation.getProjectId(), fileLocation.getPath());
        Server.logSevereMessage(String.format(
          "Erro ao atualizar o arquivo %s.", absoluteSourcePath), e);
        return Result.UNEXPECTED_ERROR;
      }

      return Result.SUCCESS;
    }
    catch (OperationFailureException e) {
      String absoluteSourcePath =
        ProjectService.getInstance().getAbsolutePath(
          fileLocation.getProjectId(), fileLocation.getPath());
      Server.logSevereMessage(String.format(
        "Erro ao unir a cadeia de chamadas para a atualizao do arquivo %s.",
        absoluteSourcePath), e);
      return Result.UNEXPECTED_ERROR;
    }
    finally {
      OpenBusService.getInstance().exitChain();
    }
  }
}
