/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.administrationservice;

import csbase.exception.PermissionException;
import csbase.exception.ServiceFailureException;
import csbase.exception.administration.AdministrationDeleteException;
import csbase.logic.AdministrationEvent;
import csbase.logic.IdInterface;
import csbase.logic.Permission;
import csbase.logic.Platform;
import csbase.logic.PlatformInfo;
import csbase.logic.Role;
import csbase.logic.RoleInfo;
import csbase.logic.User;
import csbase.logic.UserAdministrationPermission;
import csbase.logic.UserGroup;
import csbase.logic.UserGroupInfo;
import csbase.logic.UserInfo;
import csbase.logic.UserOutline;
import csbase.logic.UserPasswordPermission;
import csbase.logic.UserProjectInfo;
import csbase.logic.UserUpdate;
import csbase.remote.AdministrationServiceInterface;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.TransactionCallbackInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.TransactionManager;
import csbase.server.services.administrationservice.AdministrationDAOFactory;
import csbase.server.services.administrationservice.DAOException;
import csbase.server.services.administrationservice.DefaultAdministrationDAOFactory;
import csbase.server.services.administrationservice.LocalAdministrationService;
import csbase.server.services.administrationservice.PermissionDAO;
import csbase.server.services.administrationservice.PlatformDAO;
import csbase.server.services.administrationservice.RoleDAO;
import csbase.server.services.administrationservice.UserDAO;
import csbase.server.services.administrationservice.UserGroupDAO;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.projectservice.ProjectService;
import csbase.util.messages.Message;
import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.ImageIcon;

public class AdministrationService
extends Service
implements AdministrationServiceInterface,
TransactionCallbackInterface {
    private final String PHOTOS_SUBDIRECTORY = "photos";
    protected TransactionManager transaction;
    protected UserDAO userDAO;
    protected UserGroupDAO userGroupsDAO;
    protected RoleDAO roleDAO;
    protected PlatformDAO platformDAO;
    protected PermissionDAO permissionDAO;

    public static void createService() throws ServerException {
        if (Server.getInstance().isCentralServer()) {
            new AdministrationService();
        } else {
            new LocalAdministrationService();
        }
    }

    protected AdministrationService() throws ServerException {
        super("AdministrationService");
        AdministrationDAOFactory daoFactory = null;
        String DAO_FACTORY_CLASS_NAME_PROPERTY = "dao.factory.class.name";
        if (this.isPropertyNull("dao.factory.class.name")) {
            Server.logInfoMessage("F\u00e1brica DAO n\u00e3o ajustada. Usando f\u00e1brica default...");
            daoFactory = new DefaultAdministrationDAOFactory();
        } else {
            String daoFactoryClassName = this.getStringProperty("dao.factory.class.name");
            try {
                Class<?> daoFactoryClass = Class.forName(daoFactoryClassName);
                daoFactory = (AdministrationDAOFactory)daoFactoryClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                Server.logInfoMessage("A classe da f\u00e1brica de DAOs do AdminstrationService (" + daoFactoryClassName + ") n\u00e3o foi encontrada no classpath do servidor");
                daoFactory = new DefaultAdministrationDAOFactory();
            }
            catch (IllegalAccessException e) {
                Server.logInfoMessage("A classe da f\u00e1brica de DAOs do AdminstrationService (" + daoFactoryClassName + ") ou o seu construtor n\u00e3o est\u00e1 acess\u00edvel");
                daoFactory = new DefaultAdministrationDAOFactory();
            }
            catch (InstantiationException e) {
                Server.logInfoMessage("A classe da f\u00e1brica de DAOs do AdminstrationService (" + daoFactoryClassName + ") n\u00e3o pode ser instanciada");
                daoFactory = new DefaultAdministrationDAOFactory();
            }
        }
        Server.logInfoMessage("Usando a implementa\u00e7\u00e3o '" + daoFactory.getClass().getName() + "' da f\u00e1brica de " + "DAOs do AdminstrationService");
        try {
            this.transaction = new TransactionManager();
            this.userDAO = daoFactory.createUserDAO();
            this.userGroupsDAO = daoFactory.createUserGroupDAO();
            this.roleDAO = daoFactory.createRoleDAO();
            this.platformDAO = daoFactory.createPlatformDAO();
            this.permissionDAO = daoFactory.createPermissionDAO();
        }
        catch (Exception e) {
            throw new ServerException(e);
        }
        ClientRemoteLocator.administrationService = this;
    }

    public static AdministrationService getInstance() {
        return (AdministrationService)AdministrationService.getInstance("AdministrationService");
    }

    @Override
    public void shutdownService() {
        Server.logInfoMessage("Terminando servi\u00e7o de administra\u00e7\u00e3o...");
    }

    public String getPhotoDirectory() {
        Server server = Server.getInstance();
        return server.getPersistencyRootDirectoryName() + File.separator + "photos";
    }

    private void createPhotoDirectory() throws ServerException {
        String dname = this.getPhotoDirectory();
        Server.checkDirectory(dname);
    }

    @Override
    public void initService() throws ServerException {
        this.createPhotoDirectory();
    }

    protected void notifyObservers(int type, Object item) {
        AdministrationEvent event = new AdministrationEvent(type, item);
        this.sendEvent(event);
        try {
            if (item instanceof User) {
                User.update((AdministrationEvent)event);
            } else if (item instanceof UserGroup) {
                UserGroup.update((AdministrationEvent)event);
            } else if (item instanceof Role) {
                Role.update((AdministrationEvent)event);
            } else if (item instanceof Platform) {
                Platform.update((AdministrationEvent)event);
            } else if (item instanceof Permission) {
                Permission.update((AdministrationEvent)event);
            }
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na notifica\u00e7\u00e3o local", e);
        }
    }

    protected boolean has2Update(Object arg, Object event) {
        if (arg == null) {
            return true;
        }
        Object item = ((AdministrationEvent)event).item;
        if (item == null) {
            return true;
        }
        Object id = null;
        if (item instanceof IdInterface) {
            if (item instanceof Permission) {
                return true;
            }
            id = ((IdInterface)item).getId();
        } else if (item instanceof User) {
            id = ((User)item).getId();
        } else if (item instanceof Platform) {
            id = ((Platform)item).getId();
        }
        return arg.equals(id);
    }

    public boolean lock(TransactionCallbackInterface cb) {
        return this.transaction.lock(cb);
    }

    public boolean isLocked() {
        return this.transaction.isLocked();
    }

    public void unlock(TransactionCallbackInterface cb) {
        this.transaction.unlock(cb);
    }

    protected void checkTransaction() throws ServiceFailureException {
        if (this.transaction.isLocked()) {
            throw new ServiceFailureException(this.getString("AdministrationService.error.operation.lock"));
        }
    }

    public User getUser(Object id) {
        try {
            return this.userDAO.readUser(id);
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.get.user"), id), e.getMessage(), (Throwable)e);
        }
    }

    public List<UserUpdate> getAllUserUpdates() {
        try {
            return this.userDAO.readAllUserUpdates();
        }
        catch (DAOException e) {
            throw new ServiceFailureException(this.getString("AdministrationService.error.get.users"), e.getMessage(), (Throwable)e);
        }
    }

    public Set<Object> getAllUserIds() {
        try {
            return this.userDAO.readAllUserIds();
        }
        catch (DAOException e) {
            throw new ServiceFailureException(this.getString("AdministrationService.error.get.users"), e.getMessage(), (Throwable)e);
        }
    }

    public List<UserOutline> getAllUserOutlines() {
        try {
            return this.userDAO.readAllUserOutlines();
        }
        catch (DAOException e) {
            throw new ServiceFailureException(this.getString("AdministrationService.error.get.users"), e.getMessage(), (Throwable)e);
        }
    }

    public List<User> getAllUsers() {
        try {
            return this.userDAO.readAllUsers();
        }
        catch (DAOException e) {
            throw new ServiceFailureException(this.getString("AdministrationService.error.get.users"), e.getMessage(), (Throwable)e);
        }
    }

    protected void checkCreateUserPermission() throws PermissionException {
        User loggedUser = Service.getUser();
        Permission permission = loggedUser.getPermission(UserAdministrationPermission.class);
        if (!loggedUser.isAdmin() && permission == null) {
            throw new PermissionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User createUser(UserInfo info) {
        this.checkCreateUserPermission();
        if (!Service.getUser().isAdmin()) {
            Server.logInfoMessage("Criando Usu\u00e1rio: " + info.getLogin());
        }
        try {
            User user = null;
            TransactionManager transactionManager = this.transaction;
            synchronized (transactionManager) {
                this.checkTransaction();
                try {
                    this.lock(this);
                    user = this.userDAO.createUser(info);
                }
                finally {
                    this.unlock(this);
                }
            }
            this.notifyObservers(1, user);
            return user;
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.create.user"), info.getLogin()), e.getMessage(), (Throwable)e);
        }
    }

    protected void checkModifyUserPermission(Object id, UserInfo info) throws RemoteException, PermissionException {
        User loggedUser = Service.getUser();
        Permission permission = loggedUser.getPermission(UserAdministrationPermission.class);
        if (!loggedUser.isAdmin() && permission == null) {
            if (!loggedUser.getId().equals(id)) {
                throw new PermissionException();
            }
            if (loggedUser.getId().equals(id)) {
                Object[] newUserPermissionIds;
                Object[] newUserRoleIds;
                User newUser = new User(id, info);
                if (!UserGroup.getUserGroupFromUser((User)newUser).equals((Object)UserGroup.getUserGroupFromUser((User)loggedUser))) {
                    throw new PermissionException();
                }
                Object[] userRoleIds = loggedUser.getRoleIds();
                if (userRoleIds.length != (newUserRoleIds = newUser.getRoleIds()).length) {
                    throw new PermissionException();
                }
                for (int i = 0; i < userRoleIds.length; ++i) {
                    if (userRoleIds[i].equals(newUserRoleIds[i])) continue;
                    throw new PermissionException();
                }
                Object[] userPermissionIds = loggedUser.getPermissionIds();
                if (userPermissionIds.length != (newUserPermissionIds = newUser.getPermissionIds()).length) {
                    throw new PermissionException();
                }
                for (int i = 0; i < userPermissionIds.length; ++i) {
                    if (userPermissionIds[i].equals(newUserPermissionIds[i])) continue;
                    throw new PermissionException();
                }
            }
        }
    }

    public ImageIcon getPhoto(Object id) {
        if (id == null) {
            return null;
        }
        String fname = id.toString() + ".gif";
        String PATH = this.getPhotoDirectory() + File.separator + fname;
        File file = new File(PATH);
        if (!file.exists()) {
            return null;
        }
        return new ImageIcon(PATH);
    }

    public File getPhotoFile(Object id) {
        if (id == null) {
            return null;
        }
        String fname = id.toString() + ".gif";
        String PATH = this.getPhotoDirectory() + File.separator + fname;
        File file = new File(PATH);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User modifyUser(Object id, UserInfo info) throws RemoteException {
        this.checkModifyUserPermission(id, info);
        if (!Service.getUser().isAdmin()) {
            Server.logInfoMessage("Criando Usu\u00e1rio: " + id);
        }
        try {
            User user = null;
            TransactionManager transactionManager = this.transaction;
            synchronized (transactionManager) {
                this.checkTransaction();
                try {
                    this.lock(this);
                    user = this.userDAO.modifyUser(id, info);
                }
                finally {
                    this.unlock(this);
                }
            }
            this.notifyObservers(2, user);
            return user;
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.modify.user"), id), e.getMessage(), (Throwable)e);
        }
    }

    protected void checkDeleteUserPermission() throws PermissionException {
        User loggedUser = Service.getUser();
        Permission permission = loggedUser.getPermission(UserAdministrationPermission.class);
        if (!loggedUser.isAdmin() && permission == null) {
            throw new PermissionException();
        }
    }

    protected void checkNoProjects(Object userId) throws AdministrationDeleteException {
        List<UserProjectInfo> projects;
        ProjectService projService = ProjectService.getInstance();
        if (projService != null && (projects = projService.getProjectsFromUser(userId)) != null && projects.size() > 0) {
            throw new AdministrationDeleteException(String.format(this.getString("AdministrationService.error.delete.user.having.project"), userId));
        }
    }

    protected void removeUserFromSharedProjects(Object userId) {
        ProjectService projService = ProjectService.getInstance();
        if (projService != null) {
            List<UserProjectInfo> sharedProjectsInfo = projService.getProjectsSharedWithUser(userId);
            for (UserProjectInfo anUserProjectInfo : sharedProjectsInfo) {
                try {
                    projService.removeUser(anUserProjectInfo.getProjectId(), userId);
                }
                catch (Exception e) {
                    Server.logSevereMessage(String.format("Falha ao remover o usu\u00e1rio '%s' do projeto '%s'.", userId, anUserProjectInfo.getProjectId()), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUser(Object id) throws RemoteException, AdministrationDeleteException {
        this.checkDeleteUserPermission();
        this.checkNoProjects(id);
        if (!Service.getUser().isAdmin()) {
            Server.logInfoMessage("Excluindo Usu\u00e1rio: " + id);
        }
        try {
            User user = null;
            TransactionManager transactionManager = this.transaction;
            synchronized (transactionManager) {
                this.checkTransaction();
                try {
                    this.lock(this);
                    user = User.getUser((Object)id);
                    if (user == null) {
                        throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.invalid.user"), id));
                    }
                    this.removeUserFromSharedProjects(id);
                    this.userDAO.deleteUser(id);
                }
                finally {
                    this.unlock(this);
                }
            }
            this.notifyObservers(3, user);
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.delete.user"), id), e.getMessage(), (Throwable)e);
        }
    }

    public User changeUser(User superuser, String delegatedLogin) {
        try {
            return this.userDAO.changeUser(superuser, delegatedLogin);
        }
        catch (DAOException e) {
            String msg = String.format(this.getString("AdministrationService.error.change.user"), delegatedLogin);
            Server.logSevereMessage("changeUser: " + msg, e);
            throw new ServiceFailureException(msg);
        }
    }

    public UserGroup getUserGroup(Object id) {
        try {
            return this.userGroupsDAO.readUserGroup(id);
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.get.usergroup"), id), e.getMessage(), (Throwable)e);
        }
    }

    public List<UserGroup> getAllUserGroups() {
        try {
            return this.userGroupsDAO.readAllUserGroups();
        }
        catch (DAOException e) {
            throw new ServiceFailureException(this.getString("AdministrationService.error.get.usergroups"), e.getMessage(), (Throwable)e);
        }
    }

    protected void checkCreateUserGroupPermission() throws PermissionException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserGroup createUserGroup(UserGroupInfo info) {
        this.checkCreateUserGroupPermission();
        try {
            UserGroup userGroup = null;
            TransactionManager transactionManager = this.transaction;
            synchronized (transactionManager) {
                this.checkTransaction();
                try {
                    this.lock(this);
                    userGroup = this.userGroupsDAO.createUserGroup(info);
                }
                finally {
                    this.unlock(this);
                }
            }
            this.notifyObservers(1, userGroup);
            return userGroup;
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.create.usergroup"), info.name), e.getMessage(), (Throwable)e);
        }
    }

    protected void checkModifyUserGroupPermission() throws PermissionException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserGroup modifyUserGroup(Object id, UserGroupInfo info) {
        this.checkModifyUserGroupPermission();
        try {
            UserGroup userGroup = null;
            TransactionManager transactionManager = this.transaction;
            synchronized (transactionManager) {
                this.checkTransaction();
                try {
                    this.lock(this);
                    userGroup = this.userGroupsDAO.modifyUserGroup(id, info);
                }
                finally {
                    this.unlock(this);
                }
            }
            this.notifyObservers(2, userGroup);
            return userGroup;
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.modify.usergroup"), id), e.getMessage(), (Throwable)e);
        }
    }

    protected void checkDeleteUserGroupPermission() throws PermissionException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUserGroup(Object id) throws RemoteException, AdministrationDeleteException {
        this.checkDeleteUserGroupPermission();
        try {
            UserGroup userGroup = null;
            TransactionManager transactionManager = this.transaction;
            synchronized (transactionManager) {
                boolean userInGroup = false;
                this.checkTransaction();
                try {
                    this.lock(this);
                    for (User user : User.getAllUsers()) {
                        if (user.getId().equals(User.getAdminId()) || !UserGroup.getUserGroupFromUser((User)user).getId().equals(id)) continue;
                        userInGroup = true;
                        break;
                    }
                    if (userInGroup) {
                        throw new AdministrationDeleteException(String.format(this.getString("AdministrationService.error.delete.usergroup.having.user"), id));
                    }
                    userGroup = UserGroup.getUserGroup((Object)id);
                    if (userGroup == null) {
                        throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.invalid.usergroup"), id));
                    }
                    this.userGroupsDAO.deleteUserGroup(id);
                }
                finally {
                    this.unlock(this);
                }
            }
            this.notifyObservers(3, userGroup);
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.delete.usergroup"), id), e.getMessage(), (Throwable)e);
        }
    }

    public List<Role> getAllRoles() {
        try {
            return this.roleDAO.readAllRoles();
        }
        catch (DAOException e) {
            throw new ServiceFailureException(this.getString("AdministrationService.error.get.roles"), e.getMessage(), (Throwable)e);
        }
    }

    public Role getRole(Object id) {
        try {
            return this.roleDAO.readRole(id);
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.get.role"), id), e.getMessage(), (Throwable)e);
        }
    }

    protected void checkCreateRolePermission() throws PermissionException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Role createRole(RoleInfo info) {
        this.checkCreateRolePermission();
        try {
            Role role = null;
            TransactionManager transactionManager = this.transaction;
            synchronized (transactionManager) {
                this.checkTransaction();
                try {
                    this.lock(this);
                    role = this.roleDAO.createRole(info);
                }
                finally {
                    this.unlock(this);
                }
            }
            this.notifyObservers(1, role);
            return role;
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.create.role"), info.name), e.getMessage(), (Throwable)e);
        }
    }

    protected void checkModifyRolePermission() throws PermissionException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Role modifyRole(Object id, RoleInfo info) {
        this.checkModifyRolePermission();
        try {
            Role role = null;
            TransactionManager transactionManager = this.transaction;
            synchronized (transactionManager) {
                this.checkTransaction();
                try {
                    this.lock(this);
                    role = this.roleDAO.modifyRole(id, info);
                }
                finally {
                    this.unlock(this);
                }
            }
            this.notifyObservers(2, role);
            return role;
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.modify.role"), id), e.getMessage(), (Throwable)e);
        }
    }

    protected void checkDeleteRolePermission() throws PermissionException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRole(Object id) throws AdministrationDeleteException, RemoteException {
        this.checkDeleteRolePermission();
        try {
            Role role = null;
            TransactionManager transactionManager = this.transaction;
            synchronized (transactionManager) {
                boolean userInRole = false;
                this.checkTransaction();
                try {
                    this.lock(this);
                    userInRole = User.hasAnyUserWithRole((Object)id);
                    if (userInRole) {
                        throw new AdministrationDeleteException(String.format(this.getString("AdministrationService.error.delete.role.having.user"), id));
                    }
                    role = Role.getRole((Object)id);
                    if (role == null) {
                        throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.invalid.role"), id));
                    }
                    this.roleDAO.deleteRole(id);
                }
                finally {
                    this.unlock(this);
                }
            }
            this.notifyObservers(3, role);
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.delete.role"), id), e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getPermissionClasses() {
        String propName = "permission.class";
        return this.getStringListProperty("permission.class");
    }

    public List<Permission> getAllPermissions() {
        try {
            return this.permissionDAO.readAllPermissions();
        }
        catch (DAOException e) {
            throw new ServiceFailureException(this.getString("AdministrationService.error.get.permissions"), e.getMessage(), (Throwable)e);
        }
    }

    protected void checkGetPermissionWithPassword() throws PermissionException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
    }

    public List<Permission> getAllPermissionsWithPasswords() {
        this.checkGetPermissionWithPassword();
        try {
            List<Permission> permissions = this.permissionDAO.readAllPermissions();
            for (int i = 0; i < permissions.size(); ++i) {
                if (!(permissions.get(i) instanceof UserPasswordPermission)) continue;
                UserPasswordPermission upp = (UserPasswordPermission)permissions.get(i);
                upp.setPassword(upp.getLocalPassword());
            }
            return permissions;
        }
        catch (DAOException e) {
            throw new ServiceFailureException(this.getString("AdministrationService.error.get.permissions"), e.getMessage(), (Throwable)e);
        }
    }

    public Permission getPermission(Object id) {
        try {
            return this.permissionDAO.readPermission(id);
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.get.permission"), id), e.getMessage(), (Throwable)e);
        }
    }

    public Permission getPermissionWithPassword(Object id) {
        this.checkGetPermissionWithPassword();
        try {
            Permission permission = this.permissionDAO.readPermission(id);
            if (permission instanceof UserPasswordPermission) {
                UserPasswordPermission upp = (UserPasswordPermission)permission;
                upp.setPassword(upp.getLocalPassword());
            }
            return permission;
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.get.permission"), id), e.getMessage(), (Throwable)e);
        }
    }

    protected void checkCreatePermissionPermission() throws PermissionException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permission createPermission(Permission permission) {
        this.checkCreatePermissionPermission();
        try {
            Permission result = null;
            TransactionManager transactionManager = this.transaction;
            synchronized (transactionManager) {
                this.checkTransaction();
                try {
                    this.lock(this);
                    result = this.permissionDAO.createPermission(permission);
                }
                finally {
                    this.unlock(this);
                }
            }
            this.notifyObservers(1, result);
            return result;
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.create.permission"), permission.getName()), e.getMessage(), (Throwable)e);
        }
    }

    protected void checkModifyPermissionPermission() throws PermissionException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permission modifyPermission(Object id, Permission permission) {
        this.checkModifyPermissionPermission();
        try {
            Permission result = null;
            TransactionManager transactionManager = this.transaction;
            synchronized (transactionManager) {
                this.checkTransaction();
                try {
                    this.lock(this);
                    result = this.permissionDAO.modifyPermission(id, permission);
                }
                finally {
                    this.unlock(this);
                }
            }
            this.notifyObservers(2, result);
            return result;
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.modify.permission"), id), e.getMessage(), (Throwable)e);
        }
    }

    protected void checkDeletePermissionPermission() throws PermissionException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePermission(Object id) throws AdministrationDeleteException, RemoteException {
        this.checkDeletePermissionPermission();
        try {
            Permission permission = null;
            TransactionManager transactionManager = this.transaction;
            synchronized (transactionManager) {
                this.checkTransaction();
                boolean userInPermission = false;
                boolean roleInPermission = false;
                try {
                    this.lock(this);
                    userInPermission = User.hasAnyUserWithPermission((Object)id);
                    roleInPermission = Role.hasAnyRoleWithPermission((Object)id);
                    if (userInPermission || roleInPermission) {
                        throw new AdministrationDeleteException(String.format(this.getString("AdministrationService.error.delete.permission.having.user"), id));
                    }
                    permission = Permission.getPermission((Object)id);
                    if (permission == null) {
                        throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.invalid.permission"), id));
                    }
                    this.permissionDAO.deletePermission(id);
                }
                finally {
                    this.unlock(this);
                }
            }
            this.notifyObservers(3, permission);
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.delete.permission"), id), e.getMessage(), (Throwable)e);
        }
    }

    public List<Platform> getAllPlatforms() {
        try {
            return this.platformDAO.readAllPlatforms();
        }
        catch (DAOException e) {
            throw new ServiceFailureException(this.getString("AdministrationService.error.get.platforms"), e.getMessage(), (Throwable)e);
        }
    }

    public Platform getPlatform(Object id) {
        try {
            return this.platformDAO.readPlatform(id);
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.get.platform"), id), e.getMessage(), (Throwable)e);
        }
    }

    protected void checkCreatePlatformPermission() throws PermissionException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Platform createPlatform(PlatformInfo info) {
        this.checkCreatePlatformPermission();
        try {
            Platform platform = null;
            TransactionManager transactionManager = this.transaction;
            synchronized (transactionManager) {
                this.checkTransaction();
                try {
                    this.lock(this);
                    platform = this.platformDAO.createPlatform(info);
                }
                finally {
                    this.unlock(this);
                }
            }
            this.notifyObservers(1, platform);
            return platform;
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.create.platform"), info.name), e.getMessage(), (Throwable)e);
        }
    }

    protected void checkModifyPlatformPermission() throws PermissionException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Platform modifyPlatform(Object id, PlatformInfo info) {
        this.checkModifyPlatformPermission();
        try {
            Platform platform = null;
            TransactionManager transactionManager = this.transaction;
            synchronized (transactionManager) {
                this.checkTransaction();
                try {
                    this.lock(this);
                    platform = this.platformDAO.modifyPlatform(id, info);
                }
                finally {
                    this.unlock(this);
                }
            }
            this.notifyObservers(2, platform);
            return platform;
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.modify.platform"), id), e.getMessage(), (Throwable)e);
        }
    }

    protected void checkDeletePlatformPermission() throws PermissionException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePlatform(Object id) throws RemoteException {
        this.checkDeletePlatformPermission();
        try {
            Platform platform = null;
            TransactionManager transactionManager = this.transaction;
            synchronized (transactionManager) {
                this.checkTransaction();
                try {
                    this.lock(this);
                    platform = Platform.getPlatform((Object)id);
                    if (platform == null) {
                        throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.invalid.platform"), id));
                    }
                    this.platformDAO.deletePlatform(id);
                }
                finally {
                    this.unlock(this);
                }
            }
            this.notifyObservers(3, platform);
        }
        catch (DAOException e) {
            throw new ServiceFailureException(String.format(this.getString("AdministrationService.error.delete.platform"), id), e.getMessage(), (Throwable)e);
        }
    }

    public boolean isAlive() throws RemoteException {
        return this.isActive();
    }

    private void sendEvent(AdministrationEvent event) {
        MessageService.getInstance().sendToAll(new Message((Serializable)event));
    }

    public void setLocale(Locale locale) {
        Service.setUserLocale(locale);
    }

    public Locale getCurrentLocale() {
        Locale locale = this.getThreadLocale();
        if (locale == null) {
            locale = this.getDefaultLocale();
        }
        return locale;
    }
}

