/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.SGASetCPUComparator;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;
import csbase.server.services.sgaservice.SGAService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PercCPUPolicy
implements SchedulerPolicyInterface {
    @Override
    public String chooseServer(CommandInfo command, List<String> serversNames) {
        List<String> sgasNames = this.getSortedSGAByCPU(serversNames);
        if (sgasNames.size() != 0) {
            return sgasNames.get(0);
        }
        return null;
    }

    @Override
    public List<String> chooseServers(CommandInfo command, List<String> serversNames, int numServers) {
        List<String> sgasNames = this.getSortedSGAByCPU(serversNames);
        if (sgasNames.size() >= numServers) {
            return sgasNames.subList(0, numServers);
        }
        return null;
    }

    private List<String> getSortedSGAByCPU(List<String> serversNames) {
        ArrayList<SGASet> sgasSets = new ArrayList<SGASet>();
        ArrayList<String> sgasNames = new ArrayList<String>();
        SGAService sgaService = SGAService.getInstance();
        for (int i = 0; i < serversNames.size(); ++i) {
            SGASet sgaSet = sgaService.getSGASet(serversNames.get(i));
            if (sgaSet == null) continue;
            sgasSets.add(sgaSet);
        }
        Collections.sort(sgasSets, new SGASetCPUComparator());
        for (SGASet sga : sgasSets) {
            sgasNames.add(sga.getName());
        }
        return sgasNames;
    }
}

