package csbase.server.services.administrationservice;

import java.io.IOException;
import java.util.List;

import csbase.logic.UserGroup;
import csbase.logic.UserGroupInfo;

/**
 * Implementao padro do DAO de grupo de usurio. Utiliza armazenamento em
 * arquivo (serializao de objetos).
 * 
 * @see DefaultAdministrationDAOFactory
 * @author Jorge Alexandre
 * 
 */
public class DefaultUserGroupDAO implements UserGroupDAO {

  private UserGroupIO userGroupsRepository;

  public DefaultUserGroupDAO() {
    this.userGroupsRepository = new UserGroupIO();
  }

  public UserGroup createUserGroup(UserGroupInfo info) throws DAOException {
    UserGroup userGroup;
    try {
      userGroup = userGroupsRepository.writeNew(info);
    }
    catch (IOException e) {
      String operationInfo = "[name: " + info.name + ", desc: " + info.desc
        + "]";
      throw new DAOException(e, operationInfo);
    }
    if (userGroup == null) {
      String operationInfo = "[name: " + info.name + ", desc: " + info.desc
        + "]";
      throw new DAOException("Falha em UserGroupIO.writeNew", operationInfo);
    }
    return userGroup;
  }

  public void deleteUserGroup(Object id) throws DAOException {
    try {
      userGroupsRepository.delete(id);
    }
    catch (IOException e) {
      throw new DAOException(e, "id: " + id);
    }

  }

  public UserGroup modifyUserGroup(Object id, UserGroupInfo info)
    throws DAOException {
    UserGroup userGroup;
    try {
      userGroup = userGroupsRepository.write(id, info);
    }
    catch (IOException e) {
      String operationInfo = "[name: " + info.name + ", desc: " + info.desc
        + "] - para o usurio: " + id;
      throw new DAOException(e, operationInfo);
    }
    if (userGroup == null) {
      String operationInfo = "[name: " + info.name + ", desc: " + info.desc
        + "] - para o usurio: " + id;
      throw new DAOException("Falha em UserGroupIO.write", operationInfo);
    }
    return userGroup;
  }

  public List<UserGroup> readAllUserGroups() throws DAOException {
    try {
      return userGroupsRepository.readAll();
    }
    catch (IOException e) {
      throw new DAOException(e);
    }
  }

  public UserGroup readUserGroup(Object id) throws DAOException {
    try {
      return userGroupsRepository.read(id);
    }
    catch (IOException e) {
      throw new DAOException(e, "id: " + id);
    }
  }

}
