/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.restservice.websocket.notificationcenter;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.EvictingQueue;
import csbase.logic.CommandInfo;
import csbase.logic.CommandNotification;
import csbase.server.Server;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.restservice.websocket.CSBaseWebSocket;
import csbase.server.services.restservice.websocket.CSBaseWebSocketApplication;
import csbase.server.services.restservice.websocket.Message;
import csbase.server.services.restservice.websocket.utils.PersistentMap;
import csbase.server.services.restservice.websocket.utils.WebSocketUtils;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.filters.BodyTypeFilter;
import java.io.Serializable;
import org.glassfish.grizzly.websockets.WebSocket;
import org.json.JSONArray;
import org.json.JSONObject;
import tecgraf.javautils.core.filter.IFilter;

public class CSBaseNotificationCenter
extends CSBaseWebSocketApplication {
    private static final String NOTIFICATIONS_FILE = "wsnotifications.dat";
    private static final int NOTIFICATION_HISTORY_MAX_SIZE = 20;
    private PersistentMap<String, EvictingQueue<String>> notifications = new PersistentMap(WebSocketUtils.generatePath("wsnotifications.dat"));

    public CSBaseNotificationCenter() {
        this.setOnJobTerminateListener();
    }

    @Override
    public void onConnect(WebSocket socket) {
        super.onConnect(socket);
        if (socket instanceof CSBaseWebSocket) {
            CSBaseWebSocket ws = (CSBaseWebSocket)socket;
            this.notifications.putIfAbsent(ws.getUser().getLogin(), (EvictingQueue<String>)EvictingQueue.create((int)20));
            ws.send(this.createNotificationHistoryMessage(ws.getUser().getLogin()).toString());
        }
    }

    private void setOnJobTerminateListener() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MessageService.getInstance().setServerMessageListener((IMessageListener & Serializable)messages -> {
            for (csbase.util.messages.Message message : messages) {
                try {
                    Server.logInfoMessage("CommandNotification received in CSBaseNotificationCenter\n\t" + message.getBody().getClass().getSimpleName() + ": " + message.getBody());
                    if (!(message.getBody() instanceof CommandNotification)) continue;
                    CommandNotification commandNotification = (CommandNotification)message.getBody();
                    JSONObject content = new JSONObject(mapper.writeValueAsString((Object)commandNotification));
                    ProjectService ps = ProjectService.getInstance();
                    String project = ps.getProjectName(commandNotification.getProjectId());
                    content.put("project", (Object)project);
                    CommandInfo commandInfo = CommandPersistenceService.getInstance().getCommandInfo(commandNotification.getProjectId(), commandNotification.getCommandId().toString());
                    String user = commandInfo.getUserId().toString();
                    content.put("user", (Object)user);
                    Message commandTerminate = this.createCommandTerminateMessage(content);
                    this.connections.forEach((targetUser, targetUserWebSockets) -> {
                        if (targetUser.equals(user)) {
                            this.notifications.compute((String)targetUser, (savedUser, savedUserNotifications) -> {
                                savedUserNotifications.add((Object)content.toString());
                                return savedUserNotifications;
                            });
                            Server.logInfoMessage("Sending notification for user " + user + " " + targetUserWebSockets.size() + " connections");
                            this.broadcaster.broadcast((Iterable)targetUserWebSockets, commandTerminate.toString());
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Server.logSevereMessage("Error processing Message " + message + "\n\tMessage body: " + message.getBody(), e);
                }
            }
        }, (IFilter<csbase.util.messages.Message>)new BodyTypeFilter(CommandNotification.class));
    }

    private Message createCommandTerminateMessage(JSONObject content) throws JsonProcessingException {
        Message commandTerminate = new Message();
        commandTerminate.setType("cmdtmt");
        commandTerminate.setContent(content);
        return commandTerminate;
    }

    private Message createNotificationHistoryMessage(String user) {
        JSONArray jsonArray = new JSONArray();
        this.notifications.get(user).forEach(arg_0 -> ((JSONArray)jsonArray).put(arg_0));
        Message history = new Message();
        history.setType("nhist");
        history.setContent(jsonArray);
        return history;
    }
}

