package csbase.server.services.ftcservice;

import java.nio.channels.FileChannel;

import csbase.server.services.repositoryservice.IRepositoryFile;

/**
 * Define as operaes que o provedor de um arquivo deve implementar.
 */
public interface FTCRequester {
  /**
   * Solicita a criao de um java.util.FileChannel de acesso ao arquivo.
   *
   * @param file um arquivo de um repositrio a ser acessado.
   * @param readOnly indica se o acesso  somente leitura (true) ou se  de
   *        leitura e escrita (false).
   * @return um canal para acesso ao contedo do arquivo.
   * @throws Exception caso haja erro na operao.
   */
  public FileChannel createFileChannel(IRepositoryFile file, boolean readOnly)
    throws Exception;

  /**
   * Informa se o arquivo indicado est bloqueado para escrita.
   *
   * @param file um arquivo de um repositrio.
   * @return true se estiver bloqueado para escrita, ou false caso no esteja
   *         bloqueado.
   * @throws Exception caso haja erro na operao.
   */
  public boolean isLocked(IRepositoryFile file) throws Exception;

  /**
   * Informa que o canal para o arquivo indicado foi fechado.
   *
   * @param file um arquivo de um repositrio cujo canal foi fechado.
   * @throws Exception caso haja erro na operao.
   */
  public void fileChannelClosed(IRepositoryFile file) throws Exception;
}
