package csbase.server.services.projectservice.v1_00;

import java.util.Properties;

import tecgraf.openbus.data_service.DataDescriptionFactory;
import tecgraf.openbus.data_service.DataDescriptionHelper;
import tecgraf.openbus.data_service.IHierarchicalDataServiceHelper;
import tecgraf.openbus.data_service.UnstructuredDataFactory;
import tecgraf.openbus.data_service.UnstructuredDataHelper;
import tecgraf.openbus.data_service.project.ProjectItemDescriptionFactory;
import tecgraf.openbus.project.ProjectItemDescriptionHelper;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.openbusservice.OpenBusServiceFacet;
import csbase.server.services.openbusservice.OpenBusServiceOffer;

/**
 * Cria as ofertas das facetas para o DataService da verso 1.0
 * 
 * @author Tecgraf PUC-Rio
 */
public class DataServiceOffer implements OpenBusServiceOffer {

  @Override
  public OpenBusServiceFacet[] getFacets() {
    return new OpenBusServiceFacet[] { new OpenBusServiceFacet("dataservice",
      IHierarchicalDataServiceHelper.id(),
      new IHierarchicalDataServiceServant()) };
  }

  @Override
  public Properties getProperties() {
    return null;
  }

  @Override
  public void registerFactories() {
    org.omg.CORBA_2_3.ORB orb =
      (org.omg.CORBA_2_3.ORB) OpenBusService.getInstance().getORB();
    orb.register_value_factory(DataDescriptionHelper.id(),
      new DataDescriptionFactory());
    orb.register_value_factory(ProjectItemDescriptionHelper.id(),
      new ProjectItemDescriptionFactory());
    orb.register_value_factory(UnstructuredDataHelper.id(),
      new UnstructuredDataFactory());
  }
}
