/*
 * Decompiled with CFR 0.152.
 */
package csbase.server;

import csbase.exception.InitFailureException;
import csbase.logic.User;
import csbase.logic.diagnosticservice.DeploymentInfo;
import csbase.logic.diagnosticservice.PropertyInfo;
import csbase.remote.ServerEntryPoint;
import csbase.server.HierachicalResourceBundle;
import csbase.server.LocalServerRemoteMonitor;
import csbase.server.ServerEntryPointImpl;
import csbase.server.ServerException;
import csbase.server.ServerLogRecord;
import csbase.server.ServerSideProperties;
import csbase.server.Service;
import csbase.server.ServiceLogManager;
import csbase.server.ServiceManager;
import csbase.server.keystore.CSKeyStore;
import csbase.server.services.messageservice.MessageStoreDAO;
import csbase.util.messages.MessageBroker;
import csbase.util.messages.dao.IMessageStoreDAO;
import java.io.File;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.core.lng.LNG;

public abstract class Server {
    private static final String PROP_LOCALHOST_ALLOWED = "localhostAllowed";
    private static final String PROP_SERVER_DEFAULT_LOCALE = "DefaultLocale";
    private static final String PROP_LOCALE = "locale";
    private static final String PROP_HOST_NAME = "name";
    private static final String PROP_HOST_ADDR = "hostAddr";
    private static final String PROP_DEFAULT_CHARSET = "defaultCharset";
    private static final String ADMIN_PASSWORD = "aquaman";
    private static final String PROP_MIN_SUPPORTED_JVM_VERSION = "minimumJVMVersion";
    private static final String DEFAULT_LAGUANGE_FILE_NAME = "idiom";
    private static final String ADDITIONAL_LANGUAGE_FILE_PROPERTY = "additional.language.file";
    private static Server instance = null;
    protected Registry registry = null;
    private String serverPropertiesFilePath;
    private final Properties commandLineProperties;
    private final ServerSideProperties serverProperties;
    private final ServerSideProperties systemProperties;
    private final String systemName;
    private final String minJVMVersion;
    private final String privateKeyPassword;
    private final int registryPort;
    private final int rmiExportPort;
    private final String serverHostName;
    private ServerEntryPoint entryPoint;
    private final Locale defaultLocale;
    private final Map<Locale, HierachicalResourceBundle> bundles = new Hashtable<Locale, HierachicalResourceBundle>();
    private String systemFileName = null;
    private String serverHostAddr = null;
    private final Charset systemDefaultCharset;
    private final Charset serverHostCharset;
    private long startupTime;
    private MessageBroker messageBroker;

    public static void checkDirectory(String dirPath) throws ServerException {
        if (dirPath == null) {
            throw new IllegalArgumentException("dirPath == null");
        }
        File directory = new File(dirPath);
        if (!directory.exists()) {
            if (!directory.mkdirs()) {
                String err = "Erro ao criar diret\u00f3rio: " + dirPath + ".";
                throw new ServerException(err);
            }
        } else if (!directory.isDirectory()) {
            String err = "Diret\u00f3rio inv\u00e1lido: [" + dirPath + "].";
            throw new ServerException(err);
        }
    }

    private boolean checkRegistry() {
        try {
            this.registry.list();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private void createKeyStore() {
        String KS_PATH_PROPERTY = "keyStorePath";
        String KS_PASSWORD_PROPERTY = "keyStorePassword";
        boolean nullKeyStorePath = this.isPropertyNull("keyStorePath");
        if (nullKeyStorePath) {
            String fmt = "N\u00e3o foi encontrada a propriedade [%s].";
            String message = String.format("N\u00e3o foi encontrada a propriedade [%s].", "keyStorePath");
            Server.logInfoMessage(message);
        } else {
            String keyStorePath = this.getStringProperty("keyStorePath");
            boolean nullKeyStorePassword = this.isPropertyNull("keyStorePassword");
            if (nullKeyStorePassword) {
                String fmt = "N\u00e3o foi encontrada a propriedade [%s].";
                String message = String.format("N\u00e3o foi encontrada a propriedade [%s].", "keyStorePassword");
                Server.logWarningMessage(message);
                CSKeyStore.createInstance(keyStorePath);
            } else {
                String keyStorePassword = this.getStringProperty("keyStorePassword");
                CSKeyStore.createInstance(keyStorePath, keyStorePassword);
            }
        }
    }

    protected ServerEntryPoint createServerEntryPoint() {
        return new ServerEntryPointImpl();
    }

    public abstract void createServices() throws ServerException;

    public String getAdminPassword() {
        return ADMIN_PASSWORD;
    }

    public String getCentralServerName() {
        String propertyName = "centralServer";
        boolean isNull = this.isPropertyNull("centralServer");
        if (isNull) {
            return null;
        }
        String centralServerName = this.getStringProperty("centralServer");
        return centralServerName;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public final ServerEntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    protected String getGreetingMessage() {
        return "Servidor do " + this.getSystemName() + " iniciado em: " + FormatUtils.format((long)this.getStartupTime());
    }

    public String getHostName() {
        return this.serverHostName;
    }

    public String getHostAddr() {
        return this.serverHostAddr;
    }

    public final Charset getSystemDefaultCharset() {
        return this.systemDefaultCharset;
    }

    public final String getSystemDefaultCharsetName() {
        Charset ch = this.getSystemDefaultCharset();
        if (ch == null) {
            return null;
        }
        return ch.name();
    }

    public final Charset getServerHostCharset() {
        return this.serverHostCharset;
    }

    public final String getServerHostCharsetName() {
        if (this.serverHostCharset == null) {
            return null;
        }
        return this.serverHostCharset.name();
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    public int getRMIExportPort() {
        return this.rmiExportPort;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    private final String getRealPropertyKey(String key) {
        String realKey = "Server." + key;
        return realKey;
    }

    protected final boolean overridesServiceProperty(String prefixedKey) {
        boolean inServer = this.serverProperties.hasProperty(prefixedKey);
        boolean inSystem = this.systemProperties != null ? this.systemProperties.hasProperty(prefixedKey) : false;
        return inServer || inSystem;
    }

    private void checkPropertiesLoaded() {
        if (this.serverProperties == null) {
            String msg = "Falha interna de implementa\u00e7\u00e3o do servidor!\n\nPropriedades do servidor ainda n\u00e3o devidamente carregadas";
            throw new IllegalStateException("Falha interna de implementa\u00e7\u00e3o do servidor!\n\nPropriedades do servidor ainda n\u00e3o devidamente carregadas");
        }
    }

    protected final String getStringProperty(String key) {
        return this._propertyString(key, true);
    }

    final String getStringServiceProperty(String key) {
        return this._propertyString(key, false);
    }

    protected final double getDoubleProperty(String key) {
        return this._propertyDouble(key, true);
    }

    final double getDoubleServiceProperty(String key) {
        return this._propertyDouble(key, false);
    }

    private final double _propertyDouble(String key, boolean prefix) {
        String realKey;
        this.checkPropertiesLoaded();
        String string = realKey = prefix ? this.getRealPropertyKey(key) : key;
        if (this.systemProperties != null && this.systemProperties.hasProperty(realKey)) {
            return this.systemProperties.getDoubleProperty(realKey);
        }
        return this.serverProperties.getDoubleProperty(realKey);
    }

    private final String _propertyString(String key, boolean prefix) {
        String realKey;
        this.checkPropertiesLoaded();
        String string = realKey = prefix ? this.getRealPropertyKey(key) : key;
        if (this.systemProperties != null && this.systemProperties.hasProperty(realKey)) {
            return this.systemProperties.getStringProperty(realKey);
        }
        return this.serverProperties.getStringProperty(realKey);
    }

    private final List<String> _propertyStringList(String key, boolean prefix) {
        String realKey;
        this.checkPropertiesLoaded();
        String string = realKey = prefix ? this.getRealPropertyKey(key) : key;
        if (this.systemProperties != null && this.systemProperties.hasProperty(realKey.concat(".1"))) {
            return this.systemProperties.getStringListProperty(realKey);
        }
        return this.serverProperties.getStringListProperty(realKey);
    }

    private final int _propertyInt(String key, boolean prefix) {
        String realKey;
        this.checkPropertiesLoaded();
        String string = realKey = prefix ? this.getRealPropertyKey(key) : key;
        if (this.systemProperties != null && this.systemProperties.hasProperty(realKey)) {
            return this.systemProperties.getIntProperty(realKey);
        }
        return this.serverProperties.getIntProperty(realKey);
    }

    private final long _propertyLong(String key, boolean prefix) {
        String realKey;
        this.checkPropertiesLoaded();
        String string = realKey = prefix ? this.getRealPropertyKey(key) : key;
        if (this.systemProperties != null && this.systemProperties.hasProperty(realKey)) {
            return this.systemProperties.getLongProperty(realKey);
        }
        return this.serverProperties.getLongProperty(realKey);
    }

    private final boolean _propertyBool(String key, boolean prefix) {
        String realKey;
        this.checkPropertiesLoaded();
        String string = realKey = prefix ? this.getRealPropertyKey(key) : key;
        if (this.systemProperties != null && this.systemProperties.hasProperty(realKey)) {
            return this.systemProperties.getBooleanProperty(realKey);
        }
        return this.serverProperties.getBooleanProperty(realKey);
    }

    public final int getIntProperty(String key) {
        return this._propertyInt(key, true);
    }

    final int getIntServiceProperty(String key) {
        return this._propertyInt(key, false);
    }

    public final long getLongProperty(String key) {
        return this._propertyLong(key, true);
    }

    final long getLongServiceProperty(String key) {
        return this._propertyLong(key, false);
    }

    protected final boolean getBooleanProperty(String key) {
        return this._propertyBool(key, true);
    }

    final boolean getBooleanServiceProperty(String key) {
        return this._propertyBool(key, false);
    }

    protected final List<String> getStringListProperty(String key) {
        return this._propertyStringList(key, true);
    }

    final List<String> getStringListServiceProperty(String key) {
        return this._propertyStringList(key, false);
    }

    protected final boolean isPropertyNull(String key) {
        this.checkPropertiesLoaded();
        String realKey = this.getRealPropertyKey(key);
        if (this.systemProperties != null && this.systemProperties.hasProperty(realKey)) {
            return this.systemProperties.isPropertyNull(realKey);
        }
        return this.serverProperties.isPropertyNull(realKey);
    }

    private boolean getRegistry() {
        try {
            this.registry = LocateRegistry.getRegistry(this.registryPort);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.checkRegistry()) {
            try {
                this.registry = LocateRegistry.createRegistry(this.registryPort);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.checkRegistry();
    }

    public String getSystemName() {
        return this.systemName;
    }

    public abstract String getVersion();

    public String getSystemURL() {
        String propertyName = "systemURL";
        boolean isNull = this.isPropertyNull("systemURL");
        if (isNull) {
            return null;
        }
        String systemURL = this.getStringProperty("systemURL");
        return systemURL;
    }

    private void initLog() throws ServerException {
        System.out.println("Inicializando sistema de logs...");
        String logManagerClassName = ServiceLogManager.class.getName();
        System.out.println(" - LogManager: " + logManagerClassName);
        String loggingMgrKey = "java.util.logging.manager";
        System.setProperty("java.util.logging.manager", logManagerClassName);
        String logCnfKey = "logging.config.file";
        if (this.isPropertyNull("logging.config.file")) {
            String err = "Propriedade logging.config.file est\u00e1 nula no servidor!";
            throw new ServerException(err);
        }
        String logCnfFile = this.getStringProperty("logging.config.file");
        System.setProperty("java.util.logging.config.file", logCnfFile);
        System.out.println(" - Usando logging.config.file: " + logCnfFile);
        try {
            LogManager.getLogManager().reset();
            LogManager.getLogManager().readConfiguration();
        }
        catch (Exception e1) {
            throw new ServerException("N\u00e3o foi poss\u00edvel carregar o arquivo de configura\u00e7\u00e3o de logs definido em " + this.getRealPropertyKey("logging.config.file"), e1);
        }
        this.createFileHandlerLoggingDirectory();
    }

    private void createFileHandlerLoggingDirectory() throws ServerException {
        String filePattern = LogManager.getLogManager().getProperty("java.util.logging.FileHandler.pattern");
        if (filePattern == null) {
            return;
        }
        File fileParent = new File(filePattern).getParentFile();
        if (fileParent == null) {
            return;
        }
        System.out.println(" - Criando diret\u00f3rio definido em java.util.logging.FileHandler.pattern: " + filePattern);
        Server.checkDirectory(Server.generateDirectoryFileName(fileParent.getAbsolutePath()));
    }

    public static String generateDirectoryFileName(String pattern) {
        String file = null;
        String word = "";
        int pattIndex = 0;
        block9: while (pattIndex < pattern.length()) {
            char firstChar = pattern.charAt(pattIndex);
            ++pattIndex;
            switch (firstChar) {
                case '/': {
                    file = file == null ? word : file + File.separator + word;
                    word = "";
                    continue block9;
                }
                case '%': {
                    int secondChar = 0;
                    if (pattIndex < pattern.length()) {
                        secondChar = Character.toLowerCase(pattern.charAt(pattIndex));
                    }
                    switch (secondChar) {
                        case 116: {
                            String tmpDir = System.getProperty("java.io.tmpdir");
                            if (tmpDir == null) {
                                tmpDir = System.getProperty("user.home");
                            }
                            file = tmpDir;
                            ++pattIndex;
                            word = "";
                            continue block9;
                        }
                        case 104: {
                            file = System.getProperty("user.home");
                            ++pattIndex;
                            word = "";
                            continue block9;
                        }
                        case 37: {
                            word = word + "%";
                            ++pattIndex;
                            continue block9;
                        }
                    }
                }
            }
            word = word + firstChar;
        }
        if (word.length() > 0) {
            file = file == null ? word : file + File.separator + word;
        }
        return file;
    }

    public boolean isCentralServer() {
        String centralServerName = this.getCentralServerName();
        return centralServerName == null;
    }

    private Locale loadAndSetDefaultLocale() {
        Locale locale;
        String propertyName = PROP_SERVER_DEFAULT_LOCALE;
        boolean isNull = this.isPropertyNull(PROP_SERVER_DEFAULT_LOCALE);
        if (!isNull) {
            String localeStr = this.getStringProperty(PROP_SERVER_DEFAULT_LOCALE);
            locale = FormatUtils.parseLocale((String)localeStr);
        } else {
            locale = Locale.getDefault();
        }
        Server.logInfoMessage(this.getString("Server.defaultLocaleMessage", locale));
        return locale;
    }

    private boolean loadLanguageBundle(Locale locale) {
        ArrayList<String> languageFiles = new ArrayList<String>();
        languageFiles.add(DEFAULT_LAGUANGE_FILE_NAME);
        languageFiles.addAll(this.getStringListProperty(ADDITIONAL_LANGUAGE_FILE_PROPERTY));
        boolean hasBundlesForServer = false;
        HierachicalResourceBundle parent = null;
        for (String filePath : languageFiles) {
            String fileName = String.format("%s_%s.properties", filePath, locale);
            Class<?> thisClass = this.getClass();
            while (thisClass != null) {
                try {
                    InputStream in = thisClass.getResourceAsStream(fileName);
                    Throwable throwable = null;
                    try {
                        thisClass = thisClass.getSuperclass();
                        if (in == null) continue;
                        hasBundlesForServer = true;
                        HierachicalResourceBundle bundle = new HierachicalResourceBundle(in);
                        this.bundles.put(locale, bundle);
                        String logFormat = "Arquivo de bundle %s carregado.";
                        Server.logInfoMessage(String.format(logFormat, fileName));
                        if (parent != null) {
                            bundle.setParent(parent);
                        }
                        parent = bundle;
                    }
                    catch (Throwable bundle) {
                        throwable = bundle;
                        throw bundle;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (Exception e) {
                    String logFormat = "Falha na leitura de: %s --> %s";
                    String msg = e.getMessage();
                    Server.logSevereMessage(String.format(logFormat, filePath, msg));
                    logFormat = "Falha no bundle de: %s";
                    Server.logSevereMessage(String.format(logFormat, locale));
                    return hasBundlesForServer;
                }
            }
        }
        return hasBundlesForServer;
    }

    private ServerSideProperties loadAndSetServerProperties() throws ServerException {
        String propDirPath = Server.getPropertiesRootDirectoryName();
        Server.checkDirectory(propDirPath);
        String fileName = "Server.properties";
        String filePath = propDirPath + File.separator + "Server.properties";
        System.out.println("Carregando propriedades (servidor) de: " + filePath);
        ServerSideProperties props = new ServerSideProperties(filePath);
        props.load();
        System.out.println(" - Carga das propriedades terminada");
        this.serverPropertiesFilePath = filePath;
        return props;
    }

    private ServerSideProperties loadAndSetSystemProperties(Properties overprops) throws ServerException {
        ServerSideProperties props;
        if (this.systemFileName == null && overprops.isEmpty()) {
            System.out.println("Propriedades (sistema) n\u00e3o definidas! Usando configura\u00e7\u00e3o default...");
            return null;
        }
        if (this.systemFileName == null) {
            props = new ServerSideProperties();
        } else {
            props = new ServerSideProperties(this.systemFileName);
            System.out.println("Carregando propriedades (sistema) de: " + this.systemFileName);
            props.load();
            System.out.println(" - Carga das propriedades (sistema) terminada");
        }
        for (Object k : overprops.keySet()) {
            String key = (String)k;
            String value = overprops.getProperty(key);
            props.overrideProperty(key, value);
            System.out.println("Carregando propriedades (linha de comando): " + key + " = " + value);
        }
        System.out.println(" - Carga das propriedades (linha de comando) terminada");
        return props;
    }

    private String getStringPropertyOrNull(String propertyName) {
        if (this.isPropertyNull(propertyName)) {
            Server.logSevereMessage(String.format("A propriedade %s n\u00e3o foi definida.", propertyName));
            return null;
        }
        return this.getStringProperty(propertyName);
    }

    public String getString(String key) {
        return this.getString(key, this.getDefaultLocale());
    }

    public String getString(String key, Locale locale) {
        boolean loaded;
        if (key == null) {
            String f = "Chave nula em consulta \u00e0 internacionaliza\u00e7\u00e3o: %s";
            Server.logSevereMessage(String.format(f, key));
            return "<<<null-key>>>";
        }
        if (locale == null) {
            String f = "Locale nulo em consulta \u00e0 internacionaliza\u00e7\u00e3o da chave: %s";
            Server.logSevereMessage(String.format(f, key));
            return "<<<null-locale>>>";
        }
        if (!this.bundles.containsKey(locale) && !(loaded = this.loadLanguageBundle(locale))) {
            return null;
        }
        try {
            ResourceBundle bnd = this.bundles.get(locale);
            return bnd.getString(key);
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    HierachicalResourceBundle getBundle(Locale locale) {
        if (locale == null) {
            return null;
        }
        if (!this.bundles.containsKey(locale)) {
            this.loadLanguageBundle(locale);
        }
        return this.bundles.get(locale);
    }

    public String getFormattedString(String key, Object ... objects) {
        String txt = this.getString(key);
        return MessageFormat.format(txt, objects);
    }

    private int loadRegistryPort() {
        int port = this.getIntProperty("registryPort");
        String fmt = "Servidor utilizando registry RMI na porta %d";
        Server.logInfoMessage(String.format(fmt, port));
        return port;
    }

    private Charset loadHostCharset() {
        Charset charset = Charset.defaultCharset();
        return charset;
    }

    private void logOnNotRegisteredCharset(Charset charset) {
        boolean registered = charset.isRegistered();
        if (!registered) {
            String fmt = "Charset-enconding: [%s] n\u00e3o \u00e9 registrado IANA!";
            String chName = charset.name();
            String msg = String.format("Charset-enconding: [%s] n\u00e3o \u00e9 registrado IANA!", chName);
            Server.logWarningMessage(msg);
        }
    }

    private Charset loadDefaultCharset() throws ServerException {
        String chName = this.getStringProperty(PROP_DEFAULT_CHARSET);
        if (!Charset.isSupported(chName)) {
            String fmt = "Charset-enconding n\u00e3o suportado (prop. %s): [%s]";
            String msg = String.format("Charset-enconding n\u00e3o suportado (prop. %s): [%s]", PROP_DEFAULT_CHARSET, chName);
            throw new ServerException(msg);
        }
        Charset serverCharset = Charset.forName(chName);
        if (serverCharset == null) {
            String fmt = "Falha de defini\u00e7\u00e3o de charset-enconding: [%s]";
            String msg = String.format("Falha de defini\u00e7\u00e3o de charset-enconding: [%s]", chName);
            throw new ServerException(msg);
        }
        String fmt = "Servidor definido com charset-enconding: [%s]";
        String msg = String.format("Servidor definido com charset-enconding: [%s]", chName);
        Server.logInfoMessage(msg);
        this.logOnNotRegisteredCharset(serverCharset);
        return serverCharset;
    }

    private int loadRMIExportPort() {
        int port = this.getIntProperty("rmiExportPort");
        String fmt = "Servidor exportanto objetos RMI na porta %d";
        Server.logInfoMessage(String.format(fmt, port));
        return port;
    }

    private static LogRecord getLogRecord(Level level, String msg, Throwable t, StackTraceElement method) {
        ServerLogRecord record = new ServerLogRecord(level, msg, method);
        record.setThrown(t);
        record.setLoggerName(method.getClassName());
        record.setSourceClassName(method.getClassName());
        record.setSourceMethodName(method.getMethodName());
        return record;
    }

    private static void logMessage(Level level, String msg, Throwable t) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        StackTraceElement method = stack[3];
        Logger logger = Logger.getLogger(method.getClassName());
        logger.log(Server.getLogRecord(level, msg, t, method));
    }

    public static void logSevereMessage(String msg, Throwable t) {
        Server.logMessage(Level.SEVERE, msg, t);
    }

    public static void logSevereMessage(String msg) {
        Server.logMessage(Level.SEVERE, msg, null);
    }

    public static void logWarningMessage(String msg) {
        Server.logMessage(Level.WARNING, msg, null);
    }

    public static void logInfoMessage(String msg) {
        Server.logMessage(Level.INFO, msg, null);
    }

    public static void logFineMessage(String msg) {
        Server.logMessage(Level.FINE, msg, null);
    }

    private void setShutdownHook() {
        Thread t = new Thread(new Runnable(){

            @Override
            public synchronized void run() {
                try {
                    Server.this.stopServerHook();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(t);
    }

    public void shutdown() {
        Server.logSevereMessage("Shutdown do servidor acionado!");
        System.exit(0);
    }

    public boolean start() {
        try {
            Server.logInfoMessage("Vers\u00e3o do servidor: " + this.getVersion());
            if (!this.sanityCheck()) {
                return false;
            }
            if (!this.isCentralServer()) {
                this.startCentralServerMonitor();
            }
            this.startupTime = System.currentTimeMillis();
            this.startServices();
            this.startRMI();
            Server.logFineMessage("Servi\u00e7os locais ativos.");
            if (!this.isCentralServer()) {
                this.startCentralServerConnection();
            }
            Server.logFineMessage("Preparando p\u00f3s-inicializa\u00e7\u00e3o do servidor.");
            this.postInitialization();
            this.logProperties();
            Server.logInfoMessage("Servidor iniciado.");
            Server.logInfoMessage(this.listServerLibs());
            System.out.println(this.getGreetingMessage());
            System.out.println(this.getServerConfig());
            System.out.println(this.getServerJVMArgs());
            System.out.println(this.getVersion());
            if (!this.isJVMVersionSupported()) {
                Server.logSevereMessage("Vers\u00e3o " + DeploymentInfo.JAVA_VERSION + " da JVM n\u00e3o \u00e9 suportada. S\u00e3o suportas as JVMs do mesmo release com vers\u00e3o acima de " + this.minJVMVersion + ".");
                this.shutdown();
            }
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha no start-up do servidor", e);
            System.err.println("\n");
            System.err.println("[ERRO] - Falha no start-up do servidor!");
            System.err.println("       > " + e.getMessage());
            System.err.println("\n");
            return false;
        }
        return true;
    }

    private boolean sanityCheck() {
        boolean localhostAllowed = this.getBooleanProperty(PROP_LOCALHOST_ALLOWED);
        if (localhostAllowed) {
            return true;
        }
        if (this.serverHostName.startsWith("localhost")) {
            System.err.printf("[ERRO] Nome do servidor est\u00e1 como \"localhost\". Verifique a propriedade 'Server.%s' do servidor\n", PROP_LOCALHOST_ALLOWED);
            return false;
        }
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String localhostAddr = localHost.getHostAddress();
            if (localhostAddr.startsWith("127.0")) {
                System.err.printf("[ERRO] IP do servidor associado a localhost (%s). Verifique a propriedade 'Server.%s' do servidor\n", localhostAddr, PROP_LOCALHOST_ALLOWED);
                return false;
            }
            String hostAddr = this.getHostAddr();
            if (hostAddr.startsWith("127.0")) {
                System.err.printf("[ERRO] propriedade %s associada a localhost (%s).\nVerifique a propriedade 'Server.%s' do servidor.\n", PROP_HOST_ADDR, hostAddr, PROP_LOCALHOST_ALLOWED);
                return false;
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void logProperties() {
        Server.logInfoMessage('\n' + this.listRuntimeProperties());
    }

    public String listRuntimeProperties() {
        Collection<Service> services = Service.getServices().values();
        TreeSet<Object> allProps = new TreeSet<Object>(this.serverProperties.getPropertiesKeys());
        TreeSet<Object> overridenProps = new TreeSet<Object>();
        TreeSet<Object> newProps = new TreeSet<Object>();
        for (Service service : services) {
            allProps.addAll(service.getPropertiesKeys());
        }
        StringBuilder builder = new StringBuilder();
        if (this.systemProperties != null) {
            for (Object e : this.systemProperties.getPropertiesKeys()) {
                if (allProps.contains(e)) {
                    overridenProps.add(e);
                    allProps.remove(e);
                    continue;
                }
                newProps.add(e);
            }
            String string = "\nPropriedades REDEFINIDAS em " + this.systemFileName;
            this.buildPropsListOutput(builder, string, overridenProps, this.systemProperties);
            String string2 = "\nPropriedades APENAS em " + this.systemFileName;
            this.buildPropsListOutput(builder, string2, newProps, this.systemProperties);
        }
        builder.append("\nPropriedades com valores default:\n============================\n");
        for (Object e : allProps) {
            for (Service service : services) {
                String defaultValue = service.getDefaultPropertyValue((String)e);
                if (defaultValue == null) continue;
                builder.append(e);
                builder.append(" = ");
                builder.append(defaultValue);
                builder.append('\n');
            }
        }
        return builder.toString();
    }

    public Map<String, String> getRuntimeProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        Collection<Service> services = Service.getServices().values();
        for (Service service : services) {
            result.putAll(service.getPropertiesMap());
        }
        result.putAll(this.serverProperties.getPropertiesMap());
        if (this.systemProperties != null) {
            result.putAll(this.systemProperties.getPropertiesMap());
        }
        return result;
    }

    public Map<String, PropertyInfo> getPropertiesInfo() {
        Map<String, String> runtimeProperties = this.getRuntimeProperties();
        Hashtable<String, PropertyInfo> result = new Hashtable<String, PropertyInfo>();
        Collection<Service> services = Service.getServices().values();
        for (Service service : services) {
            SortedSet<Object> keys = service.getPropertiesKeys();
            for (Object e : keys) {
                String propertyKey = e.toString();
                Map<String, String> serviceProperties = service.getPropertiesMap();
                String serviceValue = serviceProperties.containsKey(propertyKey) ? serviceProperties.get(propertyKey) : null;
                String serverValue = this.serverProperties.hasProperty(propertyKey) ? this.serverProperties.getStringProperty(propertyKey) : null;
                String systemValue = this.systemProperties != null && this.systemProperties.hasProperty(propertyKey) ? this.systemProperties.getStringProperty(propertyKey) : null;
                String commandLineValue = this.commandLineProperties != null && this.commandLineProperties.containsKey(propertyKey) ? this.commandLineProperties.getProperty(propertyKey) : null;
                String runtimeValue = runtimeProperties.get(propertyKey);
                PropertyInfo info = new PropertyInfo(propertyKey, runtimeValue, serviceValue, serverValue, systemValue, commandLineValue);
                result.put(propertyKey, info);
            }
        }
        return result;
    }

    private void buildPropsListOutput(StringBuilder builder, String title, SortedSet<Object> propsKeys, ServerSideProperties props) {
        builder.append(title);
        builder.append("\n============================\n");
        for (Object e : propsKeys) {
            builder.append(e);
            builder.append(" = ");
            builder.append(props.getStringProperty((String)e));
            builder.append('\n');
        }
    }

    private boolean isJVMVersionSupported() {
        Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)_?(\\d+)?");
        Matcher curVersionMatcher = pattern.matcher(DeploymentInfo.JAVA_VERSION);
        Matcher minVersionMatcher = pattern.matcher(this.minJVMVersion);
        if (curVersionMatcher.matches() && minVersionMatcher.matches()) {
            int minInt;
            int minimumMinor;
            if (!curVersionMatcher.group(1).equals(minVersionMatcher.group(1))) {
                return false;
            }
            int currentMinor = Integer.parseInt(curVersionMatcher.group(2));
            if (currentMinor < (minimumMinor = Integer.parseInt(minVersionMatcher.group(2)))) {
                return false;
            }
            if (currentMinor > minimumMinor) {
                return true;
            }
            StringBuilder cur = new StringBuilder();
            for (int i = 3; i <= curVersionMatcher.groupCount(); ++i) {
                Integer num = 0;
                if (curVersionMatcher.group(i) != null) {
                    num = Integer.parseInt(curVersionMatcher.group(i));
                }
                cur.append(String.format("%02d", num));
            }
            StringBuilder min = new StringBuilder();
            for (int i = 3; i <= minVersionMatcher.groupCount(); ++i) {
                Integer num = 0;
                if (minVersionMatcher.group(i) != null) {
                    num = Integer.parseInt(minVersionMatcher.group(i));
                }
                min.append(String.format("%02d", num));
            }
            int curInt = Integer.parseInt(cur.toString());
            if (curInt < (minInt = Integer.parseInt(min.toString()))) {
                return false;
            }
        }
        return true;
    }

    protected String getServerConfig() {
        int regPort = this.getRegistryPort();
        int rmiExPort = this.getRMIExportPort();
        String rmiRegStr = String.format("%d", regPort);
        String rmiRegExp = String.format("%d", rmiExPort);
        String sysChText = "???";
        Charset sysCh = this.getSystemDefaultCharset();
        if (sysCh != null) {
            sysChText = this.getSystemDefaultCharsetName();
        }
        String hostChText = "???";
        String htChName = this.getServerHostCharsetName();
        if (htChName != null) {
            hostChText = htChName;
        }
        String[][] cnfInfos = new String[][]{{"Endere\u00e7o IP", this.getHostAddr()}, {"Nome", this.getHostName()}, {"RMI [registry]", rmiRegStr}, {"RMI [export]", rmiRegExp}, {"Charset [m\u00e1quina]", hostChText}, {"Charset [servidor/sistema]", sysChText}};
        String info = "";
        for (String[] cnfInfo : cnfInfos) {
            String label = cnfInfo[0];
            String value = cnfInfo[1];
            info = info + String.format("  -- %-30s: %s\n", label, value);
        }
        info = info + String.format("  -- %-30s: %s %s %s\n", "Sistema Operacional", DeploymentInfo.OS_NAME, DeploymentInfo.OS_ARCH, DeploymentInfo.OS_VERSION);
        info = info + String.format("  -- %-30s: %s %s (%s)\n", "Java", DeploymentInfo.JAVA_NAME, DeploymentInfo.JAVA_VERSION, DeploymentInfo.JAVA_VENDOR);
        return info;
    }

    private String listServerLibs() {
        String[] serverLibs;
        StringBuffer libsToShow = new StringBuffer("Bibliotecas carregadas:\n");
        for (String lib : serverLibs = this.getServerLibs()) {
            libsToShow.append(lib);
            libsToShow.append("\n");
        }
        return libsToShow.toString();
    }

    public String[] getServerLibs() {
        StringTokenizer st = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"));
        ArrayList<String> serverLibs = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.endsWith(".jar")) continue;
            int lIdx = token.lastIndexOf(System.getProperty("file.separator"));
            serverLibs.add(token.substring(lIdx + 1));
        }
        return serverLibs.toArray(new String[0]);
    }

    private String getServerJVMArgs() {
        String JVMArgs = "Argumentos da JVM:\n";
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String arg : arguments) {
            JVMArgs = JVMArgs + "  " + arg + "\n";
        }
        return JVMArgs;
    }

    private void startCentralServerConnection() {
        String centralServerName = this.getCentralServerName();
        if (centralServerName == null) {
            return;
        }
        LocalServerRemoteMonitor.getInstance().setSystemName(MessageFormat.format("Servidor local {0}", this.getSystemName()));
        Server.logInfoMessage("Iniciando conex\u00e3o ao servidor central: " + centralServerName);
        LocalServerRemoteMonitor.getInstance().start();
        Server.logInfoMessage("Conex\u00e3o ao servidor central conclu\u00edda.");
    }

    public abstract void startCentralServerMonitor();

    private void startRMI() throws ServerException {
        try {
            this.entryPoint = this.createServerEntryPoint();
            UnicastRemoteObject.exportObject((Remote)this.entryPoint, this.rmiExportPort);
            this.registry.rebind("Server", (Remote)this.entryPoint);
        }
        catch (Exception e) {
            throw new ServerException("Falha no export/bind.", e);
        }
    }

    private void startServices() throws ServerException {
        ServiceManager.init();
        this.createServices();
        try {
            Service.setUserId(User.getAdminId());
            ServiceManager.getInstance().initAllServices();
        }
        finally {
            Service.setUserId(null);
        }
    }

    private void stopServerHook() {
        System.out.println("Finalizando o servidor.");
        System.out.println("Acionado stop server hook!");
    }

    public static Server getInstance() {
        if (instance == null) {
            System.out.println("SERVIDOR N\u00c3O INSTANCIADO!");
        }
        return instance;
    }

    public String getPersistencyRootDirectoryName() {
        String dirName = this.getStringProperty("persistency.directory");
        return dirName;
    }

    public String getRunningDirectoryName() {
        String dirName = System.getProperty("user.dir");
        return dirName;
    }

    public static String getPropertiesRootDirectoryName() {
        return "properties";
    }

    protected Server(String[] args) throws ServerException {
        this.commandLineProperties = this.parseCommandLineArgs(args);
        try {
            if (instance != null) {
                String msg = this.getString("Server.argumentIgnoredserver");
                throw new ServerException(msg);
            }
            this.setShutdownHook();
            this.serverProperties = this.loadAndSetServerProperties();
            this.systemProperties = this.loadAndSetSystemProperties(this.commandLineProperties);
            this.initLog();
            String persistDirPath = this.getPersistencyRootDirectoryName();
            Server.checkDirectory(persistDirPath);
            this.serverHostCharset = this.loadHostCharset();
            this.systemDefaultCharset = this.loadDefaultCharset();
            this.defaultLocale = this.loadAndSetDefaultLocale();
            this.registryPort = this.loadRegistryPort();
            this.setupRegistry();
            this.rmiExportPort = this.loadRMIExportPort();
            this.serverHostName = this.loadAndSetServerHostName();
            this.serverHostAddr = this.getStringProperty(PROP_HOST_ADDR);
            this.systemName = this.getStringPropertyOrNull(PROP_HOST_NAME);
            this.minJVMVersion = this.getStringProperty(PROP_MIN_SUPPORTED_JVM_VERSION);
            System.setProperty("java.rmi.server.randomIDs", "true");
            this.createKeyStore();
            this.privateKeyPassword = this.loadAndSetPrivateKeyPassword();
            this.messageBroker = this.createMessageBroker();
            LNG.load((String)"csbase.exception.Resource.properties.language.idiom", (Locale)this.defaultLocale);
            LNG.load((String)"csbase.logic.resources.properties.language.idiom", (Locale)this.defaultLocale);
            LNG.load((String)"csbase.remote.resources.properties.language.idiom", (Locale)this.defaultLocale);
            instance = this;
        }
        catch (RuntimeException rte) {
            throw new ServerException(rte);
        }
    }

    private Properties parseCommandLineArgs(String[] args) {
        Properties props = new Properties();
        if (args == null) {
            return props;
        }
        int nargs = args.length;
        for (int i = 0; i < nargs; ++i) {
            String arg = args[i];
            if (arg.equals("-p")) {
                this.systemFileName = ++i < nargs ? args[i] : null;
                continue;
            }
            if (arg.equals("-override")) {
                String value;
                String key = ++i < nargs ? args[i++] : null;
                String string = value = i < nargs ? args[i] : null;
                if (key == null || value == null) continue;
                props.setProperty(key, value);
                continue;
            }
            if (props.containsKey(PROP_LOCALE)) {
                System.out.println(this.getString("Server.argumentIgnored") + arg + "...");
            }
            System.out.println("Ignorando argumento " + arg + "...");
        }
        return props;
    }

    private String loadAndSetPrivateKeyPassword() {
        String propertyName = "privateKeyPassword";
        boolean isNull = this.isPropertyNull("privateKeyPassword");
        if (isNull) {
            String fmt = this.getString("Server.keyNotFound");
            String message = String.format(fmt, "privateKeyPassword");
            Server.logWarningMessage(message);
            return null;
        }
        String pwd = this.getStringProperty("privateKeyPassword");
        return pwd;
    }

    private void setupRegistry() throws ServerException {
        if (!this.getRegistry()) {
            String err = this.getString("Server.RMIRegNotfound") + this.registryPort;
            Server.logSevereMessage(err);
            throw new ServerException(err);
        }
    }

    private String loadAndSetServerHostName() throws ServerException {
        String hostname;
        String propertyName = "hostName";
        boolean isNull = this.isPropertyNull("hostName");
        if (isNull) {
            String info = this.getString("Server.hostnameNotFound");
            Server.logInfoMessage(info);
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                hostname = localHost.getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                String msg = this.getString("Server.IPNotFound");
                Server.logSevereMessage(msg);
                throw new ServerException(msg, e);
            }
        } else {
            hostname = this.getStringProperty("hostName");
        }
        System.setProperty("java.rmi.server.hostname", hostname);
        Server.logInfoMessage("Propriedade hostname do servidor: " + hostname);
        return hostname;
    }

    public abstract void postInitialization() throws InitFailureException;

    public long getStartupTime() {
        return this.startupTime;
    }

    public MessageBroker getMessageBroker() {
        return this.messageBroker;
    }

    private MessageBroker createMessageBroker() {
        long size;
        File messagesBkpFile;
        long persistFileMaxSize = this.getLongProperty("message.persist.file.maxsize");
        long persistPeriod = TimeUnit.SECONDS.toMillis(this.getLongProperty("message.persist.period"));
        long receiveTimeout = TimeUnit.SECONDS.toMillis(this.getLongProperty("message.receive.timeout"));
        int maxThreads = this.getIntProperty("message.threads.max");
        String messageBkpFileName = "messages.dat";
        try {
            String pName = this.getPersistencyRootDirectoryName();
            String dName = pName + File.separator + "messages";
            Server.checkDirectory(dName);
            messagesBkpFile = new File(dName + File.separator + messageBkpFileName);
        }
        catch (Throwable t) {
            Server.logSevereMessage("Falha de aquisi\u00e7\u00e3o das mensagens persistidas.", t);
            messagesBkpFile = new File(messageBkpFileName);
        }
        if (messagesBkpFile.exists() && persistFileMaxSize < (size = messagesBkpFile.length() / 1024L / 1024L) && messagesBkpFile.delete()) {
            Server.logWarningMessage("Removendo arquivo de persist\u00eancia de mensagens por ser grande demais (" + size + "MB).");
        }
        MessageStoreDAO store = new MessageStoreDAO(messagesBkpFile);
        return new MessageBroker((IMessageStoreDAO)store, persistPeriod, receiveTimeout, maxThreads);
    }
}

