/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.diskusageservice;

import java.io.File;

class MonitoredDirectory {
    private final File directory;
    private final String id;

    public MonitoredDirectory(String id, String dirPath) {
        File dir = new File(dirPath);
        this.id = id;
        this.directory = dir;
    }

    final String getId() {
        return this.id;
    }

    final File getDirectory() {
        return this.directory;
    }

    final boolean isConsistent() {
        return !this.directory.exists() || this.directory.isDirectory();
    }

    final boolean isAvailable() {
        if (!this.directory.exists()) {
            return false;
        }
        return this.directory.canRead();
    }

    public String toString() {
        String fmt = "\u00c1rea de disco %s: %s";
        String path = this.directory.getAbsolutePath();
        String txt = String.format("\u00c1rea de disco %s: %s", this.id, path);
        return txt;
    }
}

