/**
 * $Id$
 */
package csbase.server.services.projectservice.v1_01;

import tecgraf.openbus.data_service.core.v1_01.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_01.DataDescription;
import tecgraf.openbus.data_service.core.v1_01.DataNotFound;
import tecgraf.openbus.data_service.core.v1_01.InvalidDataKey;
import tecgraf.openbus.data_service.core.v1_01.ServiceFailure;
import tecgraf.openbus.data_service.project.v1_01.IProjectNavigationDataServicePOA;
import tecgraf.openbus.data_service.project.v1_01.InvalidOwner;
import tecgraf.openbus.data_service.project.v1_01.ProjectDataView;
import tecgraf.openbus.data_service.project.v1_02.IProjectNavigationDataServiceOperations;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.projectservice.v1_02.DataValidation;

/**
 * 
 * 
 * @author Tecgraf
 */
public class IProjectNavigationDataServiceServant extends
  IProjectNavigationDataServicePOA {

  /**
   * {@inheritDoc}
   */
  @Override
  public ProjectDataView[] getProject(String fOwner) throws ServiceFailure,
    InvalidOwner {
    try {
      DataValidation.checkUser(OpenBusService.getInstance()
        .getRequesterUserId());
    }
    catch (tecgraf.openbus.data_service.core.v1_02.DataAccessDenied e) {
      throw new ServiceFailure("Usurio no cadastrado no CSBase");
    }
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IProjectNavigationDataServiceOperations service =
        csbase.server.services.projectservice.v1_02.ProjectDataService
          .getInstance();

      try {
        return DataBridge.convertProjectDataViewSeqToV1_01(service
          .getProject(fOwner));
      }
      catch (InvalidDataKey e) {
        throw new ServiceFailure(
          "Erro na converso de DataView para verso 1.2: InvalidDataKey");
      }
      catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
        throw new ServiceFailure(
          "Erro na converso de DataView para verso 1.2: " + e.fMessage);
      }
      catch (tecgraf.openbus.data_service.core.v1_02.ServiceFailure e) {
        throw new ServiceFailure(e.fMessage);
      }
      catch (tecgraf.openbus.data_service.project.v1_02.InvalidOwner e) {
        throw new InvalidOwner(e.fMessage);
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataAccessDenied e) {
        throw new ServiceFailure(e.fMessage);
      }
    }
    catch (RuntimeException e) {
      String msg = "Erro na chamada do mtodo getProject: " + e.getMessage();
      Server.logSevereMessage(msg, e);
      throw new ServiceFailure(msg);
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataDescription[] getChildren(byte[] fKey) throws ServiceFailure,
    DataNotFound, DataAccessDenied, InvalidDataKey {
    try {
      IProjectNavigationDataServiceOperations service =
        csbase.server.services.projectservice.v1_02.ProjectDataService
          .getInstance();

      try {
        DataValidation.checkUser(OpenBusService.getInstance()
          .getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());

        byte[] fKeyV1_02;

        try {
          fKeyV1_02 = DataBridge.convertDataKeyToV1_02(fKey);
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
          throw new ServiceFailure(e.fMessage);
        }

        DataDescription[] DataDescriptionV1_01 =
          DataBridge.convertDataDescriptionSeqToV1_01(service
            .getChildren(fKeyV1_02));

        return DataDescriptionV1_01;
      }
      catch (tecgraf.openbus.data_service.core.v1_02.ServiceFailure e) {
        throw new ServiceFailure(e.fMessage);
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataNotFound e) {
        try {
          throw new DataNotFound(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataAccessDenied e) {
        try {
          throw new DataAccessDenied(
            DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
        try {
          throw new InvalidDataKey(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
    }
    catch (RuntimeException e) {
      String msg = "Erro na chamada do mtodo getChildren: " + e.getMessage();
      Server.logSevereMessage(msg, e);
      throw new ServiceFailure(msg);
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataDescription getParent(byte[] fKey) throws ServiceFailure,
    DataNotFound, DataAccessDenied, InvalidDataKey {
    try {
      IProjectNavigationDataServiceOperations service =
        csbase.server.services.projectservice.v1_02.ProjectDataService
          .getInstance();
      try {
        DataValidation.checkUser(OpenBusService.getInstance()
          .getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());

        byte[] fKeyV1_02;

        try {
          fKeyV1_02 = DataBridge.convertDataKeyToV1_02(fKey);
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
          throw new ServiceFailure(e.fMessage);
        }

        DataDescription DataDescriptionV1_01 =
          DataBridge
            .convertDataDescriptionToV1_01(service.getParent(fKeyV1_02));

        return DataDescriptionV1_01;

      }
      catch (tecgraf.openbus.data_service.core.v1_02.ServiceFailure e) {
        throw new ServiceFailure(e.fMessage);
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataNotFound e) {
        try {
          throw new DataNotFound(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataAccessDenied e) {
        try {
          throw new DataAccessDenied(
            DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
      catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e) {
        try {
          throw new InvalidDataKey(DataBridge.convertDataKeySeqToV1_01(e.fKeys));
        }
        catch (tecgraf.openbus.data_service.core.v1_02.InvalidDataKey e1) {
          throw new ServiceFailure(e1.fMessage);
        }
      }
    }
    catch (RuntimeException e) {
      String msg = "Erro na chamada do mtodo getParent: " + e.getMessage();
      Server.logSevereMessage(msg, e);
      throw new ServiceFailure(msg);
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataDescription[] getRoots() throws ServiceFailure, DataAccessDenied {
    try {
      IProjectNavigationDataServiceOperations service =
        csbase.server.services.projectservice.v1_02.ProjectDataService
          .getInstance();

      try {
        DataValidation.checkUser(OpenBusService.getInstance()
          .getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());

        DataDescription[] DataDescriptionSeqV1_01 =
          DataBridge.convertDataDescriptionSeqToV1_01(service.getRoots());

        return DataDescriptionSeqV1_01;
      }
      catch (InvalidDataKey e) {
        throw new ServiceFailure(
          "Erro na converso de DataView para verso 1.2: InvalidDataKey");
      }
      catch (tecgraf.openbus.data_service.core.v1_02.ServiceFailure e) {
        throw new ServiceFailure(e.fMessage);
      }
      catch (tecgraf.openbus.data_service.core.v1_02.DataAccessDenied e) {
        throw new DataAccessDenied(e.fKeys);
      }
    }
    catch (RuntimeException e) {
      String msg = "Erro na chamada do mtodo getRoots: " + e.getMessage();
      Server.logSevereMessage(msg, e);
      throw new ServiceFailure(msg);
    }
    finally {
      Service.setUserId(null);
    }
  }
}
