/**
 * $Id: JobObserver.java 168371 2015-09-18 20:07:04Z fpina $
 */
package csbase.sga.executor;

/**
 * Observador de jobs. O {@link JobExecutor executor} notifica o trmino da
 * execuo de jobs atravs destes observadores.
 *
 * @author Tecgraf/PUC-Rio
 */
public interface JobObserver {

  /**
   * Callback de notificao de trmino de execuo de jobs.
   *
   * @param jobInfo as informaes sobre a execuo do job
   */
  public void onJobCompleted(JobInfo jobInfo);

  /**
   * Callback de notificao de perda de job. Jobs perdidos so aqueles que o
   * ambiente de execuo no consegue mais obter o estado.
   */
  public void onJobLost();

  /**
   * Callback de notificao de inicio de excuo de jobs.
   *
   * @param jobData o dado do job
   */
  public void onJobStarted(JobData jobData);

  /**
   * Callback de notificao de trmino forado do job.
   */
  public void onJobKilled();
}
