package csbase.sga.monitor;

import java.util.HashMap;
import java.util.Map;

import sgaidl.SGA_NODE_CLOCK_SPEED_MHZ;
import sgaidl.SGA_NODE_LOAD_AVG_15MIN_PERC;
import sgaidl.SGA_NODE_LOAD_AVG_1MIN_PERC;
import sgaidl.SGA_NODE_LOAD_AVG_5MIN_PERC;
import sgaidl.SGA_NODE_MEMORY_RAM_FREE_PERC;
import sgaidl.SGA_NODE_MEMORY_RAM_INFO_MB;
import sgaidl.SGA_NODE_MEMORY_SWAP_FREE_PERC;
import sgaidl.SGA_NODE_MEMORY_SWAP_INFO_MB;
import sgaidl.SGA_NODE_NAME;
import sgaidl.SGA_NODE_NUMBER_OF_JOBS;
import sgaidl.SGA_NODE_NUM_PROCESSORS;
import sgaidl.SGA_NODE_PLATFORM_ID;

public class NodeInfo {
  private String defaulValue = "-1";
  public Map<String, String> properties;

  NodeInfo(String name, String platform, String cpus, String speed,
    String ramMB, String swapMB, String freeRamPerc, String freeSwapPerc,
    String load1min, String load5min, String load15min, String jobs) {

    properties = new HashMap<>();
    properties.put(SGA_NODE_NAME.value, name);
    properties.put(SGA_NODE_PLATFORM_ID.value, platform);
    properties.put(
      SGA_NODE_NUM_PROCESSORS.value, cpus != null ? cpus.split("\\.")[0]
        : defaulValue);
    properties.put(
      SGA_NODE_MEMORY_RAM_INFO_MB.value, ramMB != null ? ramMB : defaulValue);
    properties.put(
      SGA_NODE_MEMORY_SWAP_INFO_MB.value, swapMB != null ? swapMB
        : defaulValue);
    properties.put(
      SGA_NODE_CLOCK_SPEED_MHZ.value, speed != null ? speed : defaulValue);
    properties.put(
      SGA_NODE_MEMORY_RAM_FREE_PERC.value, freeRamPerc != null ? freeRamPerc
        : defaulValue);
    properties.put(
      SGA_NODE_MEMORY_SWAP_FREE_PERC.value, freeSwapPerc != null ? freeSwapPerc
        : defaulValue);
    properties.put(
      SGA_NODE_LOAD_AVG_1MIN_PERC.value, load1min != null ? load1min
        : defaulValue);
    properties.put(
      SGA_NODE_LOAD_AVG_5MIN_PERC.value, load5min != null ? load5min
        : defaulValue);
    properties.put(
      SGA_NODE_LOAD_AVG_15MIN_PERC.value, load15min != null ? load15min
        : defaulValue);
    properties.put(
      SGA_NODE_NUMBER_OF_JOBS.value, jobs != null ? jobs : defaulValue);
  }

  //  N - Esttica
  //  SGA_NODE_NAME.value
  //  SGA_NODE_PLATFORM_ID.value
  //  SGA_NODE_NUM_PROCESSORS.value
  //  SGA_NODE_MEMORY_RAM_INFO_MB.value
  //  SGA_NODE_MEMORY_SWAP_INFO_MB.value
  //  SGA_NODE_CLOCK_SPEED_MHZ.value

  //  N - Dinmica
  //  SGA_NODE_MEMORY_RAM_FREE_PERC.value
  //  SGA_NODE_MEMORY_SWAP_FREE_PERC.value
  //  SGA_NODE_LOAD_AVG_1MIN_PERC.value
  //  SGA_NODE_LOAD_AVG_5MIN_PERC.value
  //  SGA_NODE_LOAD_AVG_15MIN_PERC.value
  //  SGA_NODE_NUMBER_OF_JOBS.value

}
