/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.rest;

import csbase.sga.rest.AbstractDaemon;
import csbase.sga.rest.SGARestCommand;
import csbase.sga.rest.messages.JobRequest;
import csbase.sga.rest.messages.JobResponse;
import csbase.sga.rest.messages.PathResponse;
import csbase.sga.rest.messages.parts.LostJob;
import csbase.sga.rest.messages.parts.PersistentData;
import csbase.sga.rest.messages.parts.RetrievedJob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.jackson.JacksonFeature;
import sgaidl.InvalidPathException;
import sgaidl.MissingParameterException;
import sgaidl.Pair;
import sgaidl.PathNotFoundException;
import sgaidl.SGACommand;
import sgaidl.SGAControlAction;
import sgaidl.SGAPath;
import sgaidl.SystemException;

public class SGARestDaemon
extends AbstractDaemon {
    private String name;
    private Map<String, String> actions;
    private Map<String, SGARestCommand> commands;
    private int heartbeatInterval;
    private Client client;

    public SGARestDaemon(String name, Map<String, String> actions) {
        this.name = name;
        this.actions = actions;
        this.commands = new HashMap<String, SGARestCommand>();
        this.logger = Logger.getLogger(this.getClass().getName() + "." + name);
        this.client = (Client)ClientBuilder.newClient().register(JacksonFeature.class);
    }

    public void setHeartbeatInterval(int seconds) {
        this.heartbeatInterval = seconds;
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    @Override
    public SGAPath getPath(String path) throws InvalidPathException, PathNotFoundException {
        String url = this.actions.get("path");
        if (url == null) {
            throw new InvalidPathException("Can't query paths");
        }
        this.logger.info("Will query path " + path + " via " + url);
        Response response = this.client.target(url).queryParam("name", new Object[]{path}).request(new String[]{"application/json"}).get();
        int code = response.getStatus();
        if (code == Response.Status.OK.getStatusCode()) {
            PathResponse pr = (PathResponse)response.readEntity(PathResponse.class);
            response.close();
            return new SGAPath(pr.path, (double)(pr.size_bytes / 1024), pr.is_dir, pr.is_symlink, pr.link_path, pr.is_readable, pr.is_writable, pr.is_executable, true);
        }
        if (code == Response.Status.NOT_FOUND.getStatusCode()) {
            response.close();
            throw new PathNotFoundException(path);
        }
        this.logger.severe("Error querying path " + path + ": " + code + " - " + (String)response.readEntity(String.class));
        response.close();
        throw new InvalidPathException(path);
    }

    private Map<String, String> pairsToMap(Pair[] pairs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Pair pair : pairs) {
            map.put(pair.key, pair.value);
        }
        return map;
    }

    private String pairsToString(Pair[] pairs) {
        StringBuilder sb = new StringBuilder();
        String sep = "{ ";
        for (Pair pair : pairs) {
            sb.append(sep);
            sb.append("\"" + pair.key + "\" = \"" + pair.value + "\"");
            sep = ", ";
        }
        sb.append(" }");
        return sb.toString();
    }

    public SGARestCommand createCommand(String commandId, Map<String, String> actions) {
        SGARestCommand cmd = new SGARestCommand(commandId, actions);
        this.commands.put(commandId, cmd);
        return cmd;
    }

    @Override
    public SGACommand executeCommand(String commandString, String commandId, Pair[] extraParams) throws SystemException, MissingParameterException {
        String url = this.actions.get("job");
        if (url == null) {
            throw new SystemException("Can't submit job");
        }
        this.logger.info("Will submit job: " + commandString + " id: " + commandId + " extraParams: " + this.pairsToString(extraParams) + " via " + url);
        Entity entity = Entity.entity((Object)new JobRequest(commandString, commandId, this.pairsToMap(extraParams)), (String)"application/json");
        this.logger.info("entity: " + entity);
        Response response = this.client.target(url).request(new String[]{"application/json"}).post(entity);
        Response.Status code = Response.Status.fromStatusCode((int)response.getStatus());
        if (code == Response.Status.CREATED) {
            JobResponse jr = (JobResponse)response.readEntity(JobResponse.class);
            SGARestCommand cmd = this.createCommand(commandId, jr.actions);
            response.close();
            return cmd;
        }
        if (code == Response.Status.BAD_REQUEST) {
            response.close();
            throw new MissingParameterException();
        }
        response.close();
        this.logger.severe("Error submitting command for execution.");
        throw new SystemException((String)response.readEntity(String.class));
    }

    public SGARestCommand removeCommand(String commandId) {
        return this.commands.remove(commandId);
    }

    SGARestCommand getCommand(String commandId) {
        return this.commands.get(commandId);
    }

    List<String> cleanupJobs(PersistentData persistentData) {
        ArrayList<String> lostJobs = new ArrayList<String>();
        TreeSet<String> alive = new TreeSet<String>();
        TreeSet<String> dead = new TreeSet<String>();
        for (RetrievedJob rjob : persistentData.retrieved) {
            alive.add(rjob.cmd_id);
        }
        for (String commandId : this.commands.keySet()) {
            if (alive.contains(commandId)) continue;
            lostJobs.add(commandId);
            this.commands.remove(commandId);
            dead.add(commandId);
        }
        for (LostJob ljob : persistentData.lost) {
            if (dead.contains(ljob.cmd_id)) continue;
            lostJobs.add(ljob.cmd_id);
        }
        return lostJobs;
    }

    @Override
    public void control(SGAControlAction sca) {
        try {
            String action;
            if (sca.equals(SGAControlAction.SHUTDOWN)) {
                action = "shutdown";
            } else if (sca.equals(SGAControlAction.RESTART)) {
                action = "restart";
            } else {
                throw new Exception("Unknown control action: " + sca);
            }
            String url = this.actions.get(action);
            if (url == null) {
                throw new Exception("SGA didn't tell us URI for: " + action);
            }
            this.logger.info("Sending SGA control action '" + action + "' via " + url);
            Response response = this.client.target(url).request().get();
            int code = response.getStatus();
            response.close();
            if (code != Response.Status.OK.getStatusCode()) {
                throw new Exception("SGA control action " + action + " response: " + code);
            }
            this.logger.info("SGA control action '" + action + "' response: " + code);
        }
        catch (Exception e) {
            this.logger.severe(e.getMessage());
        }
    }
}

