/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.rest;

import csbase.server.plugin.service.IServiceManager;
import csbase.server.plugin.service.sgaservice.SGADaemonException;
import csbase.sga.rest.AbstractDaemon;
import csbase.sga.rest.CSBaseFacade;
import csbase.sga.rest.RestServer;
import java.util.logging.Logger;

public class SGARestPlugin
extends AbstractDaemon {
    public static RestServer restServer;
    public static CSBaseFacade csbase;

    public SGARestPlugin(IServiceManager serviceManager) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.logger.info("SGARest plugin loaded.");
        if (csbase == null) {
            csbase = new CSBaseFacade(serviceManager);
        }
    }

    @Override
    public boolean start() throws SGADaemonException {
        if (restServer == null) {
            String host = this.pluginProperties.getProperty("host");
            String port = this.pluginProperties.getProperty("port");
            if (host == null) {
                host = "localhost";
                this.logger.warning("SGARest host set to '" + host + "' by default.");
            }
            int portNumber = 0;
            try {
                portNumber = Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                port = null;
            }
            if (port == null || portNumber < 1024 || portNumber > 65535) {
                portNumber = 40409;
                this.logger.warning("SGARest port set to " + portNumber + " by default.");
            }
            this.logger.info("Will start RestServer with host " + host + " port " + portNumber);
            restServer = RestServer.getInstance(host, portNumber);
            boolean ok = false;
            try {
                ok = restServer.start();
            }
            catch (Exception e) {
                this.logger.severe("Error starting restserver: " + e);
            }
            if (ok) {
                this.logger.info("SGARest server started.");
            } else {
                this.logger.info("SGARest server failed to start.");
            }
        }
        return true;
    }
}

