/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.configurabletable.UI;

import csbase.client.facilities.configurabletable.UI.ORIENTATION;
import csbase.client.facilities.configurabletable.UI.TabbedPane4Tables;
import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.model.AgeColumn;
import csbase.client.facilities.configurabletable.model.Community;
import csbase.client.facilities.configurabletable.model.CommunityNameColumn;
import csbase.client.facilities.configurabletable.model.NameColumn;
import csbase.client.facilities.configurabletable.model.NumberOfMembersColumn;
import csbase.client.facilities.configurabletable.model.Person;
import csbase.client.facilities.configurabletable.table.ConfigurableTable;
import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Test;
import tecgraf.javautils.core.filter.IFilter;

public class TabbedPane4TablesTest {
    @Test(expected=IllegalArgumentException.class)
    public void testConstrutor() {
        new TabbedPane4Tables(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddNullTable() {
        TabbedPane4Tables tabbed = new TabbedPane4Tables("id");
        tabbed.addTable("noTab", null, "label", Person.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddTableNullTabName() {
        TabbedPane4Tables tabbed = new TabbedPane4Tables("id");
        ConfigurableTable<?> table = this.getConfigurableTable4Community();
        tabbed.addTable(null, table, "label", Person.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddTableNullLabel() {
        TabbedPane4Tables tabbed = new TabbedPane4Tables("id");
        ConfigurableTable<?> table = this.getConfigurableTable4Community();
        tabbed.addTable("tab", table, "label", Person.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddTableNullDataType() {
        TabbedPane4Tables tabbed = new TabbedPane4Tables("id");
        ConfigurableTable<?> table = this.getConfigurableTable4Community();
        tabbed.addTable("tab", table, "label", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddTableNoTab() {
        TabbedPane4Tables tabbed = new TabbedPane4Tables("id");
        ConfigurableTable<?> table = this.getConfigurableTable4Community();
        tabbed.addTable("noTab", table, "label", Person.class);
    }

    @Test
    public void testAddTableSucess() {
        TabbedPane4Tables tabbed = new TabbedPane4Tables("id");
        tabbed.addTab("tab", ORIENTATION.horizontal);
        ConfigurableTable<?> table = this.getConfigurableTable4Community();
        tabbed.addTable("tab", table, "label", Person.class);
        Assert.assertNotNull((Object)tabbed.getTableById("community"));
    }

    @Test
    public void testGetTableByIdNull() {
        TabbedPane4Tables tabbed = new TabbedPane4Tables("id");
        tabbed.addTab("tab", ORIENTATION.horizontal);
        ConfigurableTable<?> table = this.getConfigurableTable4Community();
        tabbed.addTable("tab", table, "label", Person.class);
        Assert.assertNull((Object)tabbed.getTableById(null));
    }

    @Test
    public void testGetTableByIdInexist() {
        TabbedPane4Tables tabbed = new TabbedPane4Tables("id");
        tabbed.addTab("tab", ORIENTATION.horizontal);
        ConfigurableTable<?> table = this.getConfigurableTable4Community();
        tabbed.addTable("tab", table, "label", Person.class);
        Assert.assertNull((Object)tabbed.getTableById("notable"));
    }

    @Test
    public void testGetTableByIdSucess() {
        TabbedPane4Tables tabbed = new TabbedPane4Tables("id");
        tabbed.addTab("tab", ORIENTATION.horizontal);
        ConfigurableTable<?> table = this.getConfigurableTable4Community();
        tabbed.addTable("tab", table, "label", Person.class);
        Assert.assertNotNull((Object)tabbed.getTableById("community"));
    }

    @Test
    public void testGetTableByIdNullDataType() {
        TabbedPane4Tables tabbed = new TabbedPane4Tables("id");
        tabbed.addTab("tab", ORIENTATION.horizontal);
        ConfigurableTable<?> table = this.getConfigurableTable4Community();
        tabbed.addTable("tab", table, "label", Person.class);
        Assert.assertNull((Object)tabbed.getTableById("community", null));
    }

    @Test
    public void testGetTableByIdWrongDataType() {
        TabbedPane4Tables tabbed = new TabbedPane4Tables("id");
        tabbed.addTab("tab", ORIENTATION.horizontal);
        ConfigurableTable<?> table = this.getConfigurableTable4Community();
        tabbed.addTable("tab", table, "label", Community.class);
        Assert.assertNull((Object)tabbed.getTableById("community", Person.class));
    }

    @Test
    public void testGetTableById() {
        TabbedPane4Tables tabbed = new TabbedPane4Tables("id");
        tabbed.addTab("tab", ORIENTATION.horizontal);
        ConfigurableTable<?> table1 = this.getConfigurableTable4Community();
        tabbed.addTable("tab", table1, "label1", Community.class);
        ConfigurableTable<?> table2 = this.getConfigurableTable4Person();
        tabbed.addTable("tab", table2, "label2", Person.class);
        Assert.assertNotNull((Object)tabbed.getTableById("community", Community.class));
        Assert.assertNotNull((Object)tabbed.getTableById("person", Person.class));
    }

    @Test
    public void testGetTablesByTabNull() {
        TabbedPane4Tables tabbed = new TabbedPane4Tables("id");
        tabbed.addTab("tab", ORIENTATION.horizontal);
        ConfigurableTable<?> table1 = this.getConfigurableTable4Community();
        tabbed.addTable("tab", table1, "label1", Community.class);
        ConfigurableTable<?> table2 = this.getConfigurableTable4Person();
        tabbed.addTable("tab", table2, "label2", Person.class);
        Assert.assertNull((Object)tabbed.getTablesByTab(null));
    }

    @Test
    public void testGetTablesByTabInexist() {
        TabbedPane4Tables tabbed = new TabbedPane4Tables("id");
        tabbed.addTab("tab", ORIENTATION.horizontal);
        ConfigurableTable<?> table1 = this.getConfigurableTable4Community();
        tabbed.addTable("tab", table1, "label1", Community.class);
        ConfigurableTable<?> table2 = this.getConfigurableTable4Person();
        tabbed.addTable("tab", table2, "label2", Person.class);
        Assert.assertNull((Object)tabbed.getTablesByTab("inexist"));
    }

    @Test
    public void testGetTablesByTab() {
        TabbedPane4Tables tabbed = new TabbedPane4Tables("id");
        tabbed.addTab("tab1", ORIENTATION.horizontal);
        tabbed.addTab("tab2", ORIENTATION.horizontal);
        ConfigurableTable<?> table1 = this.getConfigurableTable4Community();
        tabbed.addTable("tab1", table1, "label1", Community.class);
        ConfigurableTable<?> table2 = this.getConfigurableTable4Person();
        tabbed.addTable("tab2", table2, "label2", Person.class);
        Assert.assertNotNull((Object)tabbed.getTablesByTab("tab1"));
        Assert.assertNotNull((Object)tabbed.getTablesByTab("tab2"));
        Assert.assertTrue((tabbed.getTablesByTab("tab1").size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((tabbed.getTablesByTab("tab2").size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((ConfigurableTable)tabbed.getTablesByTab("tab1").get(0)).getId().equals("community"));
        Assert.assertTrue((boolean)((ConfigurableTable)tabbed.getTablesByTab("tab2").get(0)).getId().equals("person"));
    }

    @Test
    public void testGetTablesByTabWithData() {
        TabbedPane4Tables tabbed = new TabbedPane4Tables("id");
        tabbed.addTab("tab1", ORIENTATION.horizontal);
        tabbed.addTab("tab2", ORIENTATION.horizontal);
        ConfigurableTable<?> table1 = this.getConfigurableTable4Community();
        tabbed.addTable("tab1", table1, "label1", Community.class);
        ConfigurableTable<?> table2 = this.getConfigurableTable4Person();
        tabbed.addTable("tab2", table2, "label2", Person.class);
        Assert.assertTrue((tabbed.getTablesByTab("tab1", null).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((tabbed.getTablesByTab("tab1", Person.class).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((tabbed.getTablesByTab("tab1", Community.class).size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetAllTables() {
        TabbedPane4Tables tabbed = new TabbedPane4Tables("id");
        tabbed.addTab("tab1", ORIENTATION.horizontal);
        tabbed.addTab("tab2", ORIENTATION.horizontal);
        ConfigurableTable<?> table1 = this.getConfigurableTable4Community();
        tabbed.addTable("tab1", table1, "label1", Community.class);
        ConfigurableTable<?> table2 = this.getConfigurableTable4Person();
        tabbed.addTable("tab2", table2, "label2", Person.class);
        Assert.assertTrue((tabbed.getAllTables().size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testGetAllTablesWithDataType() {
        TabbedPane4Tables tabbed = new TabbedPane4Tables("id");
        tabbed.addTab("tab1", ORIENTATION.horizontal);
        tabbed.addTab("tab2", ORIENTATION.horizontal);
        ConfigurableTable<?> table1 = this.getConfigurableTable4Community();
        tabbed.addTable("tab1", table1, "label1", Community.class);
        ConfigurableTable<?> table2 = this.getConfigurableTable4Person();
        tabbed.addTable("tab2", table2, "label2", Person.class);
        Assert.assertTrue((tabbed.getAllTables(null).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((tabbed.getAllTables(Community.class).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((tabbed.getAllTables(Person.class).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((tabbed.getAllTables(String.class).size() == 0 ? 1 : 0) != 0);
    }

    private ConfigurableTable<?> getConfigurableTable4Person() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        IFilter<Person> filter = new IFilter<Person>(){

            public boolean accept(Person t) {
                return t.getAge() > 50;
            }
        };
        ConfigurableTable table = new ConfigurableTable("person", columns, (IFilter)filter);
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Silvio Berlusconi", 75));
        people.add(new Person("Fulano1", 30));
        table.updateRows(people);
        return table;
    }

    private ConfigurableTable<?> getConfigurableTable4Community() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new CommunityNameColumn("name", true, null, 0));
        columns.add(new NumberOfMembersColumn("number", true, null, 0));
        ConfigurableTable table = new ConfigurableTable("community", columns, null);
        ArrayList<Community> communities = new ArrayList<Community>();
        communities.add(new Community("CommunityA", new ArrayList<Person>()));
        communities.add(new Community("CommunityB", new ArrayList<Person>()));
        table.updateRows(communities);
        return table;
    }
}

