/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.DoubleColumn;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.TestCase;

public final class DoubleColumnTest
extends TestCase {
    public void testDoubleColumn1() {
        String id = "Identificador da coluna";
        String label = "Nome do par\u00e2metro";
        boolean isEditable = true;
        boolean isOptional = true;
        Double maximum = new Double(10.1);
        boolean includeMaximum = true;
        Double minimum = new Double(1.1);
        boolean includeMinimum = true;
        Double defaultValue = new Double(123.456);
        DoubleColumn column = new DoubleColumn(id, label, defaultValue, isOptional, isEditable, maximum, includeMaximum, minimum, includeMinimum);
        DoubleColumnTest.assertEquals((String)id, (String)column.getId());
        DoubleColumnTest.assertEquals((String)label, (String)column.getLabel());
        DoubleColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue(0));
        DoubleColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        DoubleColumnTest.assertEquals((boolean)isEditable, (boolean)column.isOptional());
        DoubleColumnTest.assertEquals((Object)maximum, (Object)column.getMaximum());
        DoubleColumnTest.assertEquals((boolean)includeMaximum, (boolean)column.isMaximumIncluded());
        DoubleColumnTest.assertEquals((Object)minimum, (Object)column.getMinimum());
        DoubleColumnTest.assertEquals((boolean)includeMinimum, (boolean)column.isMinimumIncluded());
    }

    public void testDoubleColumn2() {
        String id = "Identificador da coluna";
        String label = "Nome do par\u00e2metro";
        boolean isEditable = true;
        boolean isOptional = false;
        Double maximum = new Double(10.1);
        boolean includeMaximum = true;
        Double minimum = new Double(1.1);
        boolean includeMinimum = true;
        Double defaultValue = new Double(1234.45679);
        DoubleColumn column = new DoubleColumn(id, label, defaultValue, isOptional, isEditable, maximum, includeMaximum, minimum, includeMinimum);
        DoubleColumnTest.assertEquals((String)id, (String)column.getId());
        DoubleColumnTest.assertEquals((String)label, (String)column.getLabel());
        DoubleColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        DoubleColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        DoubleColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue(0));
        DoubleColumnTest.assertEquals((Object)maximum, (Object)column.getMaximum());
        DoubleColumnTest.assertEquals((boolean)includeMaximum, (boolean)column.isMaximumIncluded());
        DoubleColumnTest.assertEquals((Object)minimum, (Object)column.getMinimum());
        DoubleColumnTest.assertEquals((boolean)includeMinimum, (boolean)column.isMinimumIncluded());
    }

    public void testDoubleColumn3() {
        String id = "Identificador do par\u00e2metro";
        String label = "Nome do par\u00e2metro";
        boolean isOptional = true;
        boolean isEditable = true;
        Double maximum = new Double(10.1);
        boolean includeMaximum = true;
        Double minimum = new Double(1.1);
        boolean includeMinimum = true;
        Double defaultValue = null;
        DoubleColumn column = new DoubleColumn(id, label, defaultValue, isOptional, isEditable, maximum, includeMaximum, minimum, includeMinimum);
        DoubleColumnTest.assertEquals((String)id, (String)column.getId());
        DoubleColumnTest.assertEquals((String)label, (String)column.getLabel());
        DoubleColumnTest.assertEquals(defaultValue, (Object)column.getDefaultValue(0));
        DoubleColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        DoubleColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        DoubleColumnTest.assertEquals((Object)maximum, (Object)column.getMaximum());
        DoubleColumnTest.assertEquals((boolean)includeMaximum, (boolean)column.isMaximumIncluded());
        DoubleColumnTest.assertEquals((Object)minimum, (Object)column.getMinimum());
        DoubleColumnTest.assertEquals((boolean)includeMinimum, (boolean)column.isMinimumIncluded());
    }

    public void testDoubleColumn4() {
        String id = "Identificador do par\u00e2metro";
        String label = "Nome do par\u00e2metro";
        boolean isEditable = true;
        boolean isOptional = true;
        Double maximum = new Double(10.1);
        boolean includeMaximum = false;
        Double minimum = new Double(1.1);
        boolean includeMinimum = true;
        Double defaultValue = new Double(1234.45679);
        DoubleColumn column = new DoubleColumn(id, label, defaultValue, isOptional, isEditable, maximum, includeMaximum, minimum, includeMinimum);
        DoubleColumnTest.assertEquals((String)id, (String)column.getId());
        DoubleColumnTest.assertEquals((String)label, (String)column.getLabel());
        DoubleColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue(0));
        DoubleColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        DoubleColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        DoubleColumnTest.assertEquals((Object)maximum, (Object)column.getMaximum());
        DoubleColumnTest.assertEquals((boolean)includeMaximum, (boolean)column.isMaximumIncluded());
        DoubleColumnTest.assertEquals((Object)minimum, (Object)column.getMinimum());
        DoubleColumnTest.assertEquals((boolean)includeMinimum, (boolean)column.isMinimumIncluded());
        DoubleColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
    }

    public void testDoubleColumn5() {
        String id = "Identificador do par\u00e2metro";
        String label = "Nome do par\u00e2metro";
        boolean isEditable = true;
        boolean isOptional = true;
        Double maximum = new Double(10.1);
        boolean includeMaximum = true;
        Double minimum = new Double(1.1);
        boolean includeMinimum = false;
        Double defaultValue = new Double(1234.56789);
        DoubleColumn column = new DoubleColumn(id, label, defaultValue, isOptional, isEditable, maximum, includeMaximum, minimum, includeMinimum);
        DoubleColumnTest.assertEquals((String)id, (String)column.getId());
        DoubleColumnTest.assertEquals((String)label, (String)column.getLabel());
        DoubleColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        DoubleColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue(0));
        DoubleColumnTest.assertEquals((Object)maximum, (Object)column.getMaximum());
        DoubleColumnTest.assertEquals((boolean)includeMaximum, (boolean)column.isMaximumIncluded());
        DoubleColumnTest.assertEquals((Object)minimum, (Object)column.getMinimum());
        DoubleColumnTest.assertEquals((boolean)includeMinimum, (boolean)column.isMinimumIncluded());
        DoubleColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
    }

    public void testDoubleColumn6() {
        String id = "Identificador do par\u00e2metro";
        String label = "Nome do par\u00e2metro";
        boolean isOptional = true;
        boolean isEditable = true;
        boolean includeMaximum = true;
        Double minimum = new Double(1.1);
        boolean includeMinimum = true;
        Double defaultValue = new Double(1234.56789);
        DoubleColumn column = new DoubleColumn(id, label, defaultValue, isOptional, isEditable, null, includeMaximum, minimum, includeMinimum);
        DoubleColumnTest.assertEquals((String)id, (String)column.getId());
        DoubleColumnTest.assertEquals((String)label, (String)column.getLabel());
        DoubleColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue(0));
        DoubleColumnTest.assertNull((Object)column.getMaximum());
        DoubleColumnTest.assertFalse((boolean)column.isMaximumIncluded());
        DoubleColumnTest.assertEquals((Object)minimum, (Object)column.getMinimum());
        DoubleColumnTest.assertEquals((boolean)includeMinimum, (boolean)column.isMinimumIncluded());
        DoubleColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
    }

    public void testDoubleColumn7() {
        String id = "Identificador da coluna";
        String label = "Nome do par\u00e2metro";
        boolean isOptional = true;
        boolean isEditable = true;
        Double maximum = new Double(10.1);
        boolean includeMaximum = true;
        boolean includeMinimum = true;
        Double defaultValue = new Double(1234.0);
        DoubleColumn column = new DoubleColumn(id, label, defaultValue, isOptional, isEditable, maximum, includeMaximum, null, includeMinimum);
        DoubleColumnTest.assertEquals((String)id, (String)column.getId());
        DoubleColumnTest.assertEquals((String)label, (String)column.getLabel());
        DoubleColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue(0));
        DoubleColumnTest.assertEquals((Object)maximum, (Object)column.getMaximum());
        DoubleColumnTest.assertEquals((boolean)includeMaximum, (boolean)column.isMaximumIncluded());
        DoubleColumnTest.assertNull((Object)column.getMinimum());
        DoubleColumnTest.assertFalse((boolean)column.isMinimumIncluded());
        DoubleColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
    }

    public void testDoubleColumn8() {
        String id = "Identificador do par\u00e2metro";
        String label = "Nome do par\u00e2metro";
        Double defaultValue = new Double(1234.56789);
        boolean isEditable = true;
        boolean isOptional = true;
        Double maximum = new Double(1.1);
        boolean includeMaximum = false;
        Double minimum = new Double(10.01);
        boolean includeMinimum = true;
        try {
            new DoubleColumn(id, label, defaultValue, isOptional, isEditable, maximum, includeMaximum, minimum, includeMinimum);
            DoubleColumnTest.fail((String)"N\u00e3o deveria ser poss\u00edvel criar um par\u00e2metro real com min\u00edmo maior do que o m\u00e1ximo.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testDoubleColumn9() {
        String id = "Identificador do par\u00e2metro";
        Double defaultValue = new Double(1234.56789);
        boolean isOptional = true;
        boolean isEditable = true;
        Double maximum = new Double(1.1);
        boolean includeMaximum = false;
        Double minimum = new Double(10.01);
        boolean includeMinimum = true;
        try {
            new DoubleColumn(id, null, defaultValue, isOptional, isEditable, maximum, includeMaximum, minimum, includeMinimum);
            DoubleColumnTest.fail((String)"N\u00e3o deveria ser poss\u00edvel criar um par\u00e2metro real sem um nome.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testDoubleColumn10() {
        String id = "Identificador do par\u00e2metro";
        String label = "Nome do par\u00e2metro";
        boolean isEditable = false;
        boolean isOptional = true;
        Double maximum = new Double(10.1);
        boolean includeMaximum = true;
        Double minimum = new Double(1.1);
        boolean includeMinimum = true;
        Double defaultValue = new Double(123.456);
        DoubleColumn column = new DoubleColumn(id, label, defaultValue, isOptional, isEditable, maximum, includeMaximum, minimum, includeMinimum);
        DoubleColumnTest.assertEquals((String)id, (String)column.getId());
        DoubleColumnTest.assertEquals((String)label, (String)column.getLabel());
        DoubleColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue(0));
        DoubleColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        DoubleColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        DoubleColumnTest.assertEquals((Object)maximum, (Object)column.getMaximum());
        DoubleColumnTest.assertEquals((boolean)includeMaximum, (boolean)column.isMaximumIncluded());
        DoubleColumnTest.assertEquals((Object)minimum, (Object)column.getMinimum());
        DoubleColumnTest.assertEquals((boolean)includeMinimum, (boolean)column.isMinimumIncluded());
    }

    public void testDoubleColumn11() {
        String label = "R\u00f3tulo do par\u00e2metro";
        Double defaultValue = new Double(1234.56789);
        boolean isOptional = true;
        boolean isEditable = true;
        Double maximum = new Double(1.1);
        boolean includeMaximum = false;
        Double minimum = new Double(10.01);
        boolean includeMinimum = true;
        try {
            new DoubleColumn(null, label, defaultValue, isOptional, isEditable, maximum, includeMaximum, minimum, includeMinimum);
            DoubleColumnTest.fail((String)"N\u00e3o deveria ser poss\u00edvel criar um par\u00e2metro real sem um identificador.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testSerialize() throws IOException, ClassNotFoundException {
        String id = "Identificador do par\u00e2metro";
        String label = "Nome do par\u00e2metro";
        boolean isOptional = true;
        boolean isEditable = true;
        Double maximum = new Double(10.1);
        boolean includeMaximum = true;
        Double minimum = new Double(1.1);
        boolean includeMinimum = true;
        Double defaultValue = new Double(1234.56789);
        DoubleColumn outputColumn = new DoubleColumn(id, label, defaultValue, isOptional, isEditable, maximum, includeMaximum, minimum, includeMinimum);
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject(outputColumn);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        DoubleColumn inputColumn = (DoubleColumn)objectInput.readObject();
        DoubleColumnTest.assertEquals((String)outputColumn.getId(), (String)inputColumn.getId());
        DoubleColumnTest.assertEquals((String)outputColumn.getLabel(), (String)inputColumn.getLabel());
        DoubleColumnTest.assertEquals((Object)outputColumn.getDefaultValue(0), (Object)inputColumn.getDefaultValue(0));
        DoubleColumnTest.assertEquals((boolean)outputColumn.isOptional(), (boolean)inputColumn.isOptional());
        DoubleColumnTest.assertEquals((boolean)outputColumn.isEditable(), (boolean)inputColumn.isEditable());
        DoubleColumnTest.assertEquals((Object)outputColumn.getMaximum(), (Object)inputColumn.getMaximum());
        DoubleColumnTest.assertEquals((boolean)outputColumn.isMaximumIncluded(), (boolean)inputColumn.isMaximumIncluded());
        DoubleColumnTest.assertEquals((Object)outputColumn.getMinimum(), (Object)inputColumn.getMinimum());
        DoubleColumnTest.assertEquals((boolean)outputColumn.isMinimumIncluded(), (boolean)inputColumn.isMinimumIncluded());
    }
}

