/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.EnumerationItem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.TestCase;

public final class EnumerationItemTest
extends TestCase {
    public void testEnumerationItem() {
        String id = "item 1";
        String label = "Enumeration's item's label";
        String value = "Enumeration's item's value";
        String description = "Description";
        EnumerationItem item = new EnumerationItem(id, label, value, description);
        EnumerationItemTest.assertEquals((String)id, (String)item.getId());
        EnumerationItemTest.assertNotNull((Object)item.getLabel());
        EnumerationItemTest.assertEquals((String)label, (String)item.getLabel());
        EnumerationItemTest.assertNotNull((Object)item.getValue());
        EnumerationItemTest.assertEquals((String)value, (String)item.getValue());
        EnumerationItemTest.assertEquals((String)description, (String)item.getDescription());
    }

    public void testEnumerationItemWithNullDescription() {
        String id = "item 1";
        String label = "Enumeration's item's label";
        String value = "Enumeration's item's value";
        String description = null;
        EnumerationItem item = new EnumerationItem(id, label, value, description);
        EnumerationItemTest.assertEquals((String)id, (String)item.getId());
        EnumerationItemTest.assertNotNull((Object)item.getLabel());
        EnumerationItemTest.assertEquals((String)label, (String)item.getLabel());
        EnumerationItemTest.assertNotNull((Object)item.getValue());
        EnumerationItemTest.assertEquals((String)value, (String)item.getValue());
        EnumerationItemTest.assertEquals(description, (String)item.getDescription());
    }

    public void testEnumerationItemWithIdNull() {
        String id = null;
        String value = "Enumeration's item's value";
        String description = "Description";
        try {
            new EnumerationItem(id, null, value, description);
            EnumerationItemTest.fail((String)"Todo item de enumera\u00e7\u00e3o tem que ter um nome.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testEnumerationItemWithNameNull() {
        String id = "item 1";
        String value = "Enumeration's item's value";
        String description = "Description";
        try {
            new EnumerationItem(id, null, value, description);
            EnumerationItemTest.fail((String)"Todo item de enumera\u00e7\u00e3o tem que ter um nome.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testEnumerationItemWithValueNull() {
        String id = "item 1";
        String label = "Enumeration's item's label";
        try {
            new EnumerationItem(id, label, null, null);
            EnumerationItemTest.fail((String)"Todo item de enumera\u00e7\u00e3o tem que ter um valor.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEqualsObjectAllEquals() {
        String id = "item 1";
        String label = "Enumeration's item's label";
        String value = "Enumeration's item's value";
        String description = "Description";
        EnumerationItem item = new EnumerationItem(id, label, value, description);
        EnumerationItem allEqualsItem = new EnumerationItem(id, label, value, description);
        EnumerationItemTest.assertEquals((Object)item, (Object)allEqualsItem);
    }

    public void testEqualsObjectDifferentId() {
        String id1 = "1";
        String label = "Enumeration's item's label";
        String value = "Enumeration's item's value";
        String description = "Description";
        EnumerationItem item = new EnumerationItem(id1, label, value, description);
        String id2 = "2";
        EnumerationItem differentNameItem = new EnumerationItem(id2, label, value, description);
        EnumerationItemTest.assertFalse((String)"Itens de enumera\u00e7\u00e3o com nomes diferentes s\u00e3o diferentes.", (boolean)item.equals((Object)differentNameItem));
    }

    public void testEqualsObjectDifferentValues() {
        String id = "item 1";
        String label = "Enumeration's item's label";
        String value = "Enumeration's item's value";
        String description = "Description";
        EnumerationItem item = new EnumerationItem(id, label, value, description);
        String anotherLabel = "Another enumeration's item's label";
        String anotherValue = "Another enumeration's item's value";
        String anotherDescription = "Another description";
        EnumerationItem differentValueItem = new EnumerationItem(id, anotherLabel, anotherValue, anotherDescription);
        EnumerationItemTest.assertEquals((Object)item, (Object)differentValueItem);
    }

    public void testEqualsObjectWithObjectNull() {
        String id = "item 1";
        String label = "Enumeration's item's label";
        String value = "Enumeration's item's value";
        String description = "Description";
        EnumerationItem item = new EnumerationItem(id, label, value, description);
        EnumerationItemTest.assertFalse((String)"O item de enumeracao n\u00e3o pode ser igual a null.", (boolean)item.equals(null));
    }

    public void testEqualsObjectWithObjectAnotherClass() {
        String id = "item 1";
        String label = "Enumeration's item's label";
        String value = "Enumeration's item's value";
        String description = "Description";
        EnumerationItem item = new EnumerationItem(id, label, value, description);
        String anotherClassObject = "Another class object";
        EnumerationItemTest.assertFalse((String)"O item de enumeracao n\u00e3o pode ser igual a um objeto de outra classe.", (boolean)item.equals((Object)anotherClassObject));
    }

    public void testHashCode() {
        String id = "item 1";
        String label = "Enumeration's item's label";
        String value = "Enumeration's item's value";
        String description = "Description";
        EnumerationItem item = new EnumerationItem(id, label, value, description);
        String anotherLabel = "Another enumeration's item's label";
        String anotherValue = "Another enumeration's item's value";
        String anotherDescription = "Another description";
        EnumerationItem equalsItem = new EnumerationItem(id, anotherLabel, anotherValue, anotherDescription);
        EnumerationItemTest.assertEquals((int)item.hashCode(), (int)equalsItem.hashCode());
    }

    public void testToString() {
        String id = "item 1";
        String label = "Enumeration's item's label";
        String value = "Enumeration's item's value";
        String description = "Description";
        EnumerationItem item = new EnumerationItem(id, label, value, description);
        EnumerationItemTest.assertNotNull((Object)item.toString());
        EnumerationItemTest.assertEquals((String)label, (String)item.toString());
    }

    public void testCompareToEquals() {
        String id = "item 1";
        String label = "Enumeration's item's label";
        String value = "Enumeration's item's value";
        String description = "Description";
        EnumerationItem item = new EnumerationItem(id, label, value, description);
        String anotherValue = "Another enumeration's item's value";
        String anotherDescription = "Another description";
        EnumerationItem equalsItem = new EnumerationItem(id, label, anotherValue, anotherDescription);
        EnumerationItemTest.assertEquals((int)0, (int)item.compareTo(equalsItem));
    }

    public void testCompareToGreaterThan() {
        String id = "item 1";
        String label = "B: Enumeration's item's label";
        String value = "Enumeration's item's value";
        String description = "Description";
        EnumerationItem item = new EnumerationItem(id, label, value, description);
        String anotherLabel = "A: Enumeration's item's label";
        EnumerationItem theLestItem = new EnumerationItem(id, anotherLabel, value, description);
        EnumerationItemTest.assertTrue((item.compareTo(theLestItem) > 0 ? 1 : 0) != 0);
    }

    public void testCompareToLesserThan() {
        String id = "item 1";
        String label = "A: Enumeration's item's label";
        String value = "Enumeration's item's value";
        String description = "Description";
        EnumerationItem item = new EnumerationItem(id, label, value, description);
        String anotherLabel = "B: Enumeration's item's label";
        EnumerationItem theGreatestItem = new EnumerationItem(id, anotherLabel, value, description);
        EnumerationItemTest.assertTrue((item.compareTo(theGreatestItem) < 0 ? 1 : 0) != 0);
    }

    public void testCompareToWithNull() {
        String id = "item 1";
        String label = "A: Enumeration's item's label";
        String value = "Enumeration's item's value";
        String description = "Description";
        EnumerationItem item = new EnumerationItem(id, label, value, description);
        try {
            item.compareTo(null);
            EnumerationItemTest.fail((String)("Deveria lan\u00e7ar um " + NullPointerException.class.getName()));
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public void testSerialize() throws IOException, ClassNotFoundException {
        String id = "item 1";
        String label = "Nome do item";
        String value = "Valor do item";
        String description = "Description";
        EnumerationItem outputItem = new EnumerationItem(id, label, value, description);
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject(outputItem);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        EnumerationItem inputItem = (EnumerationItem)objectInput.readObject();
        EnumerationItemTest.assertEquals((String)outputItem.getLabel(), (String)inputItem.getLabel());
        EnumerationItemTest.assertEquals((String)outputItem.getValue(), (String)inputItem.getValue());
        EnumerationItemTest.assertEquals((String)outputItem.getDescription(), (String)inputItem.getDescription());
    }
}

