/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.FormulaParameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Test;

public final class FormulaParameterTest {
    @Test
    public void testFormulaParameter1() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String commandLinePattern = "{0}={1}";
        FormulaParameter parameter = new FormulaParameter(name, label, description, isOptional, true, commandLinePattern);
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
    }

    @Test
    public void testFormulaParameter2() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "{0}={1}";
        FormulaParameter parameter = new FormulaParameter(name, label, description, isOptional, true, commandLinePattern);
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFormulaParameter3() {
        String name = null;
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "{0}={1}";
        new FormulaParameter(name, label, description, isOptional, true, commandLinePattern);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFormulaParameter4() {
        String name = "Nome do par\u00e2metro";
        String label = null;
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "{0}={1}";
        new FormulaParameter(name, label, description, isOptional, true, commandLinePattern);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFormulaParameter5() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = null;
        boolean isOptional = false;
        String commandLinePattern = "{0}={1}";
        new FormulaParameter(name, label, description, isOptional, true, commandLinePattern);
    }

    @Test
    public void testGetCommandLine1() {
        String name = "NOME";
        String label = "R\u00f3tulo";
        String description = "Descri\u00e7\u00e3o";
        boolean isOptional = true;
        String commandLinePattern = "{0}={1}";
        FormulaParameter parameter = new FormulaParameter(name, label, description, isOptional, true, commandLinePattern);
        parameter.setValue((Object)"a1");
        String commandLine = "NOME=a1";
        Assert.assertEquals((Object)commandLine, (Object)parameter.getCommandLine(null));
    }

    @Test
    public void testGetCommandLine2() {
        String name = "NOME";
        String label = "R\u00f3tulo";
        String description = "Descri\u00e7\u00e3o";
        boolean isOptional = true;
        String commandLinePattern = "{0}={1}";
        FormulaParameter parameter = new FormulaParameter(name, label, description, isOptional, true, commandLinePattern);
        parameter.setValue((Object)"a1_();[]{}+-*/%<> .=^");
        String commandLine = "NOME=a1__Underline____OpenRoundBracket____CloseRoundBracket____SemiColon____OpenSquareBracket____CloseSquareBracket____OpenCurlyBracket____CloseCurlyBracket____PlusSign____MinusSign____Asterisk____Slash____Percent____LessThan____LargeThan____Space____Dot____EqualsSign____Caret__";
        Assert.assertEquals((Object)commandLine, (Object)parameter.getCommandLine(null));
    }

    @Test
    public void testGetCommandLine3() {
        String name = "NOME";
        String label = "R\u00f3tulo";
        String description = "Descri\u00e7\u00e3o";
        boolean isOptional = true;
        String commandLinePattern = "{0}={1}";
        FormulaParameter parameter = new FormulaParameter(name, label, description, isOptional, true, commandLinePattern);
        Assert.assertNull((Object)parameter.getCommandLine(null));
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String commandLinePattern = "{0}={1}";
        FormulaParameter outputParameter = new FormulaParameter(name, label, description, isOptional, true, commandLinePattern);
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject(outputParameter);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        FormulaParameter inputParameter = (FormulaParameter)objectInput.readObject();
        Assert.assertEquals((Object)outputParameter, (Object)inputParameter);
        Assert.assertEquals((Object)outputParameter.getName(), (Object)inputParameter.getName());
        Assert.assertEquals((Object)outputParameter.getLabel(), (Object)inputParameter.getLabel());
        Assert.assertEquals((Object)outputParameter.getDescription(), (Object)inputParameter.getDescription());
        Assert.assertEquals((Object)outputParameter.getDefaultValue(), (Object)inputParameter.getDefaultValue());
        Assert.assertEquals((Object)outputParameter.isOptional(), (Object)inputParameter.isOptional());
    }
}

