/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.exception.algorithms.FormulaCreationException;
import csbase.logic.algorithms.AlgorithmConfiguratorListener;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.CheckAlgorithmConfiguratorListener;
import csbase.logic.algorithms.CommandLineBuilder;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.CommandScript;
import csbase.logic.algorithms.EnvironmentVariable;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.parameters.BooleanParameter;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.HiddenParameter;
import csbase.logic.algorithms.parameters.InputFileListParameter;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.InputURLListParameter;
import csbase.logic.algorithms.parameters.InputURLParameter;
import csbase.logic.algorithms.parameters.MockSimpleParameter;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parameters.OutputURLListParameter;
import csbase.logic.algorithms.parameters.OutputURLParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TextParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.URLValue;
import csbase.logic.algorithms.parameters.ValidationExpression;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.conditions.MockCondition;
import csbase.logic.algorithms.parameters.conditions.SimpleCondition;
import csbase.logic.algorithms.parameters.triggers.CheckTrigger;
import csbase.logic.algorithms.parameters.triggers.MockTrigger;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.Assert;
import org.junit.Test;

public final class SimpleAlgorithmConfiguratorTest {
    private static final String PARAM_DEFAULT_VALUE = "Valor";
    private static final String PARAM_NEW_VALUE = "NovoValor";
    private static final String PARAM_DESCRIPTION = "Descri\u00e7\u00e3o";
    private static final String PARAM_LABEL = "R\u00f3tulo";
    private static final String PARAM_NAME = "Nome";
    private static final String TEXT_FILE_TYPE = "TEXT";
    private static final String OUTPUT_FILE_PARAMETER_LABEL = "Saida";
    private static final String INPUT_FILE_PARAMETER_LABEL = "Entrada";
    private static final String OUTPUT_FILE_PARAMETER_NAME = "OUT";
    private static final String INPUT_FILE_PARAMETER_NAME = "IN";
    private static final String OUTPUT_FILE_PARAMETER_VALUE = "output.txt";
    private static final String INPUT_FILE_PARAMETER_VALUE = "input.ext";
    private static final String OUTPUT_LOG_FILE_PARAMETER_VALUE = "log.txt";
    private static final String GROUP_PARAM_NAME = "Grupo de par\u00e2metros";
    private static final String DIR_NAME = "diretorio";
    private static final String TEXT_FILE_NAME = "arquivo.txt";
    private static final String LOG_FILE_NAME = "out.log";
    private static final String GENERIC_FILE_NAME = "arquivo";
    private static final boolean DONT_PROVIDE_ID = false;
    private static final boolean PROVIDE_ID = true;
    private static final boolean SHOW_OUTPUT = true;
    private static final boolean DONT_SHOW_OUTPUT = false;
    private static final String ALGORITHM_DESCRIPTION = "Descri\u00e7\u00e3o";
    private static final String ABBREVIATION = "Abreviatura";
    private static final String VERSION_DESCRIPTION = "Descri\u00e7\u00e3o da vers\u00e3o";
    private static final String PLATFORM_ID = "id_da_plataforma";
    private static final String PROJECT_ID = "id_do_projeto";
    private static final String TEST_CLIENT = "TEST_CLIENT";
    private static final String COMMAND_ID = "USR@TEST";
    private static final ExecutionType SIMPLE_EXECUTION = ExecutionType.SIMPLE;
    private static final ExecutionLocation BINARY_DIR_EXECUTION = ExecutionLocation.BINARY_DIR;
    private static final ExecutionLocation CMD_DIR_EXECUTION = ExecutionLocation.PERSISTENCY_DIR;
    private static final ExecutionLocation SANDBOX_EXECUTION = ExecutionLocation.SANDBOX;
    private static final String SHELL = "Shell";
    private static final String COMMAND = "comando";
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
    private static final String ALTERNATE_COMMAND_LINE_PATTERN = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
    private static final String DEFAULT_COMMAND_LINE_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
    private static final String LINE_SEPARATOR = "\n";
    private static final String COMMAND_SEPARATOR = ";";
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final String ALGORITHM_REPOSITORY_DIR = "algorithms";
    private static final String PROJECT_REPOSITORY_DIR = "project";
    private static final String PROJECT_DIR_UNIX = "id_do_usuario/nome_do_projeto";
    private static final String PROJECT_DIR_WINDOWS = "id_do_usuario\\nome_do_projeto";
    private static final String FULL_CMD_DIR_PATH_UNIX = "project/id_do_usuario/nome_do_projeto/.cmds";
    private static final String FULL_CMD_DIR_PATH_WINDOWS = "project\\id_do_usuario\\nome_do_projeto\\.cmds";
    private static final String SANDBOX_ROOT_PATH_UNIX = "/tmp";
    private static final String SANDBOX_PATH = "sandbox";
    private static final String SANDBOX_ROOT_PATH_WINDOWS = "\\tmp";
    private static final String ALGORITHM_DIR_WINDOWS = "DIR_Algoritmo\\versions\\v_001_002_003\\bin\\id_da_plataforma";
    private static final String ALGORITHM_DIR_UNIX = "DIR_Algoritmo/versions/v_001_002_003/bin/id_da_plataforma";
    private static final String EXPORT_CLIENT_HOST = "export " + EnvironmentVariable.CLIENT_HOST + "=" + "TEST_CLIENT" + ";";
    private static final String EXPORT_BIN_VAR_UNIX = "export " + EnvironmentVariable.BINARY_DIR + "=" + "algorithms" + '/' + "DIR_Algoritmo/versions/v_001_002_003/bin/id_da_plataforma" + ";";
    private static final String EXPORT_BIN_VAR_WINDOWS = "export " + EnvironmentVariable.BINARY_DIR + "=" + "algorithms" + '\\' + "DIR_Algoritmo\\versions\\v_001_002_003\\bin\\id_da_plataforma" + ";";
    private static final String EXPORT_SANDBOX_VAR_UNIX = "export " + EnvironmentVariable.SANDBOX_DIR + "=" + "/tmp" + '/' + "sandbox" + ";";
    private static final String EXPORT_SANDBOX_VAR_WINDOWS = "export " + EnvironmentVariable.SANDBOX_DIR + "=" + "\\tmp" + '\\' + "sandbox" + ";";
    private static final String EXPORT_PROJ_VAR_UNIX = "export " + EnvironmentVariable.PROJECT_DIR + "=" + "project" + '/' + "id_do_usuario/nome_do_projeto" + ";";
    private static final String EXPORT_PROJ_VAR_WINDOWS = "export " + EnvironmentVariable.PROJECT_DIR + "=" + "project" + '\\' + "id_do_usuario\\nome_do_projeto" + ";";
    private static final String EXPORT_EXECUTION_VAR_BIN = "export " + EnvironmentVariable.EXECUTION_DIR + "=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + ";";
    private static final String EXPORT_EXECUTION_VAR_CMD_UNIX = "export " + EnvironmentVariable.EXECUTION_DIR + "=" + "project/id_do_usuario/nome_do_projeto/.cmds" + ";";
    private static final String EXPORT_LOG_FILE = "export " + EnvironmentVariable.LOG_FILE + "=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + '/' + "out.log" + ";";
    private static final String EXPORT_INPUT_FILES_VAR_UNIX = "export " + EnvironmentVariable.INPUT_FILES + "=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + '/' + "input.ext" + ";";
    private static final String EXPORT_OUTPUT_FILES_VAR_UNIX = "export " + EnvironmentVariable.OUTPUT_FILES + "=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + '/' + "output.txt" + ";";
    private static final String EXPORT_OUTPUT_FILES_VAR_UNIX_WITH_LOG = "export " + EnvironmentVariable.OUTPUT_FILES + "=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + '/' + "log.txt" + ";";
    private static final String EXPORT_EXECUTION_VAR_SANDBOX = "export " + EnvironmentVariable.EXECUTION_DIR + "=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.SANDBOX_DIR) + ";";
    private static final String CD_TO_EXECUTION_DIR_COMMAND = "cd " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.EXECUTION_DIR) + " &&";

    @Test
    public void testSimpleAlgorithmConfiguratorWithValidParameters() {
        AlgorithmVersionInfo algorithmVersionInfo = this.createAlgorithmVersion();
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(algorithmVersionInfo, VERSION_DESCRIPTION, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, ABBREVIATION, false, COMMAND, SHELL, INPUT_FILE_PARAMETER_NAME, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        Assert.assertEquals((Object)algorithmVersionInfo, (Object)configurator.getAlgorithmVersion());
        Assert.assertEquals((String)VERSION_DESCRIPTION, (String)configurator.getDescription());
        Assert.assertEquals((Object)SIMPLE_EXECUTION, (Object)configurator.getExecutionType());
        Assert.assertEquals((Object)BINARY_DIR_EXECUTION, (Object)configurator.getExecutionLocation());
        Assert.assertEquals((String)ABBREVIATION, (String)configurator.getAbbreviation());
        Assert.assertEquals((boolean)false, (boolean)configurator.provideId());
        Assert.assertEquals((String)COMMAND, (String)configurator.getCommandBinaryName());
        Assert.assertEquals((String)SHELL, (String)configurator.getShell());
        Assert.assertEquals((String)INPUT_FILE_PARAMETER_NAME, (String)configurator.getDefaultInputFileParameterName());
        Assert.assertTrue((boolean)configurator.getTriggers().isEmpty());
        Assert.assertNotNull((Object)configurator.getExpressions());
        Assert.assertTrue((boolean)configurator.getExpressions().isEmpty());
        Assert.assertNotNull((Object)configurator.getGroups());
        Assert.assertNull((Object)configurator.getFilePath());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSimpleAlgorithmConfiguratorWithNullVersion() {
        AlgorithmVersionInfo algorithmVersionInfo = null;
        new SimpleAlgorithmConfigurator(algorithmVersionInfo, VERSION_DESCRIPTION, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, ABBREVIATION, false, COMMAND, SHELL, INPUT_FILE_PARAMETER_NAME, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
    }

    @Test
    public void testSimpleAlgorithmConfiguratorWithNullDescription() {
        AlgorithmVersionInfo algorithmVersionInfo = this.createAlgorithmVersion();
        String description = null;
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(algorithmVersionInfo, description, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, ABBREVIATION, false, COMMAND, SHELL, INPUT_FILE_PARAMETER_NAME, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        Assert.assertEquals((Object)algorithmVersionInfo, (Object)configurator.getAlgorithmVersion());
        Assert.assertEquals(description, (String)configurator.getDescription());
        Assert.assertEquals((Object)SIMPLE_EXECUTION, (Object)configurator.getExecutionType());
        Assert.assertEquals((Object)BINARY_DIR_EXECUTION, (Object)configurator.getExecutionLocation());
        Assert.assertEquals((String)ABBREVIATION, (String)configurator.getAbbreviation());
        Assert.assertEquals((boolean)false, (boolean)configurator.provideId());
        Assert.assertEquals((String)COMMAND, (String)configurator.getCommandBinaryName());
        Assert.assertEquals((String)SHELL, (String)configurator.getShell());
        Assert.assertEquals((String)INPUT_FILE_PARAMETER_NAME, (String)configurator.getDefaultInputFileParameterName());
        Assert.assertNotNull((Object)configurator.getTriggers());
        Assert.assertTrue((boolean)configurator.getTriggers().isEmpty());
        Assert.assertNotNull((Object)configurator.getExpressions());
        Assert.assertTrue((boolean)configurator.getExpressions().isEmpty());
        Assert.assertNotNull((Object)configurator.getGroups());
        Assert.assertNull((Object)configurator.getFilePath());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSimpleAlgorithmConfiguratorWithNullExecutionType() {
        AlgorithmVersionInfo algorithmVersionInfo = this.createAlgorithmVersion();
        ExecutionType executionType = null;
        new SimpleAlgorithmConfigurator(algorithmVersionInfo, VERSION_DESCRIPTION, executionType, BINARY_DIR_EXECUTION, ABBREVIATION, false, COMMAND, SHELL, INPUT_FILE_PARAMETER_NAME, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
    }

    @Test
    public void testSimpleAlgorithmConfiguratorWithNoIdAndNullAbbreviation() {
        AlgorithmVersionInfo algorithmVersionInfo = this.createAlgorithmVersion();
        String abbreviation = null;
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(algorithmVersionInfo, "Descri\u00e7\u00e3o", SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, abbreviation, false, COMMAND, SHELL, INPUT_FILE_PARAMETER_NAME, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        Assert.assertEquals((Object)algorithmVersionInfo, (Object)configurator.getAlgorithmVersion());
        Assert.assertEquals((String)"Descri\u00e7\u00e3o", (String)configurator.getDescription());
        Assert.assertEquals((Object)SIMPLE_EXECUTION, (Object)configurator.getExecutionType());
        Assert.assertEquals((Object)BINARY_DIR_EXECUTION, (Object)configurator.getExecutionLocation());
        Assert.assertEquals(abbreviation, (String)configurator.getAbbreviation());
        Assert.assertEquals((boolean)false, (boolean)configurator.provideId());
        Assert.assertEquals((String)COMMAND, (String)configurator.getCommandBinaryName());
        Assert.assertEquals((String)SHELL, (String)configurator.getShell());
        Assert.assertEquals((String)INPUT_FILE_PARAMETER_NAME, (String)configurator.getDefaultInputFileParameterName());
        Assert.assertNotNull((Object)configurator.getTriggers());
        Assert.assertTrue((boolean)configurator.getTriggers().isEmpty());
        Assert.assertNotNull((Object)configurator.getExpressions());
        Assert.assertTrue((boolean)configurator.getExpressions().isEmpty());
        Assert.assertNotNull((Object)configurator.getGroups());
        Assert.assertNull((Object)configurator.getFilePath());
    }

    @Test
    public void testSimpleAlgorithmConfiguratorWithIdAndNullAbbreviation() {
        AlgorithmVersionInfo algorithmVersionInfo = this.createAlgorithmVersion();
        String abbreviation = null;
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(algorithmVersionInfo, "Descri\u00e7\u00e3o", SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, abbreviation, true, COMMAND, SHELL, INPUT_FILE_PARAMETER_NAME, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        Assert.assertEquals((Object)algorithmVersionInfo, (Object)configurator.getAlgorithmVersion());
        Assert.assertEquals((String)"Descri\u00e7\u00e3o", (String)configurator.getDescription());
        Assert.assertEquals((Object)SIMPLE_EXECUTION, (Object)configurator.getExecutionType());
        Assert.assertEquals(abbreviation, (String)configurator.getAbbreviation());
        Assert.assertEquals((boolean)true, (boolean)configurator.provideId());
        Assert.assertEquals((String)COMMAND, (String)configurator.getCommandBinaryName());
        Assert.assertEquals((String)SHELL, (String)configurator.getShell());
        Assert.assertEquals((String)INPUT_FILE_PARAMETER_NAME, (String)configurator.getDefaultInputFileParameterName());
        Assert.assertNotNull((Object)configurator.getTriggers());
        Assert.assertTrue((boolean)configurator.getTriggers().isEmpty());
        Assert.assertNotNull((Object)configurator.getExpressions());
        Assert.assertTrue((boolean)configurator.getExpressions().isEmpty());
        Assert.assertNotNull((Object)configurator.getGroups());
        Assert.assertNull((Object)configurator.getFilePath());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSimpleAlgorithmConfiguratorWithNullCommand() {
        AlgorithmVersionInfo algorithmVersionInfo = this.createAlgorithmVersion();
        String command = null;
        new SimpleAlgorithmConfigurator(algorithmVersionInfo, VERSION_DESCRIPTION, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, ABBREVIATION, false, command, SHELL, INPUT_FILE_PARAMETER_NAME, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
    }

    @Test
    public void testSimpleAlgorithmConfiguratorWithNullShell() {
        AlgorithmVersionInfo algorithmVersionInfo = this.createAlgorithmVersion();
        String shell = null;
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(algorithmVersionInfo, "Descri\u00e7\u00e3o", SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, ABBREVIATION, true, COMMAND, shell, INPUT_FILE_PARAMETER_NAME, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        Assert.assertEquals((Object)algorithmVersionInfo, (Object)configurator.getAlgorithmVersion());
        Assert.assertEquals((String)"Descri\u00e7\u00e3o", (String)configurator.getDescription());
        Assert.assertEquals((Object)SIMPLE_EXECUTION, (Object)configurator.getExecutionType());
        Assert.assertEquals((Object)BINARY_DIR_EXECUTION, (Object)configurator.getExecutionLocation());
        Assert.assertEquals((String)ABBREVIATION, (String)configurator.getAbbreviation());
        Assert.assertEquals((boolean)true, (boolean)configurator.provideId());
        Assert.assertEquals((String)COMMAND, (String)configurator.getCommandBinaryName());
        Assert.assertEquals(shell, (String)configurator.getShell());
        Assert.assertEquals((String)INPUT_FILE_PARAMETER_NAME, (String)configurator.getDefaultInputFileParameterName());
        Assert.assertNotNull((Object)configurator.getTriggers());
        Assert.assertTrue((boolean)configurator.getTriggers().isEmpty());
        Assert.assertNotNull((Object)configurator.getExpressions());
        Assert.assertTrue((boolean)configurator.getExpressions().isEmpty());
        Assert.assertNotNull((Object)configurator.getGroups());
        Assert.assertNull((Object)configurator.getFilePath());
    }

    @Test
    public void testSimpleAlgorithmConfiguratorWithNullInputFile() {
        AlgorithmVersionInfo algorithmVersionInfo = this.createAlgorithmVersion();
        String inputFileParameterName = null;
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(algorithmVersionInfo, "Descri\u00e7\u00e3o", SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, ABBREVIATION, true, COMMAND, SHELL, inputFileParameterName, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        Assert.assertEquals((Object)algorithmVersionInfo, (Object)configurator.getAlgorithmVersion());
        Assert.assertEquals((String)"Descri\u00e7\u00e3o", (String)configurator.getDescription());
        Assert.assertEquals((Object)SIMPLE_EXECUTION, (Object)configurator.getExecutionType());
        Assert.assertEquals((Object)BINARY_DIR_EXECUTION, (Object)configurator.getExecutionLocation());
        Assert.assertEquals((String)ABBREVIATION, (String)configurator.getAbbreviation());
        Assert.assertEquals((boolean)true, (boolean)configurator.provideId());
        Assert.assertEquals((String)COMMAND, (String)configurator.getCommandBinaryName());
        Assert.assertEquals((String)SHELL, (String)configurator.getShell());
        Assert.assertEquals(inputFileParameterName, (String)configurator.getDefaultInputFileParameterName());
        Assert.assertNotNull((Object)configurator.getTriggers());
        Assert.assertTrue((boolean)configurator.getTriggers().isEmpty());
        Assert.assertNotNull((Object)configurator.getExpressions());
        Assert.assertTrue((boolean)configurator.getExpressions().isEmpty());
        Assert.assertNotNull((Object)configurator.getGroups());
        Assert.assertNull((Object)configurator.getFilePath());
    }

    @Test
    public void testSimpleAlgorithmConfiguratorWithPersistencyDirectoryExecution() {
        AlgorithmVersionInfo algorithmVersionInfo = this.createAlgorithmVersion();
        ExecutionLocation executionLocation = CMD_DIR_EXECUTION;
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(algorithmVersionInfo, "Descri\u00e7\u00e3o", SIMPLE_EXECUTION, executionLocation, ABBREVIATION, true, COMMAND, SHELL, INPUT_FILE_PARAMETER_NAME, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        Assert.assertEquals((Object)algorithmVersionInfo, (Object)configurator.getAlgorithmVersion());
        Assert.assertEquals((String)"Descri\u00e7\u00e3o", (String)configurator.getDescription());
        Assert.assertEquals((Object)SIMPLE_EXECUTION, (Object)configurator.getExecutionType());
        Assert.assertEquals((Object)executionLocation, (Object)configurator.getExecutionLocation());
        Assert.assertEquals((String)ABBREVIATION, (String)configurator.getAbbreviation());
        Assert.assertEquals((boolean)true, (boolean)configurator.provideId());
        Assert.assertEquals((String)COMMAND, (String)configurator.getCommandBinaryName());
        Assert.assertEquals((String)SHELL, (String)configurator.getShell());
        Assert.assertEquals((String)INPUT_FILE_PARAMETER_NAME, (String)configurator.getDefaultInputFileParameterName());
        Assert.assertNotNull((Object)configurator.getTriggers());
        Assert.assertTrue((boolean)configurator.getTriggers().isEmpty());
        Assert.assertNotNull((Object)configurator.getExpressions());
        Assert.assertTrue((boolean)configurator.getExpressions().isEmpty());
        Assert.assertNotNull((Object)configurator.getGroups());
        Assert.assertNull((Object)configurator.getFilePath());
    }

    @Test
    public void testSimpleAlgorithmConfiguratorWithSandboxDirectoryExecution() {
        AlgorithmVersionInfo algorithmVersionInfo = this.createAlgorithmVersion();
        ExecutionLocation executionLocation = SANDBOX_EXECUTION;
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(algorithmVersionInfo, "Descri\u00e7\u00e3o", SIMPLE_EXECUTION, executionLocation, ABBREVIATION, true, COMMAND, SHELL, INPUT_FILE_PARAMETER_NAME, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        Assert.assertEquals((Object)algorithmVersionInfo, (Object)configurator.getAlgorithmVersion());
        Assert.assertEquals((String)"Descri\u00e7\u00e3o", (String)configurator.getDescription());
        Assert.assertEquals((Object)SIMPLE_EXECUTION, (Object)configurator.getExecutionType());
        Assert.assertEquals((Object)executionLocation, (Object)configurator.getExecutionLocation());
        Assert.assertEquals((String)ABBREVIATION, (String)configurator.getAbbreviation());
        Assert.assertEquals((boolean)true, (boolean)configurator.provideId());
        Assert.assertEquals((String)COMMAND, (String)configurator.getCommandBinaryName());
        Assert.assertEquals((String)SHELL, (String)configurator.getShell());
        Assert.assertEquals((String)INPUT_FILE_PARAMETER_NAME, (String)configurator.getDefaultInputFileParameterName());
        Assert.assertNotNull((Object)configurator.getTriggers());
        Assert.assertTrue((boolean)configurator.getTriggers().isEmpty());
        Assert.assertNotNull((Object)configurator.getExpressions());
        Assert.assertTrue((boolean)configurator.getExpressions().isEmpty());
        Assert.assertNotNull((Object)configurator.getGroups());
        Assert.assertNull((Object)configurator.getFilePath());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSimpleAlgorithmConfiguratorWithNullExecutionLocation() {
        AlgorithmVersionInfo algorithmVersionInfo = this.createAlgorithmVersion();
        ExecutionLocation executionLocation = null;
        new SimpleAlgorithmConfigurator(algorithmVersionInfo, "Descri\u00e7\u00e3o", SIMPLE_EXECUTION, executionLocation, ABBREVIATION, true, COMMAND, SHELL, INPUT_FILE_PARAMETER_NAME, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
    }

    @Test
    public void testAddExpressionWithValidExpression() throws FormulaCreationException, ParseException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        HashSet<ValidationExpression> expressions = new HashSet<ValidationExpression>();
        for (int i = 0; i < 10; ++i) {
            ValidationExpression expression = new ValidationExpression(configurator, Integer.toString(i), "Erro " + i);
            expressions.add(expression);
            Assert.assertTrue((boolean)configurator.addExpression(expression));
            Assert.assertEquals(expressions, (Object)configurator.getExpressions());
        }
    }

    @Test
    public void testAddExpressionWithDuplicateExpression() throws FormulaCreationException, ParseException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        HashSet<ValidationExpression> expressions = new HashSet<ValidationExpression>();
        for (int i = 0; i < 10; ++i) {
            ValidationExpression expression = new ValidationExpression(configurator, Integer.toString(i), "Erro " + i);
            expressions.add(expression);
            Assert.assertTrue((boolean)configurator.addExpression(expression));
            Assert.assertFalse((boolean)configurator.addExpression(expression));
            Assert.assertEquals(expressions, (Object)configurator.getExpressions());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddExpressionWithNullExpression() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        configurator.addExpression(null);
    }

    @Test
    public void testAddGroupWithValidGroup() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        LinkedList<ParameterGroup> groups = new LinkedList<ParameterGroup>();
        for (int i = 0; i < 10; ++i) {
            ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME + i);
            groups.add(group);
            Assert.assertTrue((boolean)configurator.addGroup(group));
        }
        Assert.assertEquals(groups, (Object)configurator.getGroups());
    }

    @Test
    public void testAddGroupWithDuplicateGroup() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        LinkedList<ParameterGroup> groups = new LinkedList<ParameterGroup>();
        for (int i = 0; i < 10; ++i) {
            ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME + i);
            groups.add(group);
            Assert.assertTrue((boolean)configurator.addGroup(group));
            Assert.assertFalse((boolean)configurator.addGroup(group));
        }
        Assert.assertEquals(groups, (Object)configurator.getGroups());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddGroupWithNullGroup() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        configurator.addGroup(null);
    }

    @Test
    public void testAddTriggerWithValidTrigger() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        configurator.addGroup(group);
        MockSimpleParameter parameter = new MockSimpleParameter(PARAM_NAME, PARAM_LABEL, "Descri\u00e7\u00e3o", PARAM_DEFAULT_VALUE, false, true, ALTERNATE_COMMAND_LINE_PATTERN);
        group.addParameter((Parameter)parameter);
        HashSet<MockTrigger> triggers = new HashSet<MockTrigger>();
        MockCondition condition = new MockCondition(true);
        MockTrigger trigger = new MockTrigger(parameter, condition);
        Assert.assertTrue((boolean)configurator.addTrigger((Trigger)trigger));
        triggers.add(trigger);
        Assert.assertEquals(triggers, (Object)configurator.getTriggers());
    }

    @Test
    public void testAddTriggerWithDuplicateTrigger() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        configurator.addGroup(group);
        MockSimpleParameter parameter = new MockSimpleParameter(PARAM_NAME, PARAM_LABEL, "Descri\u00e7\u00e3o", PARAM_DEFAULT_VALUE, false, true, ALTERNATE_COMMAND_LINE_PATTERN);
        group.addParameter((Parameter)parameter);
        HashSet<MockTrigger> triggers = new HashSet<MockTrigger>();
        MockCondition condition = new MockCondition(true);
        MockTrigger trigger = new MockTrigger(parameter, condition);
        Assert.assertTrue((boolean)configurator.addTrigger((Trigger)trigger));
        Assert.assertFalse((boolean)configurator.addTrigger((Trigger)trigger));
        triggers.add(trigger);
        Assert.assertEquals(triggers, (Object)configurator.getTriggers());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddTriggerWithNullTrigger() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        configurator.addTrigger(null);
    }

    @Test
    public void testGetExpressionsWithInvalidAccessToInternalData() throws FormulaCreationException, ParseException {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        HashSet<ValidationExpression> expressions = new HashSet<ValidationExpression>();
        for (int i = 0; i < 10; ++i) {
            ValidationExpression expression = new ValidationExpression(configurator, Integer.toString(i), "Erro " + i);
            expressions.add(expression);
            Assert.assertTrue((boolean)configurator.addExpression(expression));
        }
        Assert.assertEquals(expressions, (Object)configurator.getExpressions());
        try {
            configurator.getExpressions().clear();
            Assert.fail((String)"N\u00e3o deveria ser poss\u00edvel modificar a lista de express\u00f5es diretamente.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals(expressions, (Object)configurator.getExpressions());
    }

    @Test
    public void testGetGroupsWithInvalidAccessToInternalData() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        LinkedList<ParameterGroup> groups = new LinkedList<ParameterGroup>();
        for (int i = 0; i < 10; ++i) {
            ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME + i);
            groups.add(group);
            Assert.assertTrue((boolean)configurator.addGroup(group));
        }
        Assert.assertEquals(groups, (Object)configurator.getGroups());
        try {
            configurator.getGroups().clear();
            Assert.fail((String)"N\u00e3o deveria ser poss\u00edvel alterar a lista de grupos diretamente.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals(groups, (Object)configurator.getGroups());
    }

    @Test
    public void testGetTriggersWithInvalidAccessToInternalData() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        configurator.addGroup(group);
        MockSimpleParameter parameter = new MockSimpleParameter(PARAM_NAME, PARAM_LABEL, "Descri\u00e7\u00e3o", PARAM_DEFAULT_VALUE, false, true, ALTERNATE_COMMAND_LINE_PATTERN);
        group.addParameter((Parameter)parameter);
        HashSet<MockTrigger> triggers = new HashSet<MockTrigger>();
        MockCondition condition = new MockCondition(true);
        MockTrigger trigger = new MockTrigger(parameter, condition);
        Assert.assertTrue((boolean)configurator.addTrigger((Trigger)trigger));
        triggers.add(trigger);
        Assert.assertEquals(triggers, (Object)configurator.getTriggers());
        try {
            configurator.getTriggers().clear();
            Assert.fail((String)"N\u00e3o deveria ser poss\u00edvel alterar a lista de restri\u00e7\u00f5es diretamente.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        Assert.assertEquals(triggers, (Object)configurator.getTriggers());
    }

    @Test
    public void testGetInputFileParametersWithSingleFile() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        configurator.addGroup(group);
        Assert.assertNotNull((Object)configurator.getInputFileParameters());
        Assert.assertTrue((boolean)configurator.getInputFileParameters().isEmpty());
    }

    @Test
    public void testGetInputFileParametersWithMultipleFiles() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        configurator.addGroup(group);
        LinkedList<InputFileParameter> inputFileParameters = new LinkedList<InputFileParameter>();
        for (int i = 0; i < 10; ++i) {
            InputFileParameter inputFileParameter = new InputFileParameter(PARAM_NAME + i, PARAM_LABEL + i, "Descri\u00e7\u00e3o" + i, null, true, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
            inputFileParameters.add(inputFileParameter);
            group.addParameter((Parameter)inputFileParameter);
        }
        Assert.assertEquals(inputFileParameters, (Object)configurator.getInputFileParameters());
    }

    @Test
    public void testGetOutputFileParametersWithNoFiles() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        configurator.addGroup(group);
        LinkedList outputFileParameters = new LinkedList();
        Assert.assertEquals(outputFileParameters, (Object)configurator.getOutputFileParameters());
    }

    @Test
    public void testGetOutputFileParametersWithMultipleFiles() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        configurator.addGroup(group);
        LinkedList<OutputFileParameter> outputFileParameters = new LinkedList<OutputFileParameter>();
        for (int i = 0; i < 10; ++i) {
            OutputFileParameter outputFileParameter = new OutputFileParameter(PARAM_NAME + i, PARAM_LABEL + i, "Descri\u00e7\u00e3o" + i, null, true, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
            outputFileParameters.add(outputFileParameter);
            group.addParameter((Parameter)outputFileParameter);
        }
        Assert.assertEquals(outputFileParameters, (Object)configurator.getOutputFileParameters());
    }

    @Test
    public void testResetValuesWithMultipleParameters() {
        SimpleParameter simpleParameter;
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        for (int i = 0; i < 10; ++i) {
            ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME + i);
            for (int j = 0; j < 10; ++j) {
                Object[] formats = new Object[]{new Integer(i), new Integer(j)};
                Object parameter = new MockSimpleParameter(MessageFormat.format("Nome do par\u00e2metro $NOME_DO_PARAMETRO.$VALOR_DO_PARAMETRO", formats), MessageFormat.format("R\u00f3tulo do par\u00e2metro $NOME_DO_PARAMETRO.$VALOR_DO_PARAMETRO", formats), MessageFormat.format("Descri\u00e7\u00e3o do par\u00e2metro $NOME_DO_PARAMETRO.$VALOR_DO_PARAMETRO", formats), MessageFormat.format("Valor do par\u00e2metro $NOME_DO_PARAMETRO.$VALOR_DO_PARAMETRO", formats), false, true, null);
                group.addParameter(parameter);
            }
            configurator.addGroup(group);
        }
        int count = 0;
        for (ParameterGroup group : configurator.getGroups()) {
            for (Object parameter : group.getParameters()) {
                simpleParameter = (SimpleParameter)parameter;
                String value = PARAM_DEFAULT_VALUE + count;
                ++count;
                simpleParameter.setValue((Object)value);
                Assert.assertEquals((Object)value, (Object)simpleParameter.getValue());
            }
        }
        configurator.resetValues();
        for (ParameterGroup group : configurator.getGroups()) {
            for (Object parameter : group.getParameters()) {
                simpleParameter = (SimpleParameter)parameter;
                Assert.assertEquals((Object)simpleParameter.getDefaultValue(), (Object)simpleParameter.getValue());
            }
        }
    }

    @Test
    public void testImportValuesWithMultipleParameters() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        for (int i = 0; i < 10; ++i) {
            ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME + i);
            for (int j = 0; j < 10; ++j) {
                Object[] formats = new Object[]{new Integer(i), new Integer(j)};
                MockSimpleParameter parameter = new MockSimpleParameter(MessageFormat.format("Nome do par\u00e2metro $NOME_DO_PARAMETRO.$VALOR_DO_PARAMETRO", formats), MessageFormat.format("R\u00f3tulo do par\u00e2metro $NOME_DO_PARAMETRO.$VALOR_DO_PARAMETRO", formats), MessageFormat.format("Descri\u00e7\u00e3o do par\u00e2metro $NOME_DO_PARAMETRO.$VALOR_DO_PARAMETRO", formats), MessageFormat.format("Valor do par\u00e2metro $NOME_DO_PARAMETRO.$VALOR_DO_PARAMETRO", formats), false, true, null);
                group.addParameter((Parameter)parameter);
            }
            configurator.addGroup(group);
        }
        Map exportedValues = configurator.exportValues();
        Assert.assertNotNull((Object)exportedValues);
        Iterator groupIterator = configurator.getGroups().iterator();
        int count = 0;
        while (groupIterator.hasNext()) {
            ParameterGroup group = (ParameterGroup)groupIterator.next();
            for (SimpleParameter parameter : group.getParameters()) {
                String value = PARAM_DEFAULT_VALUE + count;
                ++count;
                parameter.setValue((Object)value);
                Assert.assertEquals((Object)value, (Object)parameter.getValue());
            }
        }
        configurator.importValues(exportedValues);
        for (ParameterGroup group : configurator.getGroups()) {
            for (SimpleParameter parameter : group.getParameters()) {
                Assert.assertEquals((Object)parameter.getDefaultValue(), (Object)parameter.getValue());
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImportValuesWithNullValues() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        configurator.importValues(null);
    }

    @Test
    public void testUpdateTriggersWithProhibitedUndo() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        MockSimpleParameter parameter = new MockSimpleParameter(PARAM_NAME, PARAM_LABEL, "Descri\u00e7\u00e3o", null, true, true, null);
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        SimpleCondition condition = new SimpleCondition(parameter.getName(), (Object)PARAM_NEW_VALUE);
        CheckTrigger trigger = new CheckTrigger(parameter, (Condition)condition);
        trigger.allowUndo();
        configurator.addTrigger((Trigger)trigger);
        Assert.assertTrue((boolean)trigger.wasUndone());
        trigger.prohibitUndo();
        trigger.allowDo();
        Assert.assertTrue((boolean)parameter.setValue(PARAM_NEW_VALUE));
        Assert.assertTrue((boolean)trigger.wasDone());
    }

    @Test
    public void testUpdateTriggersWithUndoPermission() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        MockSimpleParameter parameter = new MockSimpleParameter(PARAM_NAME, PARAM_LABEL, "Descri\u00e7\u00e3o", PARAM_DEFAULT_VALUE, true, true, null);
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        SimpleCondition condition = new SimpleCondition(parameter.getName(), null);
        CheckTrigger trigger = new CheckTrigger(parameter, (Condition)condition);
        trigger.allowUndo();
        configurator.addTrigger((Trigger)trigger);
        Assert.assertTrue((boolean)trigger.wasUndone());
        Assert.assertTrue((boolean)parameter.setValue(PARAM_NEW_VALUE));
        Assert.assertTrue((boolean)trigger.wasUndone());
    }

    @Test
    public void testMakeCommandLineWithUnixSeparator() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND + " )";
        cmd = cmd + ")";
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, '/', PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        Assert.assertEquals((String)cmd, (String)configurator.makeCommandLine(context));
    }

    @Test
    public void testMakeCommandLineWithWindowsSeparator() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_WINDOWS;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_WINDOWS;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_WINDOWS;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '\\' + COMMAND + " )";
        cmd = cmd + ")";
        CommandLineContext commandLineContext = new CommandLineContext(COMMAND_ID, PLATFORM_ID, '\\', PROJECT_DIR_WINDOWS, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_WINDOWS, SANDBOX_PATH, FULL_CMD_DIR_PATH_WINDOWS, false, null, null);
        Assert.assertEquals((String)cmd, (String)configurator.makeCommandLine(commandLineContext));
    }

    @Test
    public void testMakeCommandLineWithBooleanParameters() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        ParameterGroup group1 = new ParameterGroup("Grupo 1");
        String parameterName11 = "Par\u00e2metro_1.1";
        boolean parameterValue11 = false;
        String falseCommand11 = "FALSO 1.1";
        String trueCommand11 = "VERDADEIRO 1.1";
        String parameterLabel11 = "R\u00f3tulo do par\u00e2metro 1.1";
        String parameterDescription11 = "Descri\u00e7\u00e3o do par\u00e2metro 1.1";
        BooleanParameter parameter11 = new BooleanParameter(parameterName11, parameterLabel11, parameterDescription11, parameterValue11, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", falseCommand11, trueCommand11);
        group1.addParameter((Parameter)parameter11);
        String parameterName12 = "Par\u00e2metro_1.2";
        boolean parameterValue12 = true;
        String falseCommand12 = "FALSO 1.2";
        String trueCommand12 = "VERDADEIRO 1.2";
        String parameterLabel12 = "R\u00f3tulo do par\u00e2metro 1.2";
        String parameterDescription12 = "Descri\u00e7\u00e3o do par\u00e2metro 1.2";
        BooleanParameter parameter12 = new BooleanParameter(parameterName12, parameterLabel12, parameterDescription12, parameterValue12, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", falseCommand12, trueCommand12);
        group1.addParameter((Parameter)parameter12);
        ParameterGroup group2 = new ParameterGroup("Grupo 2");
        String parameterName21 = "Par\u00e2metro_2.1";
        boolean parameterValue21 = true;
        String falseCommand21 = "FALSO 2.1";
        String trueCommand21 = "VERDADEIRO 2.1";
        String parameterLabel21 = "R\u00f3tulo do par\u00e2metro 2.1";
        String parameterDescription21 = "Descri\u00e7\u00e3o do par\u00e2metro 2.1";
        BooleanParameter parameter21 = new BooleanParameter(parameterName21, parameterLabel21, parameterDescription21, parameterValue21, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", falseCommand21, trueCommand21);
        group2.addParameter((Parameter)parameter21);
        String parameterName22 = "Par\u00e2metro_2.2";
        boolean parameterValue22 = false;
        String falseCommand22 = "FALSO 2.2";
        String trueCommand22 = "VERDADEIRO 2.2";
        String parameterLabel22 = "R\u00f3tulo do par\u00e2metro 2.2";
        String parameterDescription22 = "Descri\u00e7\u00e3o do par\u00e2metro 2.2";
        BooleanParameter parameter22 = new BooleanParameter(parameterName22, parameterLabel22, parameterDescription22, parameterValue22, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", falseCommand22, trueCommand22);
        group2.addParameter((Parameter)parameter22);
        configurator.addGroup(group1);
        configurator.addGroup(group2);
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "Par\u00e2metro_1.1=FALSO 1.1 ";
        cmd = cmd + "Par\u00e2metro_1.2=VERDADEIRO 1.2 ";
        cmd = cmd + "Par\u00e2metro_2.1=VERDADEIRO 2.1 ";
        cmd = cmd + "Par\u00e2metro_2.2=FALSO 2.2";
        cmd = cmd + " ))";
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, '/', PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        Assert.assertEquals((String)cmd, (String)configurator.makeCommandLine(context));
    }

    @Test
    public void testMakeCommandLineWithTextParameters() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        ParameterGroup group1 = new ParameterGroup("Grupo 1");
        String parameterName11 = "Par\u00e2metro_1.1";
        String parameterLabel11 = "R\u00f3tulo do par\u00e2metro 1.1";
        String parameterDescription11 = "Descri\u00e7\u00e3o do par\u00e2metro 1.1";
        String parameterValue11 = "Valor1_1";
        TextParameter parameter11 = new TextParameter(parameterName11, parameterLabel11, parameterDescription11, parameterValue11, true, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null);
        group1.addParameter((Parameter)parameter11);
        ParameterGroup group2 = new ParameterGroup("Grupo 2");
        String parameterName21 = "Par\u00e2metro_2.1";
        String parameterLabel21 = "R\u00f3tulo do par\u00e2metro 2.1";
        String parameterDescription21 = "Descri\u00e7\u00e3o do par\u00e2metro 2.1";
        String parameterValue21 = null;
        TextParameter parameter21 = new TextParameter(parameterName21, parameterLabel21, parameterDescription21, parameterValue21, true, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null);
        group2.addParameter((Parameter)parameter21);
        configurator.addGroup(group1);
        configurator.addGroup(group2);
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "Par\u00e2metro_1.1=Valor1_1";
        cmd = cmd + " ))";
        char fileSeparator = '/';
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, fileSeparator, PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        Assert.assertEquals((String)cmd, (String)configurator.makeCommandLine(context));
    }

    @Test
    public void testMakeCommandLineWithExitCode() {
        char fileSeparator = '/';
        String exitCodeFilePath = "exit_code.log";
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, fileSeparator, PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " )); ";
        cmd = cmd + "exit_code=$?; echo $exit_code > ";
        cmd = cmd + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + fileSeparator + exitCodeFilePath;
        cmd = cmd + "; return $exit_code; ";
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        FileParameterValue exitCodeLogFile = new FileParameterValue(exitCodeFilePath, TEXT_FILE_TYPE);
        configurator.setHasExitCode(true);
        configurator.setExitCodeLogFile(exitCodeLogFile);
        String cmd2 = configurator.makeCommandLine(context);
        Assert.assertEquals((String)cmd.toString(), (String)cmd2);
    }

    @Test
    public void testMakeCommandLineWithoutStdOutputFileNotShowingOutuputOnScreen() {
        char fileSeparator = '/';
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " )) > /dev/null 2>&1";
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, false, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, fileSeparator, PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        String cmd2 = configurator.makeCommandLine(context);
        Assert.assertEquals((String)cmd.toString(), (String)cmd2);
    }

    @Test
    public void testMakeCommandLineWithStdOutputFileShowingOutuputOnScreen() {
        char fileSeparator = '/';
        String stdOut = LOG_FILE_NAME;
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_LOG_FILE;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " )) 2>&1 | tee -a";
        cmd = cmd + " ";
        cmd = cmd + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.LOG_FILE);
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        configurator.setStandardOutputFile(new FileParameterValue(stdOut));
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, fileSeparator, PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        String cmd2 = configurator.makeCommandLine(context);
        Assert.assertEquals((String)cmd.toString(), (String)cmd2);
    }

    @Test
    public void testMakeCommandLineWithStdOutputFileNotShowingOutuputOnScreen() {
        char fileSeparator = '/';
        String stdOut = LOG_FILE_NAME;
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_LOG_FILE;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " )) > ";
        cmd = cmd + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.LOG_FILE);
        cmd = cmd + " 2>&1";
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, false, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        configurator.setStandardOutputFile(new FileParameterValue(stdOut));
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, fileSeparator, PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        String cmd2 = configurator.makeCommandLine(context);
        Assert.assertEquals((String)cmd.toString(), (String)cmd2);
    }

    @Test
    public void testMakeCommandLineWithLogParameter() {
        char fileSeparator = '/';
        String logPath = OUTPUT_LOG_FILE_PARAMETER_VALUE;
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_OUTPUT_FILES_VAR_UNIX_WITH_LOG;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "LOG_FILE=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + '/' + logPath;
        cmd = cmd + " ))";
        FileParameterValue file = new FileParameterValue(logPath, TEXT_FILE_TYPE);
        OutputFileParameter logFileParameter = OutputFileParameter.createLogFile((String)"$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        logFileParameter.setValue(file);
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)logFileParameter);
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        configurator.addGroup(group);
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, fileSeparator, PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        String cmd2 = configurator.makeCommandLine(context);
        Assert.assertEquals((String)cmd.toString(), (String)cmd2);
    }

    @Test
    public void testMakeCommandLineWithCommandId() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, true, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "cmdId=USR@TEST";
        cmd = cmd + " ))";
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, '/', PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        String cmd2 = configurator.makeCommandLine(context);
        Assert.assertEquals((String)cmd, (String)cmd2);
    }

    @Test
    public void testMakeCommandLineWithBinaryDirectoryExecution() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " ))";
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, '/', PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        String cmd2 = configurator.makeCommandLine(context);
        Assert.assertEquals((String)cmd, (String)cmd2);
    }

    @Test
    public void testMakeCommandLineWithPersistencyDirectoryExecution() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, CMD_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_CMD_UNIX;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " ))";
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, '/', PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        String cmd2 = configurator.makeCommandLine(context);
        Assert.assertEquals((String)cmd, (String)cmd2);
    }

    @Test
    public void testMakeCommandLineWithSandboxDirectoryExecution() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, SANDBOX_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_SANDBOX;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " ))";
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, '/', PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        String cmd2 = configurator.makeCommandLine(context);
        Assert.assertEquals((String)cmd, (String)cmd2);
    }

    @Test
    public void testMakeCommandLineWithFileParameters() {
        char fileSeparator = '/';
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_INPUT_FILES_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_OUTPUT_FILES_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "IN=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + '/' + INPUT_FILE_PARAMETER_VALUE;
        cmd = cmd + " ";
        cmd = cmd + "OUT=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + '/' + OUTPUT_FILE_PARAMETER_VALUE;
        cmd = cmd + " ))";
        FileParameterValue outputValue = new FileParameterValue(OUTPUT_FILE_PARAMETER_VALUE, TEXT_FILE_TYPE);
        OutputFileParameter outputFileParameter = new OutputFileParameter(OUTPUT_FILE_PARAMETER_NAME, OUTPUT_FILE_PARAMETER_LABEL, OUTPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        outputFileParameter.setValue(outputValue);
        FileParameterValue inputValue = new FileParameterValue(INPUT_FILE_PARAMETER_VALUE, TEXT_FILE_TYPE);
        InputFileParameter inputFileParameter = new InputFileParameter(INPUT_FILE_PARAMETER_NAME, INPUT_FILE_PARAMETER_LABEL, INPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        inputFileParameter.setValue((Object)inputValue);
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)inputFileParameter);
        group.addParameter((Parameter)outputFileParameter);
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        configurator.addGroup(group);
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, fileSeparator, PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        String cmd2 = configurator.makeCommandLine(context);
        Assert.assertEquals((String)cmd.toString(), (String)cmd2);
    }

    @Test
    public void testMakeCommandLineWithInputURLParameters() {
        String urlLocalParameterName = "URL_LOCAL";
        String urlLocalParameterValue = "/root/local.txt";
        String urlSGAParameterName = "URL_SGA";
        String urlSGAParameterValue = "/host_dir/sga_file.txt";
        String urlProjectParameterName = "URL_PROJECT";
        String urlProjectParameterValue = "/project_file.txt";
        String localization = "LOCALIZATION";
        char fileSeparator = '/';
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " ";
        cmd = cmd + urlProjectParameterName + "=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + urlProjectParameterValue;
        cmd = cmd + " ";
        cmd = cmd + localization + "=project";
        cmd = cmd + " ";
        cmd = cmd + urlLocalParameterName + "=" + urlLocalParameterValue;
        cmd = cmd + " ";
        cmd = cmd + localization + "=local";
        cmd = cmd + " ";
        cmd = cmd + urlSGAParameterName + "=" + urlSGAParameterValue;
        cmd = cmd + " ";
        cmd = cmd + localization + "=sga";
        cmd = cmd + " ))";
        URLValue urlProjectValue = new URLValue(urlProjectParameterValue, TEXT_FILE_TYPE);
        InputURLParameter urlProjectParameter = new InputURLParameter(urlProjectParameterName, urlProjectParameterName, urlProjectParameterName, urlProjectValue, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "LOCALIZATION", null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        URLValue urlLocalValue = new URLValue(urlLocalParameterValue, TEXT_FILE_TYPE, URLProtocol.LOCAL);
        InputURLParameter urlLocalParameter = new InputURLParameter(urlLocalParameterName, urlLocalParameterName, urlLocalParameterName, urlLocalValue, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "LOCALIZATION", null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        URLValue urlSGAValue = new URLValue(urlSGAParameterValue, TEXT_FILE_TYPE, URLProtocol.SGA, "sga-host");
        InputURLParameter urlSGAParameter = new InputURLParameter(urlSGAParameterName, urlSGAParameterName, urlSGAParameterName, urlSGAValue, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "LOCALIZATION", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)urlProjectParameter);
        group.addParameter((Parameter)urlLocalParameter);
        group.addParameter((Parameter)urlSGAParameter);
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        configurator.addGroup(group);
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, fileSeparator, PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        String cmd2 = configurator.makeCommandLine(context);
        Assert.assertEquals((String)cmd.toString(), (String)cmd2);
    }

    @Test
    public void testMakeCommandLineWithOutputURLParameters() {
        String urlLocalParameterName = "URL_LOCAL";
        String urlLocalParameterValue = "/root/local.txt";
        String urlSGAParameterName = "URL_SGA";
        String urlSGAParameterValue = "/host_dir/sga_file.txt";
        String urlProjectParameterName = "URL_PROJECT";
        String urlProjectParameterValue = "/project_file.txt";
        String localization = "LOCALIZATION";
        char fileSeparator = '/';
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " ";
        cmd = cmd + urlProjectParameterName + "=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + urlProjectParameterValue;
        cmd = cmd + " ";
        cmd = cmd + localization + "=project";
        cmd = cmd + " ";
        cmd = cmd + urlLocalParameterName + "=" + urlLocalParameterValue;
        cmd = cmd + " ";
        cmd = cmd + localization + "=local";
        cmd = cmd + " ";
        cmd = cmd + urlSGAParameterName + "=" + urlSGAParameterValue;
        cmd = cmd + " ";
        cmd = cmd + localization + "=sga";
        cmd = cmd + " ))";
        URLValue urlProjectValue = new URLValue(urlProjectParameterValue, TEXT_FILE_TYPE);
        OutputURLParameter urlProjectParameter = new OutputURLParameter(urlProjectParameterName, urlProjectParameterName, urlProjectParameterName, urlProjectValue, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "LOCALIZATION", null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        URLValue urlLocalValue = new URLValue(urlLocalParameterValue, TEXT_FILE_TYPE, URLProtocol.LOCAL);
        OutputURLParameter urlLocalParameter = new OutputURLParameter(urlLocalParameterName, urlLocalParameterName, urlLocalParameterName, urlLocalValue, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "LOCALIZATION", null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        URLValue urlSGAValue = new URLValue(urlSGAParameterValue, TEXT_FILE_TYPE, URLProtocol.SGA, "sga-host");
        OutputURLParameter urlSGAParameter = new OutputURLParameter(urlSGAParameterName, urlSGAParameterName, urlSGAParameterName, urlSGAValue, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "LOCALIZATION", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)urlProjectParameter);
        group.addParameter((Parameter)urlLocalParameter);
        group.addParameter((Parameter)urlSGAParameter);
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        configurator.addGroup(group);
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, fileSeparator, PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        String cmd2 = configurator.makeCommandLine(context);
        Assert.assertEquals((String)cmd.toString(), (String)cmd2);
    }

    @Test
    public void testMakeCommandLineWithOutputURLListParameters() {
        String urlLocalParameterName = "URL_LOCAL";
        String urlLocalParameterValue1 = "/root/local.txt";
        String urlLocalParameterValue2 = "/tmp/local.xml";
        String urlSGAParameterName = "URL_SGA";
        String urlSGAParameterValue1 = "/host_dir/sga_file.txt";
        String urlSGAParameterValue2 = "/host/out.xml";
        String urlProjectParameterName = "URL_PROJECT";
        String urlProjectParameterValue1 = "/project_file.txt";
        String urlProjectParameterValue2 = "/dir/input.xml";
        String localization = "LOCALIZATION";
        char fileSeparator = '/';
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " ";
        cmd = cmd + urlProjectParameterName + "=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + urlProjectParameterValue1 + "," + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + urlProjectParameterValue2;
        cmd = cmd + " ";
        cmd = cmd + localization + "=project";
        cmd = cmd + " ";
        cmd = cmd + urlLocalParameterName + "=" + urlLocalParameterValue1 + "," + urlLocalParameterValue2;
        cmd = cmd + " ";
        cmd = cmd + localization + "=local";
        cmd = cmd + " ";
        cmd = cmd + urlSGAParameterName + "=" + urlSGAParameterValue1 + "," + urlSGAParameterValue2;
        cmd = cmd + " ";
        cmd = cmd + localization + "=sga";
        cmd = cmd + " ))";
        ArrayList<URLValue> urlProjectValues = new ArrayList<URLValue>();
        URLValue urlProjectValue1 = new URLValue(urlProjectParameterValue1, TEXT_FILE_TYPE);
        URLValue urlProjectValue2 = new URLValue(urlProjectParameterValue2, TEXT_FILE_TYPE);
        urlProjectValues.add(urlProjectValue1);
        urlProjectValues.add(urlProjectValue2);
        OutputURLListParameter urlProjectParameter = new OutputURLListParameter(urlProjectParameterName, urlProjectParameterName, urlProjectParameterName, urlProjectValues, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "LOCALIZATION", null, FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        ArrayList<URLValue> urlLocalValues = new ArrayList<URLValue>();
        URLValue urlLocalValue1 = new URLValue(urlLocalParameterValue1, TEXT_FILE_TYPE, URLProtocol.LOCAL);
        URLValue urlLocalValue2 = new URLValue(urlLocalParameterValue2, TEXT_FILE_TYPE, URLProtocol.LOCAL);
        urlLocalValues.add(urlLocalValue1);
        urlLocalValues.add(urlLocalValue2);
        OutputURLListParameter urlLocalParameter = new OutputURLListParameter(urlLocalParameterName, urlLocalParameterName, urlLocalParameterName, urlLocalValues, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "LOCALIZATION", null, FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        ArrayList<URLValue> urlSGAValues = new ArrayList<URLValue>();
        URLValue urlSGAValue1 = new URLValue(urlSGAParameterValue1, TEXT_FILE_TYPE, URLProtocol.SGA, "sga-host");
        URLValue urlSGAValue2 = new URLValue(urlSGAParameterValue2, TEXT_FILE_TYPE, URLProtocol.SGA, "sga-host");
        urlSGAValues.add(urlSGAValue1);
        urlSGAValues.add(urlSGAValue2);
        OutputURLListParameter urlSGAParameter = new OutputURLListParameter(urlSGAParameterName, urlSGAParameterName, urlSGAParameterName, urlSGAValues, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "LOCALIZATION", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)urlProjectParameter);
        group.addParameter((Parameter)urlLocalParameter);
        group.addParameter((Parameter)urlSGAParameter);
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        configurator.addGroup(group);
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, fileSeparator, PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        String cmd2 = configurator.makeCommandLine(context);
        Assert.assertEquals((String)cmd.toString(), (String)cmd2);
    }

    @Test
    public void testMakeCommandLineWithInputURLListParameters() {
        String urlLocalParameterName = "URL_LOCAL";
        String urlLocalParameterValue1 = "/root/local.txt";
        String urlLocalParameterValue2 = "/tmp/local.xml";
        String urlSGAParameterName = "URL_SGA";
        String urlSGAParameterValue1 = "/host_dir/sga_file.txt";
        String urlSGAParameterValue2 = "/host/out.xml";
        String urlProjectParameterName = "URL_PROJECT";
        String urlProjectParameterValue1 = "/project_file.txt";
        String urlProjectParameterValue2 = "/dir/input.xml";
        String localization = "LOCALIZATION";
        char fileSeparator = '/';
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " ";
        cmd = cmd + urlProjectParameterName + "=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + urlProjectParameterValue1 + "," + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + urlProjectParameterValue2;
        cmd = cmd + " ";
        cmd = cmd + localization + "=project";
        cmd = cmd + " ";
        cmd = cmd + urlLocalParameterName + "=" + urlLocalParameterValue1 + "," + urlLocalParameterValue2;
        cmd = cmd + " ";
        cmd = cmd + localization + "=local";
        cmd = cmd + " ";
        cmd = cmd + urlSGAParameterName + "=" + urlSGAParameterValue1 + "," + urlSGAParameterValue2;
        cmd = cmd + " ";
        cmd = cmd + localization + "=sga";
        cmd = cmd + " ))";
        ArrayList<URLValue> urlProjectValues = new ArrayList<URLValue>();
        URLValue urlProjectValue1 = new URLValue(urlProjectParameterValue1, TEXT_FILE_TYPE);
        URLValue urlProjectValue2 = new URLValue(urlProjectParameterValue2, TEXT_FILE_TYPE);
        urlProjectValues.add(urlProjectValue1);
        urlProjectValues.add(urlProjectValue2);
        InputURLListParameter urlProjectParameter = new InputURLListParameter(urlProjectParameterName, urlProjectParameterName, urlProjectParameterName, urlProjectValues, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "LOCALIZATION", null, FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        ArrayList<URLValue> urlLocalValues = new ArrayList<URLValue>();
        URLValue urlLocalValue1 = new URLValue(urlLocalParameterValue1, TEXT_FILE_TYPE, URLProtocol.LOCAL);
        URLValue urlLocalValue2 = new URLValue(urlLocalParameterValue2, TEXT_FILE_TYPE, URLProtocol.LOCAL);
        urlLocalValues.add(urlLocalValue1);
        urlLocalValues.add(urlLocalValue2);
        InputURLListParameter urlLocalParameter = new InputURLListParameter(urlLocalParameterName, urlLocalParameterName, urlLocalParameterName, urlLocalValues, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "LOCALIZATION", null, FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        ArrayList<URLValue> urlSGAValues = new ArrayList<URLValue>();
        URLValue urlSGAValue1 = new URLValue(urlSGAParameterValue1, TEXT_FILE_TYPE, URLProtocol.SGA, "sga-host");
        URLValue urlSGAValue2 = new URLValue(urlSGAParameterValue2, TEXT_FILE_TYPE, URLProtocol.SGA, "sga-host");
        urlSGAValues.add(urlSGAValue1);
        urlSGAValues.add(urlSGAValue2);
        InputURLListParameter urlSGAParameter = new InputURLListParameter(urlSGAParameterName, urlSGAParameterName, urlSGAParameterName, urlSGAValues, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "LOCALIZATION", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)urlProjectParameter);
        group.addParameter((Parameter)urlLocalParameter);
        group.addParameter((Parameter)urlSGAParameter);
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        configurator.addGroup(group);
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, fileSeparator, PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        String cmd2 = configurator.makeCommandLine(context);
        Assert.assertEquals((String)cmd.toString(), (String)cmd2);
    }

    @Test
    public void testMakeCommandLineWithHiddenParameter() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        HiddenParameter parameter1 = new HiddenParameter("PARAM_1", "VALOR_1", "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        configurator.addHiddenParameter(parameter1);
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND + " PARAM_1=VALOR_1";
        cmd = cmd + " ))";
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, '/', PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        String cmd2 = configurator.makeCommandLine(context);
        Assert.assertEquals((String)cmd, (String)cmd2);
    }

    @Test
    public void testMakeCommandLineWithCommandLineFormat() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        TextParameter textParameter1 = new TextParameter("Nome1", "R\u00f3tulo1", "Descri\u00e7\u00e3o1", "Valor1", false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null);
        TextParameter textParameter2 = new TextParameter("Nome2", "R\u00f3tulo2", "Descri\u00e7\u00e3o2", "Valor2", false, true, null, null);
        TextParameter textParameter3 = new TextParameter("Nome3", "R\u00f3tulo3", "Descri\u00e7\u00e3o3", "Valor3", false, true, "--$NOME_DO_PARAMETRO [$VALOR_DO_PARAMETRO]", null);
        TextParameter textParameter4 = new TextParameter("Nome4", "R\u00f3tulo4", "Descri\u00e7\u00e3o4", "Valor4", false, true, "-$NOME_DO_PARAMETRO", null);
        TextParameter textParameter5 = new TextParameter("Nome5", "R\u00f3tulo5", "Descri\u00e7\u00e3o5", "Valor5", false, true, "($VALOR_DO_PARAMETRO)", null);
        group.addParameter((Parameter)textParameter1);
        group.addParameter((Parameter)textParameter2);
        group.addParameter((Parameter)textParameter3);
        group.addParameter((Parameter)textParameter4);
        group.addParameter((Parameter)textParameter5);
        configurator.addGroup(group);
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "Nome1=Valor1";
        cmd = cmd + " ";
        cmd = cmd + "--Nome3 [Valor3]";
        cmd = cmd + " ";
        cmd = cmd + "-Nome4";
        cmd = cmd + " ";
        cmd = cmd + "(Valor5)";
        cmd = cmd + " ))";
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, '/', PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, null);
        Assert.assertEquals((String)cmd, (String)configurator.makeCommandLine(context));
    }

    @Test
    public void testMakeCommandLineWithClientHost() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, true, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        String cmd = "";
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + " ";
        cmd = cmd + EXPORT_CLIENT_HOST;
        cmd = cmd + " ";
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " ";
        cmd = cmd + "cmdId=USR@TEST";
        cmd = cmd + " ))";
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, '/', PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, false, null, TEST_CLIENT);
        String cmd2 = configurator.makeCommandLine(context);
        Assert.assertEquals((String)cmd, (String)cmd2);
    }

    @Test
    public void testMakeCommandLineaAsScriptWithClientHost() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        String cmd = "";
        cmd = cmd + "#! /bin/ksh";
        cmd = cmd + LINE_SEPARATOR;
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + LINE_SEPARATOR;
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + LINE_SEPARATOR;
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + LINE_SEPARATOR;
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + LINE_SEPARATOR;
        cmd = cmd + EXPORT_CLIENT_HOST;
        cmd = cmd + LINE_SEPARATOR;
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " ))";
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, '/', PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, true, null, TEST_CLIENT);
        CommandScript[] script = configurator.makeCommandLineAsScript(context);
        Assert.assertEquals((int)1, (int)script.length);
        Assert.assertEquals((String)cmd, (String)script[0].getScriptContent());
        Assert.assertEquals((String)"script", (String)script[0].getFileName());
    }

    @Test
    public void testMakeCommandLineAsScript() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        String cmd = "";
        cmd = cmd + "#! /bin/ksh";
        cmd = cmd + LINE_SEPARATOR;
        cmd = cmd + EXPORT_BIN_VAR_UNIX;
        cmd = cmd + LINE_SEPARATOR;
        cmd = cmd + EXPORT_PROJ_VAR_UNIX;
        cmd = cmd + LINE_SEPARATOR;
        cmd = cmd + EXPORT_SANDBOX_VAR_UNIX;
        cmd = cmd + LINE_SEPARATOR;
        cmd = cmd + EXPORT_EXECUTION_VAR_BIN;
        cmd = cmd + LINE_SEPARATOR;
        cmd = cmd + "( ";
        cmd = cmd + CD_TO_EXECUTION_DIR_COMMAND;
        cmd = cmd + " ( " + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.BINARY_DIR) + '/' + COMMAND;
        cmd = cmd + " ))";
        CommandLineContext context = new CommandLineContext(COMMAND_ID, PLATFORM_ID, '/', PROJECT_DIR_UNIX, ALGORITHM_REPOSITORY_DIR, PROJECT_REPOSITORY_DIR, SANDBOX_ROOT_PATH_UNIX, SANDBOX_PATH, FULL_CMD_DIR_PATH_UNIX, true, null, null);
        CommandScript[] script = configurator.makeCommandLineAsScript(context);
        Assert.assertEquals((int)1, (int)script.length);
        Assert.assertEquals((String)cmd, (String)script[0].getScriptContent());
        Assert.assertEquals((String)"script", (String)script[0].getFileName());
    }

    @Test
    public void testGetInputFilesWithNoInputFileParameter() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        Assert.assertNotNull((Object)configurator.getInputFiles());
        Assert.assertTrue((boolean)configurator.getInputFiles().isEmpty());
    }

    @Test
    public void testGetInputFilesWithEmptyFileParameter() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        InputFileParameter inputFileParameter = new InputFileParameter(INPUT_FILE_PARAMETER_NAME, INPUT_FILE_PARAMETER_LABEL, INPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)inputFileParameter);
        configurator.addGroup(group);
        Assert.assertNotNull((Object)configurator.getInputFiles());
        Assert.assertTrue((boolean)configurator.getInputFiles().isEmpty());
    }

    @Test
    public void testGetInputFilesWithDirectoryParameterValue() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        InputFileParameter inputFileParameter = new InputFileParameter(INPUT_FILE_PARAMETER_NAME, INPUT_FILE_PARAMETER_LABEL, INPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        inputFileParameter.setValue((Object)new FileParameterValue(DIR_NAME, "DIRECTORY_TYPE"));
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)inputFileParameter);
        configurator.addGroup(group);
        Assert.assertNotNull((Object)configurator.getInputFiles());
        Assert.assertTrue((boolean)configurator.getInputFiles().isEmpty());
    }

    @Test
    public void testGetInputFilesWithFileParameterValue() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        InputFileParameter inputFileParameter = new InputFileParameter(INPUT_FILE_PARAMETER_NAME, INPUT_FILE_PARAMETER_LABEL, INPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        HashSet<FileParameterValue> inputFiles = new HashSet<FileParameterValue>();
        FileParameterValue file = new FileParameterValue(TEXT_FILE_NAME, TEXT_FILE_TYPE);
        inputFiles.add(file);
        inputFileParameter.setValue((Object)file);
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)inputFileParameter);
        configurator.addGroup(group);
        Assert.assertEquals(inputFiles, (Object)configurator.getInputFiles());
    }

    @Test
    public void testGetInputFilesWithEmptyFileListParameter() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        InputFileListParameter inputFileListParameter = new InputFileListParameter(INPUT_FILE_PARAMETER_NAME, INPUT_FILE_PARAMETER_LABEL, INPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, true, true);
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)inputFileListParameter);
        configurator.addGroup(group);
        Assert.assertNotNull((Object)configurator.getInputFiles());
        Assert.assertTrue((boolean)configurator.getInputFiles().isEmpty());
    }

    @Test
    public void testGetInputFilesWithMultipleFilesInFileListParameter() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        InputFileListParameter inputFileListParameter = new InputFileListParameter(INPUT_FILE_PARAMETER_NAME, INPUT_FILE_PARAMETER_LABEL, INPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, true, true);
        FileParameterValue file1 = new FileParameterValue("arquivo1");
        FileParameterValue file2 = new FileParameterValue("arquivo2");
        inputFileListParameter.addElement((Object)file1);
        inputFileListParameter.addElement((Object)file2);
        HashSet<FileParameterValue> files = new HashSet<FileParameterValue>();
        files.add(file1);
        files.add(file2);
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)inputFileListParameter);
        configurator.addGroup(group);
        Assert.assertEquals(files, (Object)configurator.getInputFiles());
    }

    @Test
    public void testGetInputFilesWithFilesAndDirectoriesInFileListParameter() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        InputFileListParameter inputFileListParameter = new InputFileListParameter(INPUT_FILE_PARAMETER_NAME, INPUT_FILE_PARAMETER_LABEL, INPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, true, true);
        FileParameterValue file1 = new FileParameterValue("arquivo1");
        FileParameterValue file2 = new FileParameterValue("arquivo2");
        FileParameterValue directory = new FileParameterValue(DIR_NAME, "DIRECTORY_TYPE");
        inputFileListParameter.addElement((Object)file1);
        inputFileListParameter.addElement((Object)file2);
        inputFileListParameter.addElement((Object)directory);
        HashSet<FileParameterValue> files = new HashSet<FileParameterValue>();
        files.add(file1);
        files.add(file2);
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)inputFileListParameter);
        configurator.addGroup(group);
        Assert.assertEquals(files, (Object)configurator.getInputFiles());
    }

    @Test
    public void testGetInputFilesWithDirectoriesInFileListParameter() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        InputFileListParameter inputFileListParameter = new InputFileListParameter(INPUT_FILE_PARAMETER_NAME, INPUT_FILE_PARAMETER_LABEL, INPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, true, false);
        FileParameterValue directory1 = new FileParameterValue("diretorio1", "DIRECTORY_TYPE");
        FileParameterValue directory2 = new FileParameterValue("diretorio2", "DIRECTORY_TYPE");
        inputFileListParameter.addElement((Object)directory1);
        inputFileListParameter.addElement((Object)directory2);
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)inputFileListParameter);
        configurator.addGroup(group);
        Assert.assertNotNull((Object)configurator.getInputFiles());
        Assert.assertTrue((boolean)configurator.getInputFiles().isEmpty());
    }

    @Test
    public void testGetOutputFilesWithNoOutputFileParameter() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        Assert.assertNotNull((Object)configurator.getOutputFiles());
        Assert.assertTrue((boolean)configurator.getOutputFiles().isEmpty());
    }

    @Test
    public void testGetOutputFilesWithEmptyFileParameter() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        OutputFileParameter outputFileParameter = new OutputFileParameter(OUTPUT_FILE_PARAMETER_NAME, OUTPUT_FILE_PARAMETER_LABEL, OUTPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)outputFileParameter);
        configurator.addGroup(group);
        Assert.assertNotNull((Object)configurator.getOutputFiles());
        Assert.assertTrue((boolean)configurator.getOutputFiles().isEmpty());
    }

    @Test
    public void testGetOutputFilesWithDirectoryParameterValue() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        OutputFileParameter outputFileParameter = new OutputFileParameter(OUTPUT_FILE_PARAMETER_NAME, OUTPUT_FILE_PARAMETER_LABEL, OUTPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        outputFileParameter.setValue(new FileParameterValue(DIR_NAME, "DIRECTORY_TYPE"));
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)outputFileParameter);
        configurator.addGroup(group);
        Assert.assertNotNull((Object)configurator.getOutputFiles());
        Assert.assertTrue((boolean)configurator.getOutputFiles().isEmpty());
    }

    @Test
    public void testGetOutputFilesWithFileParameterValue() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        OutputFileParameter outputFileParameter = new OutputFileParameter(OUTPUT_FILE_PARAMETER_NAME, OUTPUT_FILE_PARAMETER_LABEL, OUTPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        HashSet<FileParameterValue> outputFiles = new HashSet<FileParameterValue>();
        FileParameterValue file = new FileParameterValue(TEXT_FILE_NAME, TEXT_FILE_TYPE);
        outputFiles.add(file);
        outputFileParameter.setValue(file);
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)outputFileParameter);
        configurator.addGroup(group);
        Assert.assertEquals(outputFiles, (Object)configurator.getOutputFiles());
    }

    @Test
    public void testGetDirectoriesWithNoFileParameters() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        Assert.assertNotNull((Object)configurator.getInputDirectories());
        Assert.assertNotNull((Object)configurator.getOutputDirectories());
        Assert.assertTrue((boolean)configurator.getInputDirectories().isEmpty());
        Assert.assertTrue((boolean)configurator.getOutputDirectories().isEmpty());
    }

    @Test
    public void testGetDirectoriesWithEmptyFileParameters() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        InputFileParameter inputFileParameter = new InputFileParameter(INPUT_FILE_PARAMETER_NAME, INPUT_FILE_PARAMETER_LABEL, INPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        OutputFileParameter outputFileParameter = new OutputFileParameter(OUTPUT_FILE_PARAMETER_NAME, OUTPUT_FILE_PARAMETER_LABEL, OUTPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.DIRECTORY, FileParameterPipeAcceptance.TRUE, false, false);
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)inputFileParameter);
        group.addParameter((Parameter)outputFileParameter);
        configurator.addGroup(group);
        Assert.assertNotNull((Object)configurator.getInputDirectories());
        Assert.assertTrue((boolean)configurator.getInputDirectories().isEmpty());
        Assert.assertNotNull((Object)configurator.getOutputDirectories());
        Assert.assertTrue((boolean)configurator.getOutputDirectories().isEmpty());
    }

    @Test
    public void testGetDirectoriesWithFileParameterValues() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        InputFileParameter inputFileParameter = new InputFileParameter(INPUT_FILE_PARAMETER_NAME, INPUT_FILE_PARAMETER_LABEL, INPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        FileParameterValue inputFile = new FileParameterValue("entrada.txt", TEXT_FILE_TYPE);
        inputFileParameter.setValue((Object)inputFile);
        OutputFileParameter outputFileParameter = new OutputFileParameter(OUTPUT_FILE_PARAMETER_NAME, OUTPUT_FILE_PARAMETER_LABEL, OUTPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.DIRECTORY, FileParameterPipeAcceptance.TRUE, false, false);
        FileParameterValue outputFile = new FileParameterValue("saida.txt", TEXT_FILE_TYPE);
        outputFileParameter.setValue(outputFile);
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)inputFileParameter);
        group.addParameter((Parameter)outputFileParameter);
        configurator.addGroup(group);
        Assert.assertNotNull((Object)configurator.getInputDirectories());
        Assert.assertTrue((boolean)configurator.getInputDirectories().isEmpty());
        Assert.assertNotNull((Object)configurator.getOutputDirectories());
        Assert.assertTrue((boolean)configurator.getOutputDirectories().isEmpty());
    }

    @Test
    public void testGetDirectoriesWithDirectoryParameterValues() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        InputFileParameter inputFileParameter = new InputFileParameter(INPUT_FILE_PARAMETER_NAME, INPUT_FILE_PARAMETER_LABEL, INPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        FileParameterValue inputFile = new FileParameterValue("entrada", "DIRECTORY_TYPE");
        inputFileParameter.setValue((Object)inputFile);
        OutputFileParameter outputFileParameter = new OutputFileParameter(OUTPUT_FILE_PARAMETER_NAME, OUTPUT_FILE_PARAMETER_LABEL, OUTPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.DIRECTORY, FileParameterPipeAcceptance.TRUE, false, false);
        FileParameterValue outputFile = new FileParameterValue("saida", "DIRECTORY_TYPE");
        outputFileParameter.setValue(outputFile);
        HashSet<FileParameterValue> inputDirs = new HashSet<FileParameterValue>();
        inputDirs.add(inputFile);
        HashSet<FileParameterValue> outputDirs = new HashSet<FileParameterValue>();
        outputDirs.add(outputFile);
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)inputFileParameter);
        group.addParameter((Parameter)outputFileParameter);
        configurator.addGroup(group);
        Assert.assertEquals(inputDirs, (Object)configurator.getInputDirectories());
        Assert.assertEquals(outputDirs, (Object)configurator.getOutputDirectories());
    }

    @Test
    public void testGetDirectoriesWithEmptyFileListParameter() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        InputFileListParameter inputFileListParameter = new InputFileListParameter(INPUT_FILE_PARAMETER_NAME, INPUT_FILE_PARAMETER_LABEL, INPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, true, false);
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)inputFileListParameter);
        configurator.addGroup(group);
        Assert.assertNotNull((Object)configurator.getInputDirectories());
        Assert.assertTrue((boolean)configurator.getInputDirectories().isEmpty());
        Assert.assertNotNull((Object)configurator.getOutputDirectories());
        Assert.assertTrue((boolean)configurator.getOutputDirectories().isEmpty());
    }

    @Test
    public void testGetDirectoriesWithMultipleFilesInFileListParameter() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        InputFileListParameter inputFileListParameter = new InputFileListParameter(INPUT_FILE_PARAMETER_NAME, INPUT_FILE_PARAMETER_LABEL, INPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, true, false);
        FileParameterValue file1 = new FileParameterValue("arquivo1");
        FileParameterValue file2 = new FileParameterValue("arquivo2");
        inputFileListParameter.addElement((Object)file1);
        inputFileListParameter.addElement((Object)file2);
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)inputFileListParameter);
        configurator.addGroup(group);
        Assert.assertNotNull((Object)configurator.getInputDirectories());
        Assert.assertTrue((boolean)configurator.getInputDirectories().isEmpty());
    }

    @Test
    public void testGetDirectoriesWithFilesAndDirectoriesInFileListParameter() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        InputFileListParameter inputFileListParameter = new InputFileListParameter(INPUT_FILE_PARAMETER_NAME, INPUT_FILE_PARAMETER_LABEL, INPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, true, false);
        FileParameterValue file1 = new FileParameterValue("arquivo1");
        FileParameterValue file2 = new FileParameterValue("arquivo2");
        FileParameterValue directory1 = new FileParameterValue("diretorio1", "DIRECTORY_TYPE");
        FileParameterValue directory2 = new FileParameterValue("diretorio2", "DIRECTORY_TYPE");
        inputFileListParameter.addElement((Object)file1);
        inputFileListParameter.addElement((Object)file2);
        inputFileListParameter.addElement((Object)directory1);
        inputFileListParameter.addElement((Object)directory2);
        HashSet<FileParameterValue> files = new HashSet<FileParameterValue>();
        files.add(directory1);
        files.add(directory2);
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)inputFileListParameter);
        configurator.addGroup(group);
        Assert.assertEquals(files, (Object)configurator.getInputDirectories());
    }

    @Test
    public void testGetDirectoriesWithDirectoriesInFileListParameter() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        InputFileListParameter inputFileListParameter = new InputFileListParameter(INPUT_FILE_PARAMETER_NAME, INPUT_FILE_PARAMETER_LABEL, INPUT_FILE_PARAMETER_LABEL, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, true, false);
        FileParameterValue directory1 = new FileParameterValue("diretorio1", "DIRECTORY_TYPE");
        FileParameterValue directory2 = new FileParameterValue("diretorio2", "DIRECTORY_TYPE");
        inputFileListParameter.addElement((Object)directory1);
        inputFileListParameter.addElement((Object)directory2);
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        group.addParameter((Parameter)inputFileListParameter);
        configurator.addGroup(group);
        HashSet<FileParameterValue> files = new HashSet<FileParameterValue>();
        files.add(directory1);
        files.add(directory2);
        Assert.assertEquals(files, (Object)configurator.getInputDirectories());
    }

    @Test
    public void testGetBinaryDirectoriesWithUnixDirectory() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        Set actualBinaryDirectories = configurator.getBinaryDirectories(PLATFORM_ID, '/');
        TreeSet<String> expectedBinaryDirectories = new TreeSet<String>();
        expectedBinaryDirectories.add(ALGORITHM_DIR_UNIX);
        Assert.assertEquals(expectedBinaryDirectories, (Object)actualBinaryDirectories);
    }

    @Test
    public void testGetBinaryDirectoriesWithWindowsDirectory() {
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(this.createAlgorithmVersion(), null, ExecutionType.MULTIPLE, BINARY_DIR_EXECUTION, null, false, COMMAND, null, null, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        TreeSet<String> expectedBinaryDirectories = new TreeSet<String>();
        expectedBinaryDirectories.add(ALGORITHM_DIR_WINDOWS);
        Set actualBinaryDirectories = configurator.getBinaryDirectories(PLATFORM_ID, '\\');
        Assert.assertEquals(expectedBinaryDirectories, (Object)actualBinaryDirectories);
    }

    @Test
    public void testParameterSetInvisible() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        MockSimpleParameter parameter = new MockSimpleParameter(PARAM_NAME, PARAM_LABEL, "Descri\u00e7\u00e3o", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        group.addParameter((Parameter)parameter);
        CheckAlgorithmConfiguratorListener listener = new CheckAlgorithmConfiguratorListener();
        listener.allowParameterWasSetVisible();
        configurator.addGroup(group);
        configurator.addAlgorithmConfiguratorListener((AlgorithmConfiguratorListener)listener);
        parameter.setVisible(false);
        Assert.assertTrue((boolean)listener.parameterWasSetVisible());
        Assert.assertEquals((int)1, (int)listener.getEventCount());
    }

    @Test
    public void testParameterWasSetVisible() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        MockSimpleParameter parameter = new MockSimpleParameter(PARAM_NAME, PARAM_LABEL, "Descri\u00e7\u00e3o", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        parameter.setVisible(false);
        group.addParameter((Parameter)parameter);
        CheckAlgorithmConfiguratorListener listener = new CheckAlgorithmConfiguratorListener();
        listener.allowParameterWasSetVisible();
        configurator.addGroup(group);
        configurator.addAlgorithmConfiguratorListener((AlgorithmConfiguratorListener)listener);
        parameter.setVisible(true);
        Assert.assertTrue((boolean)listener.parameterWasSetVisible());
        Assert.assertEquals((int)1, (int)listener.getEventCount());
    }

    @Test
    public void testParameterWasDisabled() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        MockSimpleParameter parameter = new MockSimpleParameter(PARAM_NAME, PARAM_LABEL, "Descri\u00e7\u00e3o", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        group.addParameter((Parameter)parameter);
        CheckAlgorithmConfiguratorListener listener = new CheckAlgorithmConfiguratorListener();
        listener.allowParameterWasSetEnabled();
        configurator.addGroup(group);
        configurator.addAlgorithmConfiguratorListener((AlgorithmConfiguratorListener)listener);
        parameter.setEnabled(false);
        Assert.assertTrue((boolean)listener.parameterWasSetEnabled());
        Assert.assertEquals((int)1, (int)listener.getEventCount());
    }

    @Test
    public void testParameterWasEnabled() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup(GROUP_PARAM_NAME);
        MockSimpleParameter parameter = new MockSimpleParameter(PARAM_NAME, PARAM_LABEL, "Descri\u00e7\u00e3o", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
        parameter.setEnabled(false);
        group.addParameter((Parameter)parameter);
        CheckAlgorithmConfiguratorListener listener = new CheckAlgorithmConfiguratorListener();
        listener.allowParameterWasSetEnabled();
        configurator.addGroup(group);
        configurator.addAlgorithmConfiguratorListener((AlgorithmConfiguratorListener)listener);
        parameter.setEnabled(true);
        Assert.assertTrue((boolean)listener.parameterWasSetEnabled());
        Assert.assertEquals((int)1, (int)listener.getEventCount());
    }

    private SimpleAlgorithmConfigurator createAlgorithmConfigurator() {
        AlgorithmVersionInfo algorithmVersionInfo = this.createAlgorithmVersion();
        String abbreviation = null;
        String shell = null;
        String inputFileParameterName = null;
        return new SimpleAlgorithmConfigurator(algorithmVersionInfo, "Descri\u00e7\u00e3o", SIMPLE_EXECUTION, BINARY_DIR_EXECUTION, abbreviation, false, COMMAND, shell, inputFileParameterName, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
    }

    private AlgorithmVersionInfo createAlgorithmVersion() {
        String algorithmName = "Algoritmo";
        int major = 1;
        int minor = 2;
        int patch = 3;
        AlgorithmVersionInfo algorithmVersionInfo = this.createAlgorithmVersion(algorithmName, major, minor, patch);
        return algorithmVersionInfo;
    }

    private AlgorithmVersionInfo createAlgorithmVersion(String algorithmName, int major, int minor, int patch) {
        AlgorithmInfo algorithmInfo = new AlgorithmInfo("ID " + algorithmName, algorithmName, "DIR_" + algorithmName, ALGORITHM_REPOSITORY_DIR, new Hashtable());
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(major, minor, patch);
        AlgorithmVersionInfo algorithmVersionInfo = new AlgorithmVersionInfo(algorithmInfo, algorithmVersionId, new Hashtable(), new Hashtable());
        return algorithmVersionInfo;
    }
}

