/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.TableParameterParser;
import java.util.List;
import junit.framework.TestCase;
import tecgraf.javautils.parsers.exception.AutomatonException;

public final class TableParameterParserTest
extends TestCase {
    public void testParseTextWithoutLines() throws AutomatonException {
        TableParameterParser parser = new TableParameterParser();
        List elementRowsList = parser.parseText("{}");
        TableParameterParserTest.assertNotNull((Object)elementRowsList);
        TableParameterParserTest.assertTrue((boolean)elementRowsList.isEmpty());
    }

    public void testParseTextWithElements() throws AutomatonException {
        TableParameterParser parser = new TableParameterParser();
        List elementRowsList = parser.parseText("{{1,2},{3,4,5},{6,7,8,9}}");
        TableParameterParserTest.assertNotNull((Object)elementRowsList);
        TableParameterParserTest.assertEquals((int)3, (int)elementRowsList.size());
        List elements1 = (List)elementRowsList.get(0);
        TableParameterParserTest.assertEquals((int)2, (int)elements1.size());
        TableParameterParserTest.assertEquals((String)"1", (String)((String)elements1.get(0)));
        TableParameterParserTest.assertEquals((String)"2", (String)((String)elements1.get(1)));
        List elements2 = (List)elementRowsList.get(1);
        TableParameterParserTest.assertEquals((int)3, (int)elements2.size());
        TableParameterParserTest.assertEquals((String)"3", (String)((String)elements2.get(0)));
        TableParameterParserTest.assertEquals((String)"4", (String)((String)elements2.get(1)));
        TableParameterParserTest.assertEquals((String)"5", (String)((String)elements2.get(2)));
        List elements3 = (List)elementRowsList.get(2);
        TableParameterParserTest.assertEquals((int)4, (int)elements3.size());
        TableParameterParserTest.assertEquals((String)"6", (String)((String)elements3.get(0)));
        TableParameterParserTest.assertEquals((String)"7", (String)((String)elements3.get(1)));
        TableParameterParserTest.assertEquals((String)"8", (String)((String)elements3.get(2)));
        TableParameterParserTest.assertEquals((String)"9", (String)((String)elements3.get(3)));
    }

    public void testParseTextWithEmptyCells() throws AutomatonException {
        TableParameterParser parser = new TableParameterParser();
        List elementRowsList = parser.parseText("{{1,},{,4,5},{6,,8,9}}");
        TableParameterParserTest.assertNotNull((Object)elementRowsList);
        TableParameterParserTest.assertEquals((int)3, (int)elementRowsList.size());
        List elements1 = (List)elementRowsList.get(0);
        TableParameterParserTest.assertEquals((int)2, (int)elements1.size());
        TableParameterParserTest.assertEquals((String)"1", (String)((String)elements1.get(0)));
        TableParameterParserTest.assertEquals(null, (String)((String)elements1.get(1)));
        List elements2 = (List)elementRowsList.get(1);
        TableParameterParserTest.assertEquals((int)3, (int)elements2.size());
        TableParameterParserTest.assertEquals(null, (String)((String)elements2.get(0)));
        TableParameterParserTest.assertEquals((String)"4", (String)((String)elements2.get(1)));
        TableParameterParserTest.assertEquals((String)"5", (String)((String)elements2.get(2)));
        List elements3 = (List)elementRowsList.get(2);
        TableParameterParserTest.assertEquals((int)4, (int)elements3.size());
        TableParameterParserTest.assertEquals((String)"6", (String)((String)elements3.get(0)));
        TableParameterParserTest.assertEquals(null, (String)((String)elements3.get(1)));
        TableParameterParserTest.assertEquals((String)"8", (String)((String)elements3.get(2)));
        TableParameterParserTest.assertEquals((String)"9", (String)((String)elements3.get(3)));
    }
}

