/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.CheckParameterListener;
import csbase.logic.algorithms.parameters.CheckTableParameterListener;
import csbase.logic.algorithms.parameters.Column;
import csbase.logic.algorithms.parameters.MockColumn;
import csbase.logic.algorithms.parameters.MockTableParameterListener;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parameters.TableParameterListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class TableParameterTest {
    @Test
    public void testTableParameter1() {
        String name = "Nome_do_parametro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        List<MockColumn> columns = this.createMockColumns();
        boolean delimitTable = false;
        boolean delimitRows = false;
        int rowCount = 10;
        TableParameter parameter = new TableParameter(name, label, description, isOptional, true, commandLinePattern, columns, delimitTable, delimitRows, Integer.valueOf(rowCount), null, null, null);
        boolean hasFixedRowCount = true;
        this.assertEquals(name, label, description, isOptional, commandLinePattern, columns, delimitTable, delimitRows, rowCount, hasFixedRowCount, parameter);
    }

    @Test
    public void testTableParameter2() {
        String name = "Nome_do_parametro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        List<MockColumn> columns = this.createMockColumns();
        boolean delimitTable = false;
        boolean delimitRows = false;
        int rowCount = 10;
        TableParameter parameter = new TableParameter(name, label, description, isOptional, true, commandLinePattern, columns, delimitTable, delimitRows, Integer.valueOf(rowCount), null, null, null);
        boolean hasFixedRowCount = true;
        this.assertEquals(name, label, description, isOptional, commandLinePattern, columns, delimitTable, delimitRows, rowCount, hasFixedRowCount, parameter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTableParameter3() {
        String name = null;
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        List<MockColumn> columns = this.createMockColumns();
        boolean delimitTable = false;
        boolean delimitRows = false;
        int rowCount = 10;
        new TableParameter(name, label, description, isOptional, true, commandLinePattern, columns, delimitTable, delimitRows, Integer.valueOf(rowCount), null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTableParameter4() {
        String name = "Nome_do_parametro";
        String label = null;
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        List<MockColumn> columns = this.createMockColumns();
        boolean delimitTable = false;
        boolean delimitRows = false;
        int rowCount = 10;
        new TableParameter(name, label, description, isOptional, true, commandLinePattern, columns, delimitTable, delimitRows, Integer.valueOf(rowCount), null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTableParameter5() {
        String name = "Nome_do_parametro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = null;
        boolean isOptional = true;
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        List<MockColumn> columns = this.createMockColumns();
        boolean delimitTable = false;
        boolean delimitRows = false;
        int rowCount = 10;
        new TableParameter(name, label, description, isOptional, true, commandLinePattern, columns, delimitTable, delimitRows, Integer.valueOf(rowCount), null, null, null);
    }

    @Test
    public void testTableParameter6() {
        String name = "Nome_do_parametro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = null;
        List<MockColumn> columns = this.createMockColumns();
        boolean delimitTable = false;
        boolean delimitRows = false;
        int rowCount = 10;
        TableParameter parameter = new TableParameter(name, label, description, isOptional, true, commandLinePattern, columns, delimitTable, delimitRows, Integer.valueOf(rowCount), null, null, null);
        boolean hasFixedRowCount = true;
        this.assertEquals(name, label, description, isOptional, commandLinePattern, columns, delimitTable, delimitRows, rowCount, hasFixedRowCount, parameter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTableParameter7() {
        String name = "Nome_do_parametro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = null;
        boolean isOptional = true;
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        List columns = null;
        boolean delimitTable = false;
        boolean delimitRows = false;
        int rowCount = 10;
        new TableParameter(name, label, description, isOptional, true, commandLinePattern, columns, delimitTable, delimitRows, Integer.valueOf(rowCount), null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTableParameter8() {
        String name = "Nome_do_parametro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = null;
        boolean isOptional = true;
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        LinkedList columns = new LinkedList();
        boolean delimitTable = false;
        boolean delimitRows = false;
        int rowCount = 10;
        new TableParameter(name, label, description, isOptional, true, commandLinePattern, columns, delimitTable, delimitRows, Integer.valueOf(rowCount), null, null, null);
    }

    @Test
    public void testTableParameter9() {
        String name = "Nome_do_parametro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        List<MockColumn> columns = this.createMockColumns();
        boolean delimitTable = true;
        boolean delimitRows = false;
        int rowCount = 10;
        TableParameter parameter = new TableParameter(name, label, description, isOptional, true, commandLinePattern, columns, delimitTable, delimitRows, Integer.valueOf(rowCount), null, null, null);
        boolean hasFixedRowCount = true;
        this.assertEquals(name, label, description, isOptional, commandLinePattern, columns, delimitTable, delimitRows, rowCount, hasFixedRowCount, parameter);
    }

    @Test
    public void testTableParameter10() {
        String name = "Nome_do_parametro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        List<MockColumn> columns = this.createMockColumns();
        boolean delimitTable = false;
        boolean delimitRows = true;
        int rowCount = 10;
        TableParameter parameter = new TableParameter(name, label, description, isOptional, true, commandLinePattern, columns, delimitTable, delimitRows, Integer.valueOf(rowCount), null, null, null);
        boolean hasFixedRowCount = true;
        this.assertEquals(name, label, description, isOptional, commandLinePattern, columns, delimitTable, delimitRows, rowCount, hasFixedRowCount, parameter);
    }

    @Test
    public void testTableParameter11() {
        String name = "Nome_do_parametro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        List<MockColumn> columns = this.createMockColumns();
        boolean delimitTable = false;
        boolean delimitRows = false;
        Integer rowCount = null;
        TableParameter parameter = new TableParameter(name, label, description, isOptional, true, commandLinePattern, columns, delimitTable, delimitRows, rowCount, null, null, null);
        boolean hasFixedRowCount = false;
        this.assertEquals(name, label, description, isOptional, commandLinePattern, columns, delimitTable, delimitRows, 0, hasFixedRowCount, parameter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTableParameter12() {
        String name = "Nome_do_parametro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        List<MockColumn> columns = this.createMockColumns();
        boolean delimitTable = false;
        boolean delimitRows = false;
        Integer rowCount = 0;
        new TableParameter(name, label, description, isOptional, true, commandLinePattern, columns, delimitTable, delimitRows, rowCount, null, null, null);
    }

    @Test
    public void testAddTableParameterListener1() {
        TableParameter parameter = this.createMockTableParameter();
        Assert.assertEquals(Collections.emptyList(), (Object)parameter.getTableParameterListeners());
        MockTableParameterListener listener = new MockTableParameterListener();
        parameter.addTableParameterListener((TableParameterListener)listener);
        Assert.assertEquals(Arrays.asList(listener), (Object)parameter.getTableParameterListeners());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testAddTableParameteListener2() {
        TableParameter parameter = this.createMockTableParameter();
        TableParameterListener listener = null;
        try {
            parameter.addTableParameterListener(listener);
        }
        finally {
            Assert.assertEquals(Collections.emptyList(), (Object)parameter.getTableParameterListeners());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=UnsupportedOperationException.class)
    public void testGetColumns1() {
        int expectedColumnCount = 3;
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        for (int i = 0; i < expectedColumnCount; ++i) {
            columns.add(this.createMockColumn(Integer.toString(i)));
        }
        TableParameter parameter = this.createMockTableParameter(columns);
        Assert.assertEquals((long)expectedColumnCount, (long)parameter.getColumnCount());
        try {
            parameter.getColumns().clear();
        }
        finally {
            Assert.assertEquals((long)expectedColumnCount, (long)parameter.getColumnCount());
        }
    }

    @Test
    public void testGetItemValue1() {
        int j;
        Random random = new Random();
        int expectedRowCount = 10;
        int expectedColumnCount = 3;
        int[][] defaultValues = new int[expectedRowCount][expectedColumnCount];
        for (int i = 0; i < expectedRowCount; ++i) {
            for (j = 0; j < expectedColumnCount; ++j) {
                defaultValues[i][j] = random.nextInt();
            }
        }
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        for (j = 0; j < expectedColumnCount; ++j) {
            MockColumn column = this.createMockColumn(Integer.toString(j), j);
            columns.add(column);
            for (int i = 0; i < expectedRowCount; ++i) {
                column.addDefaultValue(i, defaultValues[i][j]);
            }
        }
        TableParameter parameter = this.createMockTableParameter(columns, expectedRowCount);
        for (int i = 0; i < expectedRowCount; ++i) {
            for (int j2 = 0; j2 < expectedColumnCount; ++j2) {
                Assert.assertEquals((Object)defaultValues[i][j2], (Object)parameter.getItemValue(i, j2));
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetItemValue2() {
        int expectedColumnCount = 3;
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        for (int j = 0; j < expectedColumnCount; ++j) {
            MockColumn column = this.createMockColumn(Integer.toString(j), j);
            columns.add(column);
        }
        int expectedRowCount = 5;
        TableParameter parameter = this.createMockTableParameter(columns, expectedRowCount);
        parameter.getItemValue(-1, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetItemValue3() {
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        for (int j = 0; j < 3; ++j) {
            MockColumn column = this.createMockColumn(Integer.toString(j), j);
            columns.add(column);
        }
        int expectedRowCount = 5;
        TableParameter parameter = this.createMockTableParameter(columns, expectedRowCount);
        parameter.getItemValue(expectedRowCount, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=UnsupportedOperationException.class)
    public void testGetTableParameterListeners1() {
        TableParameter parameter = this.createMockTableParameter();
        MockTableParameterListener listener = new MockTableParameterListener();
        parameter.addTableParameterListener((TableParameterListener)listener);
        try {
            parameter.getTableParameterListeners().clear();
        }
        catch (Throwable throwable) {
            Assert.assertEquals(Arrays.asList(listener), (Object)parameter.getTableParameterListeners());
            throw throwable;
        }
        Assert.assertEquals(Arrays.asList(listener), (Object)parameter.getTableParameterListeners());
    }

    @Test
    public void testSetItemValue1() {
        int rowCount = 10;
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        int expectedColumnCount = 3;
        for (int j = 0; j < expectedColumnCount; ++j) {
            columns.add(this.createMockColumn(Integer.toString(j), null));
        }
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        for (int i = 0; i < parameter.getRowCount(); ++i) {
            for (int j = 0; j < parameter.getColumnCount(); ++j) {
                Assert.assertNull((Object)parameter.getItemValue(i, j));
            }
        }
        String newValue = "Novo_Valor";
        CheckParameterListener listener = new CheckParameterListener();
        parameter.addSimpleParameterListener(listener);
        listener.allowChangeValue();
        int rowIndex = 0;
        int columnIndex = 0;
        Assert.assertTrue((boolean)parameter.setItemValue((Object)newValue, rowIndex, columnIndex));
        Assert.assertEquals((long)1L, (long)listener.getHowManyEventsOccurred());
        for (int i = 1; i < parameter.getRowCount(); ++i) {
            for (int j = 1; j < parameter.getColumnCount(); ++j) {
                Assert.assertNull((Object)parameter.getItemValue(i, j));
            }
        }
        Assert.assertEquals((Object)newValue, (Object)parameter.getItemValue(rowIndex, columnIndex));
    }

    @Test
    public void testSetItemValue2() {
        int rowCount = 10;
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        int columnCount = 3;
        for (int j = 0; j < columnCount; ++j) {
            columns.add(this.createMockColumn(Integer.toString(j), null));
        }
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        for (int i = 0; i < parameter.getRowCount(); ++i) {
            for (int j = 0; j < parameter.getColumnCount(); ++j) {
                Assert.assertNull((Object)parameter.getItemValue(i, j));
            }
        }
        String newValue = "Novo_Valor";
        CheckParameterListener listener = new CheckParameterListener();
        parameter.addSimpleParameterListener(listener);
        listener.allowChangeValue();
        int rowIndex = rowCount - 1;
        int columnIndex = columnCount - 1;
        Assert.assertTrue((boolean)parameter.setItemValue((Object)newValue, rowIndex, columnIndex));
        Assert.assertEquals((long)1L, (long)listener.getHowManyEventsOccurred());
        for (int i = 0; i < parameter.getRowCount() - 1; ++i) {
            for (int j = 0; j < parameter.getColumnCount() - 1; ++j) {
                Assert.assertNull((Object)parameter.getItemValue(i, j));
            }
        }
        Assert.assertEquals((Object)newValue, (Object)parameter.getItemValue(rowIndex, columnIndex));
    }

    @Test
    public void testSetItemValue3() {
        Random random = new Random();
        int rowCount = 10;
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        int columnCount = 3;
        int[][] defaultValues = new int[rowCount][columnCount];
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                defaultValues[i][j] = random.nextInt();
            }
        }
        for (int j = 0; j < columnCount; ++j) {
            MockColumn column = this.createMockColumn(Integer.toString(j), null);
            columns.add(column);
            for (int i = 0; i < rowCount; ++i) {
                column.addDefaultValue(i, defaultValues[i][j]);
            }
        }
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        CheckParameterListener listener = new CheckParameterListener();
        parameter.addSimpleParameterListener(listener);
        listener.allowChangeValue();
        int rowIndex = random.nextInt(rowCount);
        int columnIndex = random.nextInt(columnCount);
        Assert.assertTrue((boolean)parameter.setItemValue(null, rowIndex, columnIndex));
        Assert.assertEquals((long)1L, (long)listener.getHowManyEventsOccurred());
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                Object itemValue = parameter.getItemValue(i, j);
                if (i == rowIndex && j == columnIndex) {
                    Assert.assertNull((Object)itemValue);
                    continue;
                }
                Assert.assertEquals((Object)defaultValues[i][j], (Object)itemValue);
            }
        }
    }

    @Test
    public void testSetItemValue4() {
        Random random = new Random();
        int rowCount = 10;
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        int columnCount = 3;
        for (int j = 0; j < columnCount; ++j) {
            MockColumn column = this.createMockColumn(Integer.toString(j), null);
            columns.add(column);
        }
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        CheckParameterListener listener = new CheckParameterListener();
        parameter.addSimpleParameterListener(listener);
        listener.allowChangeValue();
        int rowIndex = random.nextInt(rowCount);
        int columnIndex = random.nextInt(columnCount);
        String newValue = "Novo_valor";
        Assert.assertTrue((boolean)parameter.setItemValue((Object)newValue, rowIndex, columnIndex));
        Assert.assertEquals((long)1L, (long)listener.getHowManyEventsOccurred());
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                Object itemValue = parameter.getItemValue(i, j);
                if (i == rowIndex && j == columnIndex) {
                    Assert.assertEquals((Object)newValue, (Object)itemValue);
                    continue;
                }
                Assert.assertNull((Object)itemValue);
            }
        }
    }

    @Test
    public void testSetItemValue5() {
        Random random = new Random();
        int rowCount = 10;
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        int columnCount = 3;
        int[][] defaultValues = new int[rowCount][columnCount];
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                defaultValues[i][j] = random.nextInt();
            }
        }
        for (int j = 0; j < columnCount; ++j) {
            MockColumn column = this.createMockColumn(Integer.toString(j), null);
            columns.add(column);
            for (int i = 0; i < rowCount; ++i) {
                column.addDefaultValue(i, defaultValues[i][j]);
            }
        }
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        CheckParameterListener listener = new CheckParameterListener();
        parameter.addSimpleParameterListener(listener);
        int rowIndex = random.nextInt(rowCount);
        int columnIndex = random.nextInt(columnCount);
        Assert.assertFalse((boolean)parameter.setItemValue((Object)defaultValues[rowIndex][columnIndex], rowIndex, columnIndex));
        Assert.assertEquals((long)0L, (long)listener.getHowManyEventsOccurred());
    }

    @Test
    public void testSetItemValue6() {
        Random random = new Random();
        int rowCount = 10;
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        int columnCount = 3;
        for (int j = 0; j < columnCount; ++j) {
            MockColumn column = this.createMockColumn(Integer.toString(j), null);
            columns.add(column);
        }
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        CheckParameterListener listener = new CheckParameterListener();
        parameter.addSimpleParameterListener(listener);
        int rowIndex = random.nextInt(rowCount);
        int columnIndex = random.nextInt(columnCount);
        Assert.assertFalse((boolean)parameter.setItemValue(null, rowIndex, columnIndex));
        Assert.assertEquals((long)0L, (long)listener.getHowManyEventsOccurred());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testSetItemValue7() {
        int rowCount = 10;
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        int columnCount = 3;
        for (int j = 0; j < columnCount; ++j) {
            MockColumn column = this.createMockColumn(Integer.toString(j), null);
            columns.add(column);
        }
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        CheckParameterListener listener = new CheckParameterListener();
        parameter.addSimpleParameterListener(listener);
        try {
            parameter.setItemValue(null, -1, 0);
        }
        finally {
            Assert.assertEquals((long)0L, (long)listener.getHowManyEventsOccurred());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testSetItemValue8() {
        int rowCount = 10;
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        int columnCount = 3;
        for (int j = 0; j < columnCount; ++j) {
            MockColumn column = this.createMockColumn(Integer.toString(j), null);
            columns.add(column);
        }
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        CheckParameterListener listener = new CheckParameterListener();
        parameter.addSimpleParameterListener(listener);
        try {
            parameter.setItemValue(null, 0, -1);
        }
        finally {
            Assert.assertEquals((long)0L, (long)listener.getHowManyEventsOccurred());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testSetItemValue9() {
        int rowCount = 10;
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        int columnCount = 3;
        for (int j = 0; j < columnCount; ++j) {
            MockColumn column = this.createMockColumn(Integer.toString(j), null);
            columns.add(column);
        }
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        CheckParameterListener listener = new CheckParameterListener();
        parameter.addSimpleParameterListener(listener);
        try {
            parameter.setItemValue(null, rowCount, 0);
        }
        finally {
            Assert.assertEquals((long)0L, (long)listener.getHowManyEventsOccurred());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testSetItemValue10() {
        int rowCount = 10;
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        int columnCount = 3;
        for (int j = 0; j < columnCount; ++j) {
            MockColumn column = this.createMockColumn(Integer.toString(j), null);
            columns.add(column);
        }
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        CheckParameterListener listener = new CheckParameterListener();
        parameter.addSimpleParameterListener(listener);
        try {
            parameter.setItemValue(null, 0, columnCount);
        }
        finally {
            Assert.assertEquals((long)0L, (long)listener.getHowManyEventsOccurred());
        }
    }

    @Test
    public void testCreateRow1() {
        Integer rowCount = null;
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        for (int i = 0; i < 5; ++i) {
            MockColumn column = this.createMockColumn(Integer.toString(i), i);
            columns.add(column);
        }
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        Assert.assertEquals((long)0L, (long)parameter.getRowCount());
        CheckTableParameterListener listener = new CheckTableParameterListener();
        parameter.addTableParameterListener((TableParameterListener)listener);
        listener.allowCreateRow();
        parameter.createRow();
        Assert.assertEquals((long)1L, (long)listener.getHowManyEventsOccurred());
        Assert.assertEquals((long)1L, (long)parameter.getRowCount());
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            Assert.assertEquals((Object)column.getDefaultValue(), (Object)parameter.getItemValue(0, i));
        }
    }

    @Test
    public void testCreateRow2() {
        Integer rowCount = null;
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        for (int i = 0; i < 5; ++i) {
            MockColumn column = this.createMockColumn(Integer.toString(i), null);
            columns.add(column);
        }
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        Assert.assertEquals((long)0L, (long)parameter.getRowCount());
        CheckTableParameterListener listener = new CheckTableParameterListener();
        parameter.addTableParameterListener((TableParameterListener)listener);
        listener.allowCreateRow();
        parameter.createRow();
        Assert.assertEquals((long)1L, (long)listener.getHowManyEventsOccurred());
        Assert.assertEquals((long)1L, (long)parameter.getRowCount());
        for (int i = 0; i < columns.size(); ++i) {
            Assert.assertNull((Object)parameter.getItemValue(0, i));
        }
    }

    @Test
    public void testCreateRow3() {
        int i;
        Integer rowCount = null;
        int[][] expectedValues = new int[][]{{0, 1}, {10, 11}, {20, 21}};
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        for (int j = 0; j < 2; ++j) {
            MockColumn column = this.createMockColumn(Integer.toString(j), j);
            columns.add(column);
            for (i = 1; i < 3; ++i) {
                column.addDefaultValue(i, expectedValues[i][j]);
            }
        }
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        Assert.assertEquals((long)0L, (long)parameter.getRowCount());
        CheckTableParameterListener listener = new CheckTableParameterListener();
        parameter.addTableParameterListener((TableParameterListener)listener);
        listener.allowCreateRow();
        parameter.createRow();
        Assert.assertEquals((long)1L, (long)listener.getHowManyEventsOccurred());
        parameter.createRow();
        Assert.assertEquals((long)2L, (long)listener.getHowManyEventsOccurred());
        parameter.createRow();
        Assert.assertEquals((long)3L, (long)listener.getHowManyEventsOccurred());
        Assert.assertEquals((long)3L, (long)parameter.getRowCount());
        for (i = 0; i < parameter.getRowCount(); ++i) {
            for (int j = 0; j < columns.size(); ++j) {
                Assert.assertEquals((Object)expectedValues[i][j], (Object)parameter.getItemValue(i, j));
            }
        }
    }

    @Test
    public void testRemoveRow1() {
        Integer rowCount = null;
        int[][] expectedValues = new int[][]{{0, 1}, {10, 11}, {20, 21}, {30, 31}};
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        for (int j = 0; j < 2; ++j) {
            MockColumn column = this.createMockColumn(Integer.toString(j), j);
            columns.add(column);
            for (int i = 0; i < 4; ++i) {
                column.addDefaultValue(i, expectedValues[i][j]);
            }
        }
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        for (int[] expectedValue : expectedValues) {
            parameter.createRow();
        }
        CheckTableParameterListener listener = new CheckTableParameterListener();
        parameter.addTableParameterListener((TableParameterListener)listener);
        listener.allowRemoveRow();
        int removedRowIndex = 1;
        parameter.removeRow(removedRowIndex);
        Assert.assertEquals((long)1L, (long)listener.getHowManyEventsOccurred());
        Assert.assertEquals((long)3L, (long)parameter.getRowCount());
        for (int i = 0; i < parameter.getRowCount(); ++i) {
            if (i == removedRowIndex) continue;
            int rowIndex = i < removedRowIndex ? i : i + 1;
            for (int j = 0; j < columns.size(); ++j) {
                Assert.assertEquals((Object)expectedValues[rowIndex][j], (Object)parameter.getItemValue(i, j));
            }
        }
    }

    @Test
    public void testRemoveRow2() {
        int i;
        Integer rowCount = null;
        int[][] expectedValues = new int[][]{{0, 1}, {10, 11}, {20, 21}, {30, 31}};
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        for (int j = 0; j < 2; ++j) {
            MockColumn column = this.createMockColumn(Integer.toString(j), j);
            columns.add(column);
            for (i = 0; i < 4; ++i) {
                column.addDefaultValue(i, expectedValues[i][j]);
            }
        }
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        for (int[] expectedValue : expectedValues) {
            parameter.createRow();
        }
        CheckTableParameterListener listener = new CheckTableParameterListener();
        parameter.addTableParameterListener((TableParameterListener)listener);
        listener.allowRemoveRow();
        parameter.removeRow(parameter.getRowCount() - 1);
        Assert.assertEquals((long)1L, (long)listener.getHowManyEventsOccurred());
        Assert.assertEquals((long)3L, (long)parameter.getRowCount());
        for (i = 0; i < parameter.getRowCount(); ++i) {
            for (int j = 0; j < columns.size(); ++j) {
                Assert.assertEquals((Object)expectedValues[i][j], (Object)parameter.getItemValue(i, j));
            }
        }
    }

    @Test
    public void testRemoveRow3() {
        int i;
        Integer rowCount = null;
        int[][] expectedValues = new int[][]{{0, 1}, {10, 11}, {20, 21}, {30, 31}};
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        for (int j = 0; j < 2; ++j) {
            MockColumn column = this.createMockColumn(Integer.toString(j), j);
            columns.add(column);
            for (i = 0; i < 4; ++i) {
                column.addDefaultValue(i, expectedValues[i][j]);
            }
        }
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        for (int[] expectedValue : expectedValues) {
            parameter.createRow();
        }
        CheckTableParameterListener listener = new CheckTableParameterListener();
        parameter.addTableParameterListener((TableParameterListener)listener);
        listener.allowRemoveRow();
        parameter.removeRow(0);
        Assert.assertEquals((long)1L, (long)listener.getHowManyEventsOccurred());
        Assert.assertEquals((long)3L, (long)parameter.getRowCount());
        for (i = 0; i < parameter.getRowCount(); ++i) {
            for (int j = 0; j < columns.size(); ++j) {
                Assert.assertEquals((Object)expectedValues[i + 1][j], (Object)parameter.getItemValue(i, j));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testRemoveRow4() {
        int i;
        Integer rowCount = null;
        int[][] expectedValues = new int[][]{{0, 1}, {10, 11}, {20, 21}, {30, 31}};
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        for (int j = 0; j < 2; ++j) {
            MockColumn column = this.createMockColumn(Integer.toString(j), j);
            columns.add(column);
            for (i = 0; i < 4; ++i) {
                column.addDefaultValue(i, expectedValues[i][j]);
            }
        }
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        for (int[] expectedValue : expectedValues) {
            parameter.createRow();
        }
        CheckTableParameterListener listener = new CheckTableParameterListener();
        parameter.addTableParameterListener((TableParameterListener)listener);
        try {
            parameter.removeRow(-1);
        }
        finally {
            Assert.assertEquals((long)0L, (long)listener.getHowManyEventsOccurred());
            Assert.assertEquals((long)4L, (long)parameter.getRowCount());
            for (i = 0; i < parameter.getRowCount(); ++i) {
                for (int j = 0; j < columns.size(); ++j) {
                    Assert.assertEquals((Object)expectedValues[i][j], (Object)parameter.getItemValue(i, j));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testRemoveRow5() {
        int i;
        Integer rowCount = null;
        int[][] expectedValues = new int[][]{{0, 1}, {10, 11}, {20, 21}, {30, 31}};
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        for (int j = 0; j < 2; ++j) {
            MockColumn column = this.createMockColumn(Integer.toString(j), j);
            columns.add(column);
            for (i = 0; i < 4; ++i) {
                column.addDefaultValue(i, expectedValues[i][j]);
            }
        }
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        for (int[] expectedValue : expectedValues) {
            parameter.createRow();
        }
        CheckTableParameterListener listener = new CheckTableParameterListener();
        parameter.addTableParameterListener((TableParameterListener)listener);
        try {
            parameter.removeRow(parameter.getRowCount());
        }
        finally {
            Assert.assertEquals((long)0L, (long)listener.getHowManyEventsOccurred());
            Assert.assertEquals((long)4L, (long)parameter.getRowCount());
            for (i = 0; i < parameter.getRowCount(); ++i) {
                for (int j = 0; j < columns.size(); ++j) {
                    Assert.assertEquals((Object)expectedValues[i][j], (Object)parameter.getItemValue(i, j));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testRemoveRow6() {
        Integer rowCount = null;
        List<MockColumn> columns = this.createMockColumns();
        TableParameter parameter = this.createMockTableParameter(columns, rowCount);
        CheckTableParameterListener listener = new CheckTableParameterListener();
        parameter.addTableParameterListener((TableParameterListener)listener);
        try {
            parameter.removeRow(0);
        }
        finally {
            Assert.assertEquals((long)0L, (long)listener.getHowManyEventsOccurred());
            Assert.assertEquals((long)0L, (long)parameter.getRowCount());
        }
    }

    @Test
    public void testGetCommandValue1() {
        Column<Integer> column1 = this.createCustomCommandColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomCommandColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        column1.addDefaultValue(0, (Object)1);
        column1.addDefaultValue(1, (Object)3);
        column1.addDefaultValue(2, (Object)5);
        column2.addDefaultValue(0, (Object)2);
        column2.addDefaultValue(1, (Object)4);
        column2.addDefaultValue(2, (Object)6);
        int rowCount = 3;
        TableParameter parameter = this.createMockTableParameter(Arrays.asList(column1, column2), rowCount, true, true);
        String commandLineValue = "{{A1,B2},{A3,B4},{A5,B6}}";
        Assert.assertEquals((Object)commandLineValue, (Object)parameter.getCommandValue(null));
    }

    @Test
    public void testGetCommandValue2() {
        Column<Integer> column1 = this.createCustomCommandColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomCommandColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        column1.addDefaultValue(0, (Object)1);
        column1.addDefaultValue(1, (Object)3);
        column1.addDefaultValue(2, (Object)5);
        column2.addDefaultValue(0, (Object)2);
        column2.addDefaultValue(1, (Object)4);
        column2.addDefaultValue(2, (Object)6);
        int rowCount = 3;
        TableParameter parameter = this.createMockTableParameter(Arrays.asList(column1, column2), rowCount, false, true);
        String commandLineValue = "{A1,B2},{A3,B4},{A5,B6}";
        Assert.assertEquals((Object)commandLineValue, (Object)parameter.getCommandValue(null));
    }

    @Test
    public void testGetCommandValue3() {
        Column<Integer> column1 = this.createCustomCommandColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomCommandColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        column1.addDefaultValue(0, (Object)1);
        column1.addDefaultValue(1, (Object)3);
        column1.addDefaultValue(2, (Object)5);
        column2.addDefaultValue(0, (Object)2);
        column2.addDefaultValue(1, (Object)4);
        column2.addDefaultValue(2, (Object)6);
        int rowCount = 3;
        TableParameter parameter = this.createMockTableParameter(Arrays.asList(column1, column2), rowCount, true, false);
        String commandLineValue = "{A1,B2,A3,B4,A5,B6}";
        Assert.assertEquals((Object)commandLineValue, (Object)parameter.getCommandValue(null));
    }

    @Test
    public void testGetCommandValue4() {
        Column<Integer> column1 = this.createCustomCommandColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomCommandColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        column1.addDefaultValue(0, (Object)1);
        column1.addDefaultValue(1, (Object)3);
        column1.addDefaultValue(2, (Object)5);
        column2.addDefaultValue(0, (Object)2);
        column2.addDefaultValue(1, (Object)4);
        column2.addDefaultValue(2, (Object)6);
        int rowCount = 3;
        TableParameter parameter = this.createMockTableParameter(Arrays.asList(column1, column2), rowCount, false, false);
        String commandLineValue = "A1,B2,A3,B4,A5,B6";
        Assert.assertEquals((Object)commandLineValue, (Object)parameter.getCommandValue(null));
    }

    @Test
    public void testGetCommandValue5() {
        Column<Integer> column1 = this.createCustomCommandColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomCommandColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        TableParameter parameter = this.createMockTableParameter(Arrays.asList(column1, column2), null, false, false);
        Object commandLineValue = null;
        Assert.assertEquals(commandLineValue, (Object)parameter.getCommandValue(null));
    }

    @Test
    public void testGetValueAsText1() {
        Column<Integer> column1 = this.createCustomValueAsTextColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomValueAsTextColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        column1.addDefaultValue(0, (Object)1);
        column1.addDefaultValue(1, (Object)3);
        column1.addDefaultValue(2, (Object)5);
        column2.addDefaultValue(0, (Object)2);
        column2.addDefaultValue(1, (Object)4);
        column2.addDefaultValue(2, (Object)6);
        int rowCount = 3;
        TableParameter parameter = this.createMockTableParameter(Arrays.asList(column1, column2), rowCount, false, false);
        String valueAsText = "{{A1,B2},{A3,B4},{A5,B6}}";
        Assert.assertEquals((Object)valueAsText, (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsText2() {
        Column<Integer> column1 = this.createCustomValueAsTextColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomValueAsTextColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        column1.addDefaultValue(0, (Object)1);
        column1.addDefaultValue(1, (Object)3);
        column1.addDefaultValue(2, (Object)5);
        column2.addDefaultValue(0, (Object)2);
        column2.addDefaultValue(1, (Object)4);
        column2.addDefaultValue(2, (Object)6);
        TableParameter parameter = this.createMockTableParameter(Arrays.asList(column1, column2), null, false, false);
        Object valueAsText = null;
        Assert.assertEquals(valueAsText, (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsText3() {
        Column<Integer> column1 = this.createCustomValueAsTextColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomValueAsTextColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        column1.addDefaultValue(0, (Object)1);
        column1.addDefaultValue(2, (Object)5);
        column2.addDefaultValue(0, (Object)2);
        column2.addDefaultValue(2, (Object)6);
        int rowCount = 3;
        TableParameter parameter = this.createMockTableParameter(Arrays.asList(column1, column2), rowCount, false, false);
        String valueAsText = "{{A1,B2},{,},{A5,B6}}";
        Assert.assertEquals((Object)valueAsText, (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsText4() {
        Column<Integer> column1 = this.createCustomValueAsTextColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomValueAsTextColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        column1.addDefaultValue(1, (Object)3);
        column1.addDefaultValue(2, (Object)5);
        column2.addDefaultValue(1, (Object)4);
        column2.addDefaultValue(2, (Object)6);
        int rowCount = 3;
        TableParameter parameter = this.createMockTableParameter(Arrays.asList(column1, column2), rowCount, false, false);
        String valueAsText = "{{,},{A3,B4},{A5,B6}}";
        Assert.assertEquals((Object)valueAsText, (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsText5() {
        Column<Integer> column1 = this.createCustomValueAsTextColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomValueAsTextColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        column1.addDefaultValue(0, (Object)1);
        column1.addDefaultValue(1, (Object)3);
        column2.addDefaultValue(0, (Object)2);
        column2.addDefaultValue(1, (Object)4);
        int rowCount = 3;
        TableParameter parameter = this.createMockTableParameter(Arrays.asList(column1, column2), rowCount, false, false);
        String valueAsText = "{{A1,B2},{A3,B4},{,}}";
        Assert.assertEquals((Object)valueAsText, (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsText6() {
        Column<Integer> column1 = this.createCustomValueAsTextColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomValueAsTextColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        column1.addDefaultValue(1, (Object)3);
        column1.addDefaultValue(2, (Object)5);
        column2.addDefaultValue(1, (Object)4);
        column2.addDefaultValue(0, (Object)2);
        int rowCount = 3;
        TableParameter parameter = this.createMockTableParameter(Arrays.asList(column1, column2), rowCount, false, false);
        String valueAsText = "{{,B2},{A3,B4},{A5,}}";
        Assert.assertEquals((Object)valueAsText, (Object)parameter.getValueAsText());
    }

    @Test
    public void testSetValueAsText1() throws ParseException {
        Column<Integer> column1 = this.createCustomValueAsTextColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomValueAsTextColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        TableParameter parameter = this.createMockTableParameter(columns, null, false, false);
        String valueAsText = "{{A1,B2},{A3,B4},{A5,B6}}";
        parameter.setValueAsText(valueAsText);
        int rowCount = 3;
        int columnCount = columns.size();
        Integer[][] values = new Integer[][]{{1, 2}, {3, 4}, {5, 6}};
        Assert.assertEquals((long)rowCount, (long)parameter.getRowCount());
        Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                Assert.assertEquals((Object)values[i][j], (Object)parameter.getItemValue(i, j));
            }
        }
    }

    @Test
    public void testSetValueAsText2() throws ParseException {
        Column<Integer> column1 = this.createCustomValueAsTextColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomValueAsTextColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        column1.addDefaultValue(0, (Object)1);
        column1.addDefaultValue(1, (Object)3);
        column1.addDefaultValue(2, (Object)5);
        column2.addDefaultValue(0, (Object)2);
        column2.addDefaultValue(1, (Object)4);
        column2.addDefaultValue(2, (Object)6);
        TableParameter parameter = this.createMockTableParameter(columns, 3, false, false);
        String valueAsText = null;
        parameter.setValueAsText(valueAsText);
        int rowCount = 0;
        int columnCount = columns.size();
        Assert.assertEquals((long)rowCount, (long)parameter.getRowCount());
        Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
    }

    @Test
    public void testSetValueAsText3() throws ParseException {
        Column<Integer> column1 = this.createCustomValueAsTextColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomValueAsTextColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        TableParameter parameter = this.createMockTableParameter(columns, null, false, false);
        String valueAsText = "{{A1,B2},{,},{A5,B6}}";
        parameter.setValueAsText(valueAsText);
        int rowCount = 3;
        int columnCount = columns.size();
        Integer[][] values = new Integer[][]{{1, 2}, {null, null}, {5, 6}};
        Assert.assertEquals((long)rowCount, (long)parameter.getRowCount());
        Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                Assert.assertEquals((Object)values[i][j], (Object)parameter.getItemValue(i, j));
            }
        }
    }

    @Test
    public void testSetValueAsText4() throws ParseException {
        Column<Integer> column1 = this.createCustomValueAsTextColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomValueAsTextColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        TableParameter parameter = this.createMockTableParameter(columns, null, false, false);
        String valueAsText = "{{,},{A3,B4},{A5,B6}}";
        parameter.setValueAsText(valueAsText);
        int rowCount = 3;
        int columnCount = columns.size();
        Integer[][] values = new Integer[][]{{null, null}, {3, 4}, {5, 6}};
        Assert.assertEquals((long)rowCount, (long)parameter.getRowCount());
        Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                Assert.assertEquals((Object)values[i][j], (Object)parameter.getItemValue(i, j));
            }
        }
    }

    @Test
    public void testSetValueAsText5() throws ParseException {
        Column<Integer> column1 = this.createCustomValueAsTextColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomValueAsTextColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        TableParameter parameter = this.createMockTableParameter(columns, null, false, false);
        String valueAsText = "{{A1,B2},{A3,B4},{,}}";
        parameter.setValueAsText(valueAsText);
        int rowCount = 3;
        int columnCount = columns.size();
        Integer[][] values = new Integer[][]{{1, 2}, {3, 4}, {null, null}};
        Assert.assertEquals((long)rowCount, (long)parameter.getRowCount());
        Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                Assert.assertEquals((Object)values[i][j], (Object)parameter.getItemValue(i, j));
            }
        }
    }

    @Test
    public void testSetValueAsText6() throws ParseException {
        Column<Integer> column1 = this.createCustomValueAsTextColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomValueAsTextColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        TableParameter parameter = this.createMockTableParameter(columns, null, false, false);
        String valueAsText = "{{,B2},{A3,B4},{A5,}}";
        parameter.setValueAsText(valueAsText);
        int rowCount = 3;
        int columnCount = columns.size();
        Integer[][] values = new Integer[][]{{null, 2}, {3, 4}, {5, null}};
        Assert.assertEquals((long)rowCount, (long)parameter.getRowCount());
        Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                Assert.assertEquals((Object)values[i][j], (Object)parameter.getItemValue(i, j));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ParseException.class)
    public void testSetValueAsText7() throws ParseException {
        Column<Integer> column1 = this.createCustomValueAsTextColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomValueAsTextColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        TableParameter parameter = this.createMockTableParameter(columns, null, false, false);
        String valueAsText = "n\u00e3o representa uma tabela";
        try {
            parameter.setValueAsText(valueAsText);
        }
        finally {
            int rowCount = 0;
            int columnCount = columns.size();
            Assert.assertEquals((long)rowCount, (long)parameter.getRowCount());
            Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ParseException.class)
    public void testSetValueAsText8() throws ParseException {
        Column<Integer> column1 = this.createCustomValueAsTextColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomValueAsTextColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        TableParameter parameter = this.createMockTableParameter(columns, null, false, false);
        String valueAsText = "{{A1,B2},{\u00edtem_inv\u00e1lido,B4},{A5,B6}}";
        try {
            parameter.setValueAsText(valueAsText);
        }
        finally {
            int rowCount = 0;
            int columnCount = columns.size();
            Assert.assertEquals((long)rowCount, (long)parameter.getRowCount());
            Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ParseException.class)
    public void testSetValueAsText9() throws ParseException {
        Column<Integer> column1 = this.createCustomValueAsTextColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomValueAsTextColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        TableParameter parameter = this.createMockTableParameter(columns, null, false, false);
        String valueAsText = "{{A1,B2},linha_inv\u00e1lida,{A5,B6}}";
        try {
            parameter.setValueAsText(valueAsText);
        }
        finally {
            int rowCount = 0;
            int columnCount = columns.size();
            Assert.assertEquals((long)rowCount, (long)parameter.getRowCount());
            Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ParseException.class)
    public void testSetValueAsText10() throws ParseException {
        Column<Integer> column1 = this.createCustomValueAsTextColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomValueAsTextColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        TableParameter parameter = this.createMockTableParameter(columns, null, false, false);
        String valueAsText = "{{A1,B2},{B4},{A5,B6}}";
        try {
            parameter.setValueAsText(valueAsText);
        }
        finally {
            int rowCount = 0;
            int columnCount = columns.size();
            Assert.assertEquals((long)rowCount, (long)parameter.getRowCount());
            Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ParseException.class)
    public void testSetValueAsText11() throws ParseException {
        Column<Integer> column1 = this.createCustomValueAsTextColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomValueAsTextColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        TableParameter parameter = this.createMockTableParameter(columns, null, false, false);
        String valueAsText = "{{A1,B2},{A1,B4,},{A5,B6}}";
        try {
            parameter.setValueAsText(valueAsText);
        }
        finally {
            int rowCount = 0;
            int columnCount = columns.size();
            Assert.assertEquals((long)rowCount, (long)parameter.getRowCount());
            Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
        }
    }

    @Test
    public void testSetValueAsText12() throws ParseException {
        Column<Integer> column1 = this.createCustomValueAsTextColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomValueAsTextColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        column1.addDefaultValue(0, (Object)1);
        column1.addDefaultValue(1, (Object)3);
        column1.addDefaultValue(2, (Object)5);
        column2.addDefaultValue(0, (Object)2);
        column2.addDefaultValue(1, (Object)4);
        column2.addDefaultValue(2, (Object)6);
        int rowCount = 3;
        TableParameter parameter = this.createMockTableParameter(columns, rowCount, false, false);
        String valueAsText = "{}";
        parameter.setValueAsText(valueAsText);
        int columnCount = columns.size();
        Assert.assertEquals((long)0L, (long)parameter.getRowCount());
        Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
    }

    @Test
    public void testExportValue1() {
        Column<Integer> column1 = this.createCustomExportImportColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomExportImportColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        column1.addDefaultValue(0, (Object)1);
        column1.addDefaultValue(1, (Object)3);
        column1.addDefaultValue(2, (Object)5);
        column2.addDefaultValue(0, (Object)2);
        column2.addDefaultValue(1, (Object)4);
        column2.addDefaultValue(2, (Object)6);
        int rowCount = 3;
        String name = "tabela";
        TableParameter parameter = this.createMockTableParameter(name, Arrays.asList(column1, column2), rowCount, false, false);
        this.checkExportedValue(parameter.exportValue(), name, {"A1", "B2"}, {"A3", "B4"}, {"A5", "B6"});
    }

    @Test
    public void testExportValue2() {
        Column<Integer> column1 = this.createCustomExportImportColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomExportImportColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        column1.addDefaultValue(0, (Object)1);
        column1.addDefaultValue(1, (Object)3);
        column1.addDefaultValue(2, (Object)5);
        column2.addDefaultValue(0, (Object)2);
        column2.addDefaultValue(1, (Object)4);
        column2.addDefaultValue(2, (Object)6);
        String name = "tabela";
        TableParameter parameter = this.createMockTableParameter(name, Arrays.asList(column1, column2), null, false, false);
        this.checkExportedValue(parameter.exportValue(), name, new Object[0][]);
    }

    @Test
    public void testExportValue3() {
        Column<Integer> column1 = this.createCustomExportImportColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomExportImportColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        column1.addDefaultValue(0, (Object)1);
        column1.addDefaultValue(2, (Object)5);
        column2.addDefaultValue(0, (Object)2);
        column2.addDefaultValue(2, (Object)6);
        int rowCount = 3;
        String name = "tabela";
        TableParameter parameter = this.createMockTableParameter(name, Arrays.asList(column1, column2), rowCount, false, false);
        this.checkExportedValue(parameter.exportValue(), name, {"A1", "B2"}, {null, null}, {"A5", "B6"});
    }

    @Test
    public void testExportValue4() {
        Column<Integer> column1 = this.createCustomExportImportColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomExportImportColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        column1.addDefaultValue(1, (Object)3);
        column1.addDefaultValue(2, (Object)5);
        column2.addDefaultValue(1, (Object)4);
        column2.addDefaultValue(2, (Object)6);
        int rowCount = 3;
        String name = "tabela";
        TableParameter parameter = this.createMockTableParameter(name, Arrays.asList(column1, column2), rowCount, false, false);
        this.checkExportedValue(parameter.exportValue(), name, {null, null}, {"A3", "B4"}, {"A5", "B6"});
    }

    @Test
    public void testExportValue5() {
        Column<Integer> column1 = this.createCustomExportImportColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomExportImportColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        column1.addDefaultValue(0, (Object)1);
        column1.addDefaultValue(1, (Object)3);
        column2.addDefaultValue(0, (Object)2);
        column2.addDefaultValue(1, (Object)4);
        int rowCount = 3;
        String name = "tabela";
        TableParameter parameter = this.createMockTableParameter(name, Arrays.asList(column1, column2), rowCount, false, false);
        this.checkExportedValue(parameter.exportValue(), name, {"A1", "B2"}, {"A3", "B4"}, {null, null});
    }

    @Test
    public void testExportValue6() {
        Column<Integer> column1 = this.createCustomExportImportColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomExportImportColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        column1.addDefaultValue(1, (Object)3);
        column1.addDefaultValue(2, (Object)5);
        column2.addDefaultValue(0, (Object)2);
        column2.addDefaultValue(1, (Object)4);
        int rowCount = 3;
        String name = "tabela";
        TableParameter parameter = this.createMockTableParameter(name, Arrays.asList(column1, column2), rowCount, false, false);
        this.checkExportedValue(parameter.exportValue(), name, {null, "B2"}, {"A3", "B4"}, {"A5", null});
    }

    @Test
    public void testImportValue1() {
        Column<Integer> column1 = this.createCustomExportImportColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomExportImportColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        String name = "tabela";
        TableParameter parameter = this.createMockTableParameter(name, columns, null, false, false);
        Map<String, Object> importableValue = this.createImportableValue(name, {"A1", "B2"}, {"A3", "B4"}, {"A5", "B6"});
        parameter.importValue(importableValue);
        int rowCount = 3;
        int columnCount = columns.size();
        Integer[][] values = new Integer[][]{{1, 2}, {3, 4}, {5, 6}};
        Assert.assertEquals((long)rowCount, (long)parameter.getRowCount());
        Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                Assert.assertEquals((Object)values[i][j], (Object)parameter.getItemValue(i, j));
            }
        }
    }

    @Test
    public void testImportValue2() {
        Column<Integer> column1 = this.createCustomExportImportColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomExportImportColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        String name = "tabela";
        TableParameter parameter = this.createMockTableParameter(name, columns, null, false, false);
        Map<String, Object> importableValue = this.createImportableValue(name, new Object[0][]);
        parameter.importValue(importableValue);
        int rowCount = 0;
        int columnCount = columns.size();
        Assert.assertEquals((long)rowCount, (long)parameter.getRowCount());
        Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
    }

    @Test
    public void testImportValue3() {
        Column<Integer> column1 = this.createCustomExportImportColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomExportImportColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        String name = "tabela";
        TableParameter parameter = this.createMockTableParameter(name, columns, null, false, false);
        Map<String, Object> importableValue = this.createImportableValue(name, {"A1", "B2"}, {null, null}, {"A5", "B6"});
        parameter.importValue(importableValue);
        int rowCount = 3;
        int columnCount = columns.size();
        Integer[][] values = new Integer[][]{{1, 2}, {null, null}, {5, 6}};
        Assert.assertEquals((long)rowCount, (long)parameter.getRowCount());
        Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                Assert.assertEquals((Object)values[i][j], (Object)parameter.getItemValue(i, j));
            }
        }
    }

    @Test
    public void testImportValue4() {
        Column<Integer> column1 = this.createCustomExportImportColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomExportImportColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        String name = "tabela";
        TableParameter parameter = this.createMockTableParameter(name, columns, null, false, false);
        Map<String, Object> importableValue = this.createImportableValue(name, {null, null}, {"A3", "B4"}, {"A5", "B6"});
        parameter.importValue(importableValue);
        int rowCount = 3;
        int columnCount = columns.size();
        Integer[][] values = new Integer[][]{{null, null}, {3, 4}, {5, 6}};
        Assert.assertEquals((long)rowCount, (long)parameter.getRowCount());
        Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                Assert.assertEquals((Object)values[i][j], (Object)parameter.getItemValue(i, j));
            }
        }
    }

    @Test
    public void testImportValue5() {
        Column<Integer> column1 = this.createCustomExportImportColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomExportImportColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        String name = "tabela";
        TableParameter parameter = this.createMockTableParameter(name, columns, null, false, false);
        Map<String, Object> importableValue = this.createImportableValue(name, {"A1", "B2"}, {"A3", "B4"}, {null, null});
        parameter.importValue(importableValue);
        int rowCount = 3;
        int columnCount = columns.size();
        Integer[][] values = new Integer[][]{{1, 2}, {3, 4}, {null, null}};
        Assert.assertEquals((long)rowCount, (long)parameter.getRowCount());
        Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                Assert.assertEquals((Object)values[i][j], (Object)parameter.getItemValue(i, j));
            }
        }
    }

    @Test
    public void testImportValue6() {
        Column<Integer> column1 = this.createCustomExportImportColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomExportImportColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        String name = "tabela";
        TableParameter parameter = this.createMockTableParameter(name, columns, null, false, false);
        Map<String, Object> importableValue = this.createImportableValue(name, {null, "B2"}, {"A3", "B4"}, {"A5", null});
        parameter.importValue(importableValue);
        int rowCount = 3;
        int columnCount = columns.size();
        Integer[][] values = new Integer[][]{{null, 2}, {3, 4}, {5, null}};
        Assert.assertEquals((long)rowCount, (long)parameter.getRowCount());
        Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                Assert.assertEquals((Object)values[i][j], (Object)parameter.getItemValue(i, j));
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImportValue7() {
        TableParameter parameter = this.createMockTableParameter();
        parameter.importValue(null);
    }

    @Test
    public void testImportValue8() {
        Column<Integer> column1 = this.createCustomExportImportColumn("id1", null, Arrays.asList(1, 3, 5), Arrays.asList("A1", "A3", "A5"));
        Column<Integer> column2 = this.createCustomExportImportColumn("id2", null, Arrays.asList(2, 4, 6), Arrays.asList("B2", "B4", "B6"));
        List<Column> columns = Arrays.asList(column1, column2);
        column1.addDefaultValue(0, (Object)1);
        column1.addDefaultValue(1, (Object)3);
        column1.addDefaultValue(2, (Object)5);
        column2.addDefaultValue(0, (Object)2);
        column2.addDefaultValue(1, (Object)4);
        column2.addDefaultValue(2, (Object)6);
        String name = "tabela";
        int rowCount = 3;
        int columnCount = columns.size();
        TableParameter parameter = this.createMockTableParameter(name, columns, rowCount, false, false);
        Map<String, Object> importableValue = this.createImportableValue("outra_tabela", {"A8", "B7"}, {"A6", "B5"}, {"A4", "A3"}, {"A2", "B1"}, {"A0", "B-1"});
        parameter.importValue(importableValue);
        Assert.assertEquals((long)0L, (long)parameter.getRowCount());
        Assert.assertEquals((long)columnCount, (long)parameter.getColumnCount());
    }

    private void assertEquals(String name, String label, String description, boolean isOptional, String commandLinePattern, List<? extends Column<?>> columns, boolean delimitTable, boolean delimitRows, int rowCount, boolean hasFixedRowCount, TableParameter parameter) {
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertEquals((Object)commandLinePattern, (Object)parameter.getCommandLinePattern());
        Assert.assertEquals(columns, (Object)parameter.getColumns());
        Assert.assertEquals((Object)delimitTable, (Object)parameter.delimitTable());
        Assert.assertEquals((Object)delimitRows, (Object)parameter.delimitRows());
        Assert.assertEquals((long)rowCount, (long)parameter.getRowCount());
        Assert.assertEquals((Object)hasFixedRowCount, (Object)parameter.hasFixedRowCount());
    }

    private void checkExportedValue(Map<String, Object> exportedMap, String name, Object[] ... rows) {
        Object exportedValue = exportedMap.get(name);
        Assert.assertNotNull((Object)exportedValue);
        Assert.assertTrue((boolean)List.class.isAssignableFrom(exportedValue.getClass()));
        List exportedRowList = (List)exportedValue;
        Assert.assertEquals((long)rows.length, (long)exportedRowList.size());
        for (int i = 0; i < rows.length; ++i) {
            Object[] row = rows[i];
            Object exportedRowAsObject = exportedRowList.get(i);
            Assert.assertTrue((boolean)exportedRowAsObject.getClass().isArray());
            Object[] exportedRow = (Object[])exportedRowAsObject;
            Assert.assertTrue((boolean)Arrays.deepEquals(row, exportedRow));
        }
        try {
            exportedMap.clear();
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    private Map<String, Object> createImportableValue(String name, Object[] ... rows) {
        HashMap<String, Object> importableValue = new HashMap();
        List rowList = Arrays.asList(rows);
        importableValue.put(name, rowList);
        importableValue = Collections.unmodifiableMap(importableValue);
        this.checkExportedValue(importableValue, name, rows);
        return importableValue;
    }

    private <T> Column<T> createCustomCommandColumn(String id, T defaultValue, final List<T> values, final List<String> commandValues) {
        return new Column<T>(id, "R\u00f3tulo " + id, defaultValue, false, false){

            public String getCommandValue(T itemValue) {
                if (itemValue == null) {
                    return null;
                }
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (!value.equals(itemValue)) continue;
                    return (String)commandValues.get(i);
                }
                Assert.fail();
                throw new IllegalStateException();
            }

            public T getItemValueFromText(String itemValue) {
                return null;
            }

            public String getItemValueAsText(T itemValue) {
                return null;
            }

            public Object getValueToExport(T cellValue) {
                return null;
            }

            public T getValueToImport(Object importedValue) {
                return null;
            }
        };
    }

    private <T> Column<T> createCustomValueAsTextColumn(String id, T defaultValue, final List<T> values, final List<String> valuesAsText) {
        return new Column<T>(id, "R\u00f3tulo " + id, defaultValue, false, false){

            public String getItemValueAsText(T itemValue) {
                if (itemValue == null) {
                    return null;
                }
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (!value.equals(itemValue)) continue;
                    return (String)valuesAsText.get(i);
                }
                Assert.fail();
                throw new IllegalStateException();
            }

            public T getItemValueFromText(String itemValue) throws ParseException {
                if (itemValue == null) {
                    return null;
                }
                for (int i = 0; i < valuesAsText.size(); ++i) {
                    String valueAsText = (String)valuesAsText.get(i);
                    if (!valueAsText.equals(itemValue)) continue;
                    return values.get(i);
                }
                throw new ParseException("\u00cdtem n\u00e3o encontrado.\nValor: {0}.\n", new Object[]{itemValue});
            }

            public String getCommandValue(T itemValue) {
                return null;
            }

            public Object getValueToExport(T cellValue) {
                return null;
            }

            public T getValueToImport(Object importedValue) {
                return null;
            }
        };
    }

    private <T> Column<T> createCustomExportImportColumn(String id, T defaultValue, final List<T> values, final List<Object> exportImportValues) {
        return new Column<T>(id, "R\u00f3tulo " + id, defaultValue, false, false){

            public Object getValueToExport(T itemValue) {
                if (itemValue == null) {
                    return null;
                }
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (!value.equals(itemValue)) continue;
                    return exportImportValues.get(i);
                }
                Assert.fail();
                throw new IllegalStateException();
            }

            public T getValueToImport(Object importedValue) {
                if (importedValue == null) {
                    return null;
                }
                for (int i = 0; i < exportImportValues.size(); ++i) {
                    Object exportImportValue = exportImportValues.get(i);
                    if (!exportImportValue.equals(importedValue)) continue;
                    return values.get(i);
                }
                Assert.fail();
                throw new IllegalStateException();
            }

            public String getItemValueAsText(T itemValue) {
                return null;
            }

            public T getItemValueFromText(String itemValue) {
                return null;
            }

            public String getCommandValue(T itemValue) {
                return null;
            }
        };
    }

    private List<MockColumn> createMockColumns() {
        LinkedList<MockColumn> columns = new LinkedList<MockColumn>();
        for (int i = 0; i < 10; ++i) {
            String id = Integer.toString(i);
            MockColumn mockColumn = this.createMockColumn(id, i);
            columns.add(mockColumn);
        }
        return columns;
    }

    private MockColumn createMockColumn(String id) {
        MockColumn mockColumn = this.createMockColumn(id, id);
        return mockColumn;
    }

    private MockColumn createMockColumn(String id, Object defaultValue) {
        String label = "R\u00f3tulo " + id;
        boolean isOptional = true;
        boolean isEditable = true;
        MockColumn mockColumn = new MockColumn(id, label, defaultValue, isOptional, isEditable);
        return mockColumn;
    }

    private TableParameter createMockTableParameter() {
        List<MockColumn> columns = this.createMockColumns();
        return this.createMockTableParameter(columns);
    }

    private TableParameter createMockTableParameter(List<? extends Column<?>> columns) {
        int rowCount = 10;
        return this.createMockTableParameter(columns, rowCount);
    }

    private TableParameter createMockTableParameter(List<? extends Column<?>> columns, Integer rowCount) {
        boolean delimitTable = false;
        boolean delimitRows = false;
        return this.createMockTableParameter(columns, rowCount, delimitTable, delimitRows);
    }

    private TableParameter createMockTableParameter(List<? extends Column<?>> columns, Integer rowCount, boolean delimitTable, boolean delimitRows) {
        String name = "Nome_do_parametro";
        return this.createMockTableParameter(name, columns, rowCount, delimitTable, delimitRows);
    }

    private TableParameter createMockTableParameter(String name, List<? extends Column<?>> columns, Integer rowCount, boolean delimitTable, boolean delimitRows) {
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        TableParameter parameter = new TableParameter(name, label, description, isOptional, true, commandLinePattern, columns, delimitTable, delimitRows, rowCount, null, null, null);
        return parameter;
    }
}

